/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.table.SemClient;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ClientObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.util.GUIDGenerator;
import javax.swing.Icon;

public class UserObject
extends ClientObject {
    public static final int POLICY_MODE_INT = 0;
    public static final Integer POLICY_MODE = 0;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_IMPORT_FROM_DOMAIN = 1;
    public static final int MODE_IMPORT_FROM_LDAP = 2;
    public static final int IMPORT_LDAP_LOGON_NAME = 0;
    public static final int IMPORT_LDAP_DOMAIN_NAME = 1;
    public static final int IMPORT_LDAP_FULL_NAME = 2;
    private int importMode = 0;

    public UserObject() {
        this.client = new SemClient();
        this.client.setClientId(new GUIDGenerator().getGUIDString());
        this.client.setOptDomainId(Manager.getCurrentDomainId());
        this.client.setOptCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setOptCreator(Integer.valueOf(0));
        this.client.setOptPolicyMode(POLICY_MODE);
        this.client.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setUSN(Long.valueOf(0L));
        this.client.setDeleted(Integer.valueOf(0));
    }

    public UserObject(String groupId, String userName, String fullName, String domainName) {
        this.client = new SemClient();
        this.client.setClientId(new GUIDGenerator().getGUIDString());
        this.client.setOptDomainId(Manager.getCurrentDomainId());
        this.client.setOptGroupId(groupId);
        this.client.setOptUserName(userName);
        this.client.setOptFullName(fullName);
        this.client.setOptUserDomainName(domainName);
        this.client.setOptCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setOptCreator(Integer.valueOf(0));
        this.client.setOptPolicyMode(POLICY_MODE);
        this.client.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.client.setUSN(Long.valueOf(0L));
        this.client.setDeleted(Integer.valueOf(0));
    }

    public UserObject(SemClient client) {
        this.client = client;
    }

    public int getImportMode() {
        return this.importMode;
    }

    public void setSemClient(SemClient client) {
        this.client = client;
    }

    public void setImportMode(int mode) {
        this.importMode = mode;
    }

    @Override
    public String getName() {
        return this.getUserName();
    }

    @Override
    public void setName(String string) {
        this.setUserName(string);
    }

    @Override
    public String getDomainName() {
        return this.getUserDomainName();
    }

    @Override
    public void setDomainName(String value) {
        this.setUserDomainName(value);
    }

    @Override
    public String getLoginName() {
        return this.getComputerName();
    }

    @Override
    public void setLoginName(String value) {
        this.setComputerName(value);
    }

    @Override
    public int getMode() {
        return 0;
    }

    @Override
    public Icon getOnlineIconForLocal() {
        return ConsoleMain.userOnIcon;
    }

    @Override
    public Icon getOnlineIconForRemoteServer() {
        return ConsoleMain.userOnIcon;
    }

    @Override
    public Icon getOnlineIconForRemoteSite() {
        return ConsoleMain.userOnRemoteIcon;
    }

    @Override
    public Icon getOfflineIcon() {
        return ConsoleMain.userIcon;
    }

    @Override
    public Icon getInstallErrorIcon() {
        return ConsoleMain.installErrorIcon;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (this.importMode == 0) {
            super.setValueAt(value, index);
            return;
        }
        switch (index) {
            case 0: {
                this.setName(((JLabelData)value).getText());
                break;
            }
            case 1: {
                this.setDomainName((String)value);
                break;
            }
            case 2: {
                this.setFullName((String)value);
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        if (this.importMode == 0) {
            return super.getValueAt(index);
        }
        switch (index) {
            case 0: {
                return new JLabelData(this.getName(), this.getOfflineIcon());
            }
            case 1: {
                return this.getDomainName();
            }
            case 2: {
                return this.getFullName();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (this.importMode == 0) {
            return super.getValueTypeAt(index);
        }
        switch (index) {
            case 0: {
                return JLabelData.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }
}

