/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.ArbitrationPolicy;
import com.sygate.scm.common.configobject.schema.GeneralGui;
import com.sygate.scm.common.configobject.schema.GuiNotification;
import com.sygate.scm.common.configobject.schema.MasterSwitchButton;
import com.sygate.scm.common.configobject.schema.NotificationDisplayTime;
import com.sygate.scm.common.configobject.schema.SecurityEventNotification;
import com.sygate.scm.common.configobject.schema.UserInterface;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;

public class UserInterfaceObject
extends AbstractUIObject {
    public static final int MODE_CLIENT = 0;
    public static final int MODE_SERVER = 1;
    public static final int MODE_MIXED = 2;
    public static final int ACTIVETIME = 300;
    public static final int ALLOWTIMES = 3;
    private UserInterface _userinterface;

    public UserInterfaceObject(UserInterface _interface) {
        this._userinterface = _interface;
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
    }

    private UserInterface generateUserInterface() {
        UserInterface userInterface = new UserInterface();
        userInterface.setGeneralGui(this.generateGeneralGui());
        return userInterface;
    }

    private GeneralGui generateGeneralGui() {
        GeneralGui gui = new GeneralGui();
        gui.setMasterSwitchButton(this.generateMasterSwitchButton());
        gui.setGuiNotification(this.generateGuiNotification());
        return gui;
    }

    private MasterSwitchButton generateMasterSwitchButton() {
        MasterSwitchButton master = new MasterSwitchButton();
        master.setActiveTimer(Integer.valueOf(0));
        return master;
    }

    private GuiNotification generateGuiNotification() {
        SecurityEventNotification eventNotification = new SecurityEventNotification();
        NotificationDisplayTime displayTime = new NotificationDisplayTime();
        GuiNotification guiNotify = new GuiNotification();
        guiNotify.setOptSecurityEventNotification(eventNotification);
        guiNotify.setOptNotificationDisplayTime(displayTime);
        return guiNotify;
    }

    public UserInterface getUserInterface() {
        return this._userinterface;
    }

    public UserInterfaceObject getClone() throws ConsoleException {
        try {
            UserInterface newInterface = null;
            if (this._userinterface != null) {
                newInterface = (UserInterface)PolicyHandler.getCopyOfObj((ConfigObject)this._userinterface);
            }
            UserInterfaceObject newObj = new UserInterfaceObject(newInterface);
            return newObj;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public boolean isAppDeviceCtrlEnabled() {
        if (this._userinterface != null) {
            Boolean enabled = this._userinterface.getGeneralGui().getOptEnableApplicationDeviceControl();
            if (enabled != null) {
                return enabled;
            }
            return this._userinterface.getGeneralGui().getDefEnableApplicationDeviceControl();
        }
        return true;
    }

    public void setAppDeviceCtrlEnable(boolean enable) {
        boolean oldValue = this.isAppDeviceCtrlEnabled();
        if (oldValue == enable) {
            return;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        this._userinterface.getGeneralGui().setOptEnableApplicationDeviceControl(Boolean.valueOf(enable));
    }

    public boolean isMetroNotificationEnabled() {
        if (this._userinterface != null) {
            Boolean enabled = this._userinterface.getGeneralGui().getOptEnableMetroNotification();
            if (enabled != null) {
                return enabled;
            }
            return this._userinterface.getGeneralGui().getDefEnableMetroNotification();
        }
        return true;
    }

    public void setMetroNotificationEnable(boolean enable) {
        boolean oldValue = this.isMetroNotificationEnabled();
        if (oldValue == enable) {
            return;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        this._userinterface.getGeneralGui().setOptEnableMetroNotification(Boolean.valueOf(enable));
    }

    public int getMode() {
        if (this._userinterface != null) {
            Integer strMode = this._userinterface.getOptMode();
            if (strMode == null) {
                return 1;
            }
            if (strMode.equals(UserInterface.SERVER_CTRL)) {
                return 1;
            }
            if (strMode.equals(UserInterface.CLIENT_CTRL)) {
                return 0;
            }
            if (strMode.equals(UserInterface.MIXED_CTRL)) {
                return 2;
            }
        }
        return 1;
    }

    public boolean setMode(int mode) {
        int oldMode = this.getMode();
        if (oldMode == mode) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        switch (mode) {
            case 0: {
                this._userinterface.setOptMode(UserInterface.CLIENT_CTRL);
                break;
            }
            case 1: {
                this._userinterface.setOptMode(UserInterface.SERVER_CTRL);
                break;
            }
            case 2: {
                this._userinterface.setOptMode(UserInterface.MIXED_CTRL);
                break;
            }
        }
        return true;
    }

    public boolean getShowAgentGui() {
        GeneralGui gui;
        Boolean enable;
        if (this._userinterface != null && (enable = (gui = this._userinterface.getGeneralGui()).getOptEnable()) != null) {
            return enable;
        }
        return true;
    }

    public boolean setShowAgentGui(boolean newValue) {
        boolean oldValue = this.getShowAgentGui();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptEnable(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getShowTestButton() {
        GeneralGui gui;
        Boolean showButton;
        if (this._userinterface != null && (showButton = (gui = this._userinterface.getGeneralGui()).getOptShowTestButton()) != null) {
            return showButton;
        }
        return true;
    }

    public Integer getNotificationDisplayTime() {
        NotificationDisplayTime time;
        if (this._userinterface != null && (time = this._userinterface.getGeneralGui().getGuiNotification().getOptNotificationDisplayTime()) != null) {
            return time.getOptTime();
        }
        return null;
    }

    public void setNotificationDisplayTime(Integer nTime) {
        GeneralGui gui;
        GuiNotification guiNotify;
        NotificationDisplayTime time;
        if (nTime == null) {
            return;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        if ((time = (guiNotify = (gui = this._userinterface.getGeneralGui()).getGuiNotification()).getOptNotificationDisplayTime()) == null) {
            time = new NotificationDisplayTime();
        }
        time.setOptTime(nTime);
        guiNotify.setOptNotificationDisplayTime(time);
    }

    public boolean setShowTestButton(boolean newValue) {
        boolean oldValue = this.getShowTestButton();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptShowTestButton(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getBackTraceButton() {
        GeneralGui gui;
        Boolean showBackTrace;
        if (this._userinterface != null && (showBackTrace = (gui = this._userinterface.getGeneralGui()).getOptShowBacktraceButton()) != null) {
            return showBackTrace;
        }
        return true;
    }

    public boolean setBackTraceButton(boolean newValue) {
        boolean oldValue = this.getBackTraceButton();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptShowBacktraceButton(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getHideTrayIcon() {
        GeneralGui gui;
        Boolean hide;
        if (this._userinterface != null && (hide = (gui = this._userinterface.getGeneralGui()).getOptHideSystemTrayIcon()) != null) {
            return hide;
        }
        return true;
    }

    public boolean setHideTrayIcon(boolean newValue) {
        boolean oldValue = this.getHideTrayIcon();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptHideSystemTrayIcon(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getAllowAllIpTraffic() {
        Boolean enabled = null;
        if (this._userinterface != null) {
            GeneralGui gui = this._userinterface.getGeneralGui();
            enabled = gui.getOptAllowAllIpTraffic();
        }
        return Utility.getBooleanValue(enabled, (Boolean)true);
    }

    public boolean setAllowAllIpTraffic(boolean newValue) {
        boolean oldValue = this.getAllowAllIpTraffic();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptAllowAllIpTraffic(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getClientAskBeforeAllow() {
        Boolean enabled = null;
        if (this._userinterface != null) {
            GeneralGui gui = this._userinterface.getGeneralGui();
            enabled = gui.getOptClientAskBeforeAllow();
        }
        return Utility.getBooleanValue(enabled, (Boolean)true);
    }

    public boolean setClientAskBeforeAllow(boolean newValue) {
        boolean oldValue = this.getClientAskBeforeAllow();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptClientAskBeforeAllow(Boolean.valueOf(newValue));
        return true;
    }

    public boolean getMasterSwitchButton() {
        GeneralGui gui;
        MasterSwitchButton master;
        Boolean enable;
        if (this._userinterface != null && (enable = (master = (gui = this._userinterface.getGeneralGui()).getMasterSwitchButton()).getOptEnable()) != null) {
            return enable;
        }
        return true;
    }

    public boolean setMasterSwitchButton(boolean newValue) {
        boolean oldValue = this.getMasterSwitchButton();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        MasterSwitchButton master = gui.getMasterSwitchButton();
        master.setOptEnable(Boolean.valueOf(newValue));
        return true;
    }

    public int getActiveTime() {
        if (this._userinterface != null) {
            GeneralGui gui = this._userinterface.getGeneralGui();
            MasterSwitchButton master = gui.getMasterSwitchButton();
            return master.getActiveTimer();
        }
        return 0;
    }

    public boolean setActiveTime(int newValue) {
        int oldValue = this.getActiveTime();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        MasterSwitchButton master = gui.getMasterSwitchButton();
        master.setActiveTimer(Integer.valueOf(newValue));
        return true;
    }

    public void setUserInterface(UserInterfaceObject newUi) {
        this._userinterface = newUi.getUserInterface();
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
    }

    public boolean getSoundNotification() {
        GeneralGui gui;
        GuiNotification notice;
        Boolean sound;
        if (this._userinterface != null && (sound = (notice = (gui = this._userinterface.getGeneralGui()).getGuiNotification()).getOptEnableSoundNotification()) != null) {
            return sound;
        }
        return true;
    }

    public SecurityEventNotification getSecurityEventNotification() {
        if (this._userinterface != null) {
            GeneralGui gui = this._userinterface.getGeneralGui();
            GuiNotification notice = gui.getGuiNotification();
            SecurityEventNotification secNotice = notice.getOptSecurityEventNotification();
            return secNotice;
        }
        return null;
    }

    public void setSecurityEventNotification(SecurityEventNotification secNotice) {
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        GuiNotification notice = gui.getGuiNotification();
        notice.setOptSecurityEventNotification(secNotice);
    }

    public boolean setSoundNotification(boolean newValue) {
        GeneralGui gui;
        GuiNotification notice;
        Boolean sound;
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        if ((sound = (notice = (gui = this._userinterface.getGeneralGui()).getGuiNotification()).getOptEnableSoundNotification()) == null) {
            notice.setOptEnableSoundNotification(Boolean.valueOf(newValue));
        } else if (sound != newValue) {
            notice.setOptEnableSoundNotification(Boolean.valueOf(newValue));
        } else {
            return false;
        }
        return true;
    }

    public boolean getFlashIcon() {
        if (this._userinterface != null) {
            GeneralGui gui = this._userinterface.getGeneralGui();
            GuiNotification notice = gui.getGuiNotification();
            Boolean flash = notice.getOptEnableIconFlashingOnNotification();
            if (flash == null) {
                flash = notice.getDefEnableIconFlashingOnNotification();
            }
            return flash;
        }
        return false;
    }

    public boolean setFlashIcon(boolean newValue) {
        boolean oldValue = this.getFlashIcon();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        GuiNotification notice = gui.getGuiNotification();
        notice.setOptEnableIconFlashingOnNotification(Boolean.valueOf(newValue));
        return true;
    }

    public String getArbitrationFeature() {
        ArbitrationPolicy arbi;
        if (this._userinterface != null && (arbi = this._userinterface.getOptArbitrationPolicy()) != null) {
            return arbi.getOptServerControlFeatureList();
        }
        return null;
    }

    public boolean setArbitrationFeature(String newValue) {
        ArbitrationPolicy arbi;
        String oldValue = this.getArbitrationFeature();
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        if ((arbi = this._userinterface.getOptArbitrationPolicy()) == null) {
            arbi = new ArbitrationPolicy();
            this._userinterface.setOptArbitrationPolicy(arbi);
        }
        arbi.setOptServerControlFeatureList(newValue);
        return true;
    }

    public Integer getProtectionType() {
        if (this._userinterface != null) {
            GeneralGui gui = this._userinterface.getGeneralGui();
            MasterSwitchButton master = gui.getMasterSwitchButton();
            Integer allowType = master.getOptAllowDisableBlocking();
            if (allowType == null) {
                allowType = master.getDefAllowDisableBlocking();
            }
            return allowType;
        }
        return MasterSwitchButton.ALL_TRAFFIC;
    }

    public boolean setProtectionType(Integer newValue) {
        Integer oldValue = this.getProtectionType();
        if (oldValue.equals(newValue)) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        MasterSwitchButton master = gui.getMasterSwitchButton();
        master.setOptAllowDisableBlocking(newValue);
        return true;
    }

    public int getAllowTimes() {
        GeneralGui gui;
        MasterSwitchButton master;
        Integer times;
        if (this._userinterface != null && (times = (master = (gui = this._userinterface.getGeneralGui()).getMasterSwitchButton()).getOptAllowedAttempts()) != null) {
            return times;
        }
        return 0;
    }

    public boolean setAllowTimes(int newValue) {
        int oldValue = this.getAllowTimes();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        MasterSwitchButton master = gui.getMasterSwitchButton();
        master.setOptAllowedAttempts(Integer.valueOf(newValue));
        return true;
    }

    public boolean getNTPAllowOnlyAdmin() {
        GeneralGui gui;
        Boolean enabled;
        if (this._userinterface != null && (enabled = (gui = this._userinterface.getGeneralGui()).getOptNTPAllowOnlyAdmin()) != null) {
            return enabled;
        }
        gui = new GeneralGui();
        return gui.getDefNTPAllowOnlyAdmin();
    }

    public boolean setNTPAllowOnlyAdmin(boolean newValue) {
        boolean oldValue = this.getNTPAllowOnlyAdmin();
        if (oldValue == newValue) {
            return false;
        }
        if (this._userinterface == null) {
            this._userinterface = this.generateUserInterface();
        }
        GeneralGui gui = this._userinterface.getGeneralGui();
        gui.setOptNTPAllowOnlyAdmin(Boolean.valueOf(newValue));
        return true;
    }
}

