/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.TdadPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;

public class TdadPolicyObject
extends PolicyIntObjectBase
implements TableRow {
    private Boolean enabled = false;
    private final DateFormat sdf = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

    public TdadPolicyObject(TdadPolicy tdadPolicy) {
        super((TopLevelObject)tdadPolicy);
    }

    public TdadPolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public TdadPolicyObject(TopLevelObject policy) {
        super(policy);
    }

    public TdadPolicyObject() {
        if (this.policy == null) {
            this.policy = new TdadPolicy();
            TdadPolicy tdadPolicy = (TdadPolicy)this.policy;
            tdadPolicy.setId(new GUIDGenerator().getGUIDString());
            tdadPolicy.setName(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.tdad.tdad", "TdadPolicyObject.DefaultPolicyName"));
        }
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof TdadPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        TdadPolicyObject newObj = new TdadPolicyObject((TdadPolicy)policyObj);
        return newObj;
    }

    public TdadPolicy getTdadPolicy() {
        return (TdadPolicy)this.policy;
    }

    @Override
    public String getTargetName() {
        return "TdadPolicyApplied";
    }

    @Override
    public String getTargetType() {
        return "TdadPolicy";
    }

    @Override
    public String getRefTargetName() {
        return ((TdadPolicy)this.policy).getName();
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalTdadPolicy";
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.tdad.tdad", "TdadLibraryObject.TdadLibraryDesc");
    }

    public void setDesc(String desc) {
        ((TdadPolicy)this.policy).setOptDescription(desc);
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.enabled;
            }
            case 1: {
                return ((TdadPolicy)this.policy).getName();
            }
            case 2: {
                return ((TdadPolicy)this.policy).getOptDescription();
            }
            case 3: {
                return "N/A";
            }
            case 4: {
                long latestT = PolicyHandler.getLatestT((ConfigObject)this.policy);
                Date updateTime = new Date(latestT);
                return this.sdf.format(updateTime);
            }
        }
        return "This should not happen";
    }

    @Override
    public Class<?> getValueTypeAt(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    public boolean isDirty() {
        return true;
    }

    @Override
    public int getItemType() {
        return 308;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((TdadPolicy)this.policy).getOptEnable(), (Boolean)((TdadPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((TdadPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String toString() {
        if (this.getEnabled()) {
            return this.getName();
        }
        Object[] args = new Object[]{this.getName(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.DisabledIPS")};
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.IPSName"), args);
    }

    @Override
    public String getCreator() {
        return null;
    }

    @Override
    public void setCreator(String creator) {
    }
}

