/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.LuPackageContent;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.SecurityFixContentInfo;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SecurityFixContentInfoObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.client.PackageWorker;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.MacPackageFormatHelper;
import com.sygate.scm.util.PackageUtil;
import com.sygate.scm.util.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.Vector;

public class SoftwarePackageObject {
    public static final int TYPE_SPA = 105;
    public static final int TYPE_SEA = 151;
    private static final int TYPE_UNKNOWN = -1;
    public static final int SAV = 105;
    public static final int SNAC = 151;
    public static final int SNAC_ON_DEMAND = 300;
    public static final int SNAC_ON_DEMAND_HOSTED = 301;
    private static final String combinedPackageString = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.packageDisplayString");
    private final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.av.logicobject.avlogicobject");
    public static final String LANGUAGE_ENGLISH = "en_us";
    public static final String PROP_PKG_SIZE_WITHOUT_DEFS = "PkgSizeWithoutDefs";
    public static final int PACKAGENAME_MAXLENGTH = 128;
    SoftwarePackage softwarePackage = null;
    public static final int VALID_PACKAGE_OK = 0;
    public static final int VALID_PACKAGE_NO_TYPE = 2;
    public static final int VALID_PACKAGE_NO_VERSION = 3;
    public static final int VALID_PACKAGE_NOT_SUPPORTED_VERSION = 4;
    public static final int VALID_PACKAGE_NO_WIAIDINI = 5;
    public static final int VALID_PACKAGE_NO_SETAIDINI = 6;
    public static final int VALID_PACKAGE_NO_CONFIGXML = 7;
    public static final int VALID_PACKAGE_MISSING_LU_INFO = 8;
    public static final int VALID_PACKAGE_NOT_LICENSED = 9;

    public SoftwarePackageObject() {
    }

    public SoftwarePackageObject(SoftwarePackage softwarePackage) {
        this.softwarePackage = softwarePackage;
    }

    public SoftwarePackage getSoftwarePackage() {
        return this.softwarePackage;
    }

    public boolean isValid() {
        return this.softwarePackage != null;
    }

    public String getId() {
        return this.softwarePackage == null ? null : this.softwarePackage.getId();
    }

    public String getName() {
        return this.softwarePackage == null ? "" : this.softwarePackage.getName();
    }

    public String getDescription() {
        if (this.softwarePackage == null) {
            return "";
        }
        String description = this.softwarePackage.getOptDescription();
        return description == null ? "" : description;
    }

    public boolean setType(String type) {
        if (this.softwarePackage == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        try {
            int t = Integer.parseInt(type);
            this.softwarePackage.getPackageInfo().setType(Integer.valueOf(t));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
        return true;
    }

    public int getType() {
        return this.getTypeInteger();
    }

    public Integer getTypeInteger() {
        if (this.softwarePackage == null) {
            return -1;
        }
        return this.softwarePackage.getPackageInfo().getType();
    }

    public String getVersion() {
        return this.getVersion(false);
    }

    public String getVersion(boolean checkSecurityFix) {
        if (this.softwarePackage == null) {
            return "";
        }
        if (checkSecurityFix && this.isSecurityFixContent()) {
            return this.softwarePackage.getPackageInfo().getOptProductBuildNum();
        }
        return this.softwarePackage.getPackageInfo().getVersion();
    }

    public void setVersion(String version) {
        if (this.softwarePackage == null) {
            return;
        }
        this.softwarePackage.getPackageInfo().setVersion(version);
    }

    public void setPkgSizeWithoutDefs(long pkgSize) {
        if (this.softwarePackage == null || this.softwarePackage.getPackageInfo() == null) {
            return;
        }
        this.softwarePackage.getPackageInfo().setOptPkgSizeWithoutDefs(Long.valueOf(pkgSize));
    }

    public Long getPkgSizeWithoutDefs() {
        long oneMB = 0x100000L;
        if (this.softwarePackage == null || this.softwarePackage.getPackageInfo() == null) {
            return null;
        }
        PackageInfo pi = this.softwarePackage.getPackageInfo();
        Long pkgSize = pi.getSize();
        Integer pkgType = pi.getType();
        if (pkgType != null) {
            switch (pkgType) {
                case 105: {
                    pkgSize = pi.getOptPkgSizeWithoutDefs();
                    if (pkgSize != null && !pkgSize.equals(0L)) break;
                    if ("Mac".equals(pi.getOptPlatformType())) {
                        pkgSize = 0x1400000L;
                        break;
                    }
                    if ("WIN32BIT".equals(pi.getOptPlatformType())) {
                        pkgSize = 314572800L;
                        break;
                    }
                    if ("WIN64BIT".equals(pi.getOptPlatformType())) {
                        pkgSize = 314572800L;
                        break;
                    }
                    if ("LINUXRPM".equals(pi.getOptPlatformType())) {
                        pkgSize = 0x1400000L;
                        break;
                    }
                    if ("LINUXDPKG".equals(pi.getOptPlatformType())) {
                        pkgSize = 0x1400000L;
                        break;
                    }
                    if (!PackageUtil.isLinuxStub((String)pi.getOptPlatformType())) break;
                    pkgSize = 0x100000L;
                    break;
                }
                default: {
                    pkgSize = pi.getSize();
                }
            }
        }
        return pkgSize;
    }

    public String getClientPackageDisplayString(boolean checkSecurityFix) {
        String name = SoftwarePackageObject.getClientPackageDisplayString(this.getType());
        String version = this.getVersion(checkSecurityFix);
        String language = this.getLanguageDisplayString();
        Object[] obj = new Object[]{name, version, language};
        String combinedName = MessageFormat.format(combinedPackageString, obj);
        return combinedName;
    }

    public String getClientPackageDisplayStringType() {
        PackageInfo pi = this.softwarePackage.getPackageInfo();
        Object combinedName = this.getClientPackageDisplayString(false);
        combinedName = "Mac".equals(pi.getOptPlatformType()) ? this.MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Mac") + " - " + (String)combinedName : (ConstantValue.isLinuxPlatform((String)pi.getOptPlatformType()) ? this.MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux") + " - " + (String)combinedName : (ConstantValue.isLinuxStubPlatform((String)pi.getOptPlatformType()) ? this.MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_stub") + " - " + (String)combinedName : ("LINUXSTUB_ARM64".equals(pi.getOptPlatformType()) ? this.MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Linux_ARM64") + " - " + (String)combinedName : this.MSG_RES.getString("CurrentPackageObject.platform.columnHeader.Win") + " - " + (String)combinedName)));
        return combinedName;
    }

    public String getTypeDisplayString() {
        return SoftwarePackageObject.getTypeDisplayString(this.getType());
    }

    public void setLanguage(String language) {
        if (this.softwarePackage == null) {
            return;
        }
        this.softwarePackage.getPackageInfo().setOptLanuage(language);
    }

    public String getLanguageDisplayString() {
        String lanCode = this.softwarePackage.getPackageInfo().getOptLanuage();
        if (lanCode != null && lanCode.length() != 0) {
            return SoftwarePackageObject.getString(lanCode.toLowerCase());
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.English");
    }

    public long getSize() {
        if (this.softwarePackage == null) {
            return 0L;
        }
        return this.softwarePackage.getPackageInfo().getSize();
    }

    public String getSizeDisplayString() {
        long size = this.getSize();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.DecimalSizeInMBFollowedByBytes"), nf.format((double)size / 1048576.0), nf.format(size));
        return str;
    }

    public String getSizeInMB() {
        long size = this.getSize();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.DecimalSizeInMB"), nf.format((double)size / 1048576.0));
        return str;
    }

    public long getCreationTime() {
        if (this.softwarePackage == null) {
            return 0L;
        }
        return this.softwarePackage.getCreationTime();
    }

    public String getCreationTimeDisplayString() {
        long time = this.getCreationTime();
        if (time == 0L) {
            return "";
        }
        return UIUtilities.formatDate(time);
    }

    public long getLastModifiedTime() {
        if (this.softwarePackage == null) {
            return 0L;
        }
        return this.softwarePackage.getPackageInfo().getLastModifiedTime();
    }

    public String getLastModifiedTimeDisplayString() {
        long time = this.getLastModifiedTime();
        if (time == 0L) {
            return "";
        }
        return UIUtilities.formatDate(time);
    }

    public String getPackagePhysicalFileId() {
        PackageInfo pi = this.getPackageInfo();
        if (pi == null) {
            return null;
        }
        for (int i = 0; i < pi.getObjReferenceCount(); ++i) {
            ObjReference obj = pi.getObjReference(i);
            if (!obj.getTargetType().equals("PhysicalFile") || !obj.getName().equals("PackageFileLink")) continue;
            return obj.getTargetId();
        }
        return null;
    }

    public ArrayList<String> getPhysicalFileIds() {
        PackageInfo pi = this.getPackageInfo();
        if (pi == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < pi.getObjReferenceCount(); ++i) {
            ObjReference obj = pi.getObjReference(i);
            if (!obj.getTargetType().equals("PhysicalFile")) continue;
            ids.add(obj.getTargetId());
        }
        return ids;
    }

    public PackageInfo getPackageInfo() {
        if (this.softwarePackage == null) {
            return null;
        }
        return this.softwarePackage.getPackageInfo();
    }

    public boolean isInstallationOptionEnabled() {
        InstallationOption option = this.getInstallationOption();
        if (option == null) {
            return false;
        }
        return option.getOptEnable() == null ? option.getDefEnable() : option.getOptEnable();
    }

    public InstallationOption getInstallationOption() {
        if (this.softwarePackage == null) {
            return null;
        }
        return this.softwarePackage.getOptInstallationOption();
    }

    public static InstallationOption newInstallationOption(boolean enabled, boolean isKeepAllDataOnUpgrade, Integer uiLevel) {
        InstallationOption option = new InstallationOption();
        option.setOptEnable(Boolean.valueOf(enabled));
        option.setKeepAllDataOnUpgrade(Boolean.valueOf(isKeepAllDataOnUpgrade));
        option.setUserInterfaceLevel(uiLevel);
        return option;
    }

    public static InstallationOption newInstallationOption(boolean enabled, boolean isKeepAllDataOnUpgrade, Integer uiLevel, boolean enableInstallDir, String installDir, boolean enableCompUnintall, boolean enablePreInstallCleanup, boolean enableInstallLog, String installLogFile, boolean enableStartAgent, boolean enableStartMenu, boolean isMrCleanEnabled, boolean isReducedSizeInstallSpecified) {
        return SoftwarePackageObject.newInstallationOption(enabled, isKeepAllDataOnUpgrade, uiLevel, enableInstallDir, installDir, enableCompUnintall, enablePreInstallCleanup, enableInstallLog, installLogFile, enableStartAgent, enableStartMenu, isMrCleanEnabled, isReducedSizeInstallSpecified, false);
    }

    public static InstallationOption newInstallationOption(boolean enabled, boolean isKeepAllDataOnUpgrade, Integer uiLevel, boolean enableInstallDir, String installDir, boolean enableCompUnintall, boolean enablePreInstallCleanup, boolean enableInstallLog, String installLogFile, boolean enableStartAgent, boolean enableStartMenu, boolean isMrCleanEnabled, boolean isReducedSizeInstallSpecified, Boolean isDarkNetworkSpecified) {
        InstallationOption option = SoftwarePackageObject.newInstallationOption(enabled, isKeepAllDataOnUpgrade, uiLevel);
        option.setOptSpecifyInstallationDirectory(Boolean.valueOf(enableInstallDir));
        option.setOptInstallationDirectory(installDir);
        option.setOptEnableCompetitiveUninstall(Boolean.valueOf(enableCompUnintall));
        option.setOptEnableInstallationLog(Boolean.valueOf(enableInstallLog));
        option.setOptInstallationLogFileName(installLogFile);
        option.setOptEnableMrCleanSubMission(Boolean.valueOf(isMrCleanEnabled));
        option.setOptStartAgentAfterInstallation(Boolean.valueOf(enableStartAgent));
        option.setOptAddProgramIntoStartMenu(Boolean.valueOf(enableStartMenu));
        option.setOptSpecifyReducedInstallSize(Boolean.valueOf(isReducedSizeInstallSpecified));
        if (option.getOptSpecifyReducedInstallSize() != null && !option.getOptSpecifyReducedInstallSize().booleanValue()) {
            option.setOptDarkNetwork(isDarkNetworkSpecified);
        } else {
            option.setOptDarkNetwork(Boolean.valueOf(false));
        }
        return option;
    }

    public InstallationOption cloneInstallationOption() {
        if (this.softwarePackage == null) {
            return null;
        }
        InstallationOption option = this.softwarePackage.getOptInstallationOption();
        if (option == null) {
            return null;
        }
        InstallationOption op = null;
        try {
            op = (InstallationOption)InstallationOption.readXML((byte[])option.getBytes());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return op;
    }

    public CommunicationOption cloneCommunicationOption() {
        if (this.softwarePackage == null) {
            return null;
        }
        CommunicationOption option = this.softwarePackage.getOptCommunicationOption();
        if (option == null) {
            return null;
        }
        CommunicationOption op = null;
        try {
            op = (CommunicationOption)CommunicationOption.readXML((byte[])option.getBytes());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
        return op;
    }

    public PackageInfo clonePackageInfo() {
        if (this.softwarePackage == null) {
            return null;
        }
        PackageInfo packageInfo = this.softwarePackage.getPackageInfo();
        if (packageInfo == null) {
            return null;
        }
        PackageInfo pi = null;
        try {
            pi = (PackageInfo)PackageInfo.readXML((byte[])packageInfo.getBytes());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (pi == null) {
            pi = new PackageInfo();
            pi.setSize(packageInfo.getSize());
            pi.setOptUnZippedSize(packageInfo.getOptUnZippedSize());
            pi.setType(packageInfo.getType());
            pi.setVersion(packageInfo.getVersion());
            pi.setLastModifiedTime(packageInfo.getLastModifiedTime());
            pi.setOptPlatformType(packageInfo.getOptPlatformType());
            pi.setOptReleaseNotesUrl(packageInfo.getOptReleaseNotesUrl());
        }
        for (int i = 0; i < pi.getObjReferenceCount(); ++i) {
            ObjReference obj = pi.getObjReference(i);
            obj.setTargetId(new GUIDGenerator().getGUIDString());
        }
        return pi;
    }

    public void setPackageLuInfo(PackageLuInfo luInfo) {
        if (this.softwarePackage == null) {
            return;
        }
        PackageInfo pkgInfo = this.softwarePackage.getPackageInfo();
        if (pkgInfo == null) {
            return;
        }
        pkgInfo.setOptPackageLuInfo(luInfo);
    }

    public PackageLuInfo getPackageLuInfo() {
        if (this.softwarePackage == null) {
            return null;
        }
        PackageInfo pkgInfo = this.softwarePackage.getPackageInfo();
        if (pkgInfo == null) {
            return null;
        }
        return pkgInfo.getOptPackageLuInfo();
    }

    public static String getClientPackageDisplayString(int type) {
        String key = "SoftwarePackageObject.Type_" + type;
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", key);
    }

    public static String getTypeDisplayString(int type) {
        if (type != 105 && type != 151 && type != 300 && type != 301) {
            type = 105;
        }
        String key = "SoftwarePackageObject.label.Type_" + type;
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", key);
    }

    public static boolean isValidDirectory(String dirName, boolean check_existing) {
        int result = PackageWorker.isValidDir(dirName);
        if (check_existing) {
            return result == 0;
        }
        return result == 0 || result == 1;
    }

    public static int checkValidDirAndDiskSpace(String dirName, boolean check_existing, long sizeRequired) throws IOException {
        int result = PackageWorker.isValidDir(dirName);
        if (check_existing && result != 0) {
            return -1;
        }
        if (result != 0 && result != 1) {
            return -1;
        }
        String existingDir = dirName;
        if (result == 1) {
            existingDir = System.getProperties().getProperty("existing.parent.dir");
        }
        if (NativeCommandUtilities.checkDiskSpaceInConsole(existingDir, sizeRequired)) {
            return result;
        }
        return -2;
    }

    public static boolean isValidPackage(String dirName, SoftwarePackageObject spo, MacPackageFormatHelper pkgFmtHelper) {
        return SoftwarePackageObject.isValidPackage(dirName, spo, pkgFmtHelper, false);
    }

    public static boolean isValidPackage(String dirName, SoftwarePackageObject spo, MacPackageFormatHelper pkgFmtHelper, boolean isIgnoreSylink) {
        int result = SoftwarePackageObject.checkValidPackage(dirName, spo, pkgFmtHelper);
        if (result == 0 || isIgnoreSylink && result == 7) {
            return true;
        }
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.generalerror.FileMissing");
        switch (result) {
            case 2: {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.error.FailedReadPackageTypeinSetAidINI");
                break;
            }
            case 3: {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.error.FailedReadVersionInWiAidINI");
                break;
            }
            case 4: {
                msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.error.UnsupportedPackageImportVersion50OrAbove");
                break;
            }
            case 5: {
                msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.error.FileMissingOrCorruptedInPackage"), String.valueOf("Wiaid.ini"));
                break;
            }
            case 6: {
                msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.error.FileMissingOrCorruptedInPackage"), String.valueOf("Setaid.ini"));
                break;
            }
            case 7: {
                msg = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.error.FileMissingOrCorruptedInPackage"), "sylink.xml");
                break;
            }
            case 9: {
                msg = PackageUtil.getLicenseAbsenceMsg((int)spo.getPackageInfo().getType());
                break;
            }
        }
        System.out.println(">>>>>>>>>>" + MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.title.Error") + "<<<<<<<<<<<<<<<<<<<<<<");
        System.out.println(msg);
        MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwarePackageObject.title.Error"));
        optionPane.init(msg, 60, 0, -1);
        optionPane.show();
        return false;
    }

    private static String getDirForConfigFile(String dirName, String configFileName, MacPackageFormatHelper pkgFmtHelper) {
        String ini = (String)dirName + File.separator + configFileName;
        File tempConfigFile = new File(ini);
        if (!tempConfigFile.exists()) {
            ini = (String)dirName + File.separator + "Configuration" + File.separator + configFileName;
            tempConfigFile = new File(ini);
            if (tempConfigFile.exists()) {
                dirName = (String)dirName + File.separator + "Configuration";
            } else {
                ConsoleLogger.log("SoftwarePackageObject>> checkValidPackage: Error-> no " + ini + "...");
                if (pkgFmtHelper != null) {
                    dirName = (String)dirName + File.separator + pkgFmtHelper.getRelativeConfigDirPath();
                }
            }
        }
        return dirName;
    }

    /*
     * Exception decompiling
     */
    public static int checkValidPackage(String dirName, SoftwarePackageObject spo, MacPackageFormatHelper pkgFmtHelper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK], 16[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setPackageName(String packageName) {
        if (this.softwarePackage == null) {
            return;
        }
        this.softwarePackage.getPackageInfo().setOptPackageName(packageName);
    }

    private static int retrieveLuInfoFromProperties(Properties props, SoftwarePackageObject spo, String iniName) {
        String value;
        String[] luReqAttributes = new String[]{"ServerProduct", "ServerVersion", "ServerLanguage", "ClientProduct", "ClientVersion", "ClientLanguage", "ServerMoniker", "ClientMoniker", "SequenceNumber", "ShortName"};
        String msgPrefix = "SoftwarePackageObject>> retrieveLuInfo: Error-> no ";
        PackageLuInfo luInfo = new PackageLuInfo();
        block12: for (int i = 0; i < luReqAttributes.length; ++i) {
            value = props.getProperty(luReqAttributes[i]);
            if (value == null || value.equals("")) {
                System.out.println(msgPrefix + luReqAttributes[i] + " in " + iniName);
                return 8;
            }
            switch (i) {
                case 0: {
                    luInfo.setServerProduct(value);
                    continue block12;
                }
                case 1: {
                    luInfo.setServerVersion(value);
                    continue block12;
                }
                case 2: {
                    luInfo.setServerLanguage(value);
                    continue block12;
                }
                case 3: {
                    luInfo.setClientProduct(value);
                    continue block12;
                }
                case 4: {
                    luInfo.setClientVersion(value);
                    continue block12;
                }
                case 5: {
                    luInfo.setClientLanguage(value);
                    continue block12;
                }
                case 6: {
                    luInfo.setServerMoniker(value);
                    continue block12;
                }
                case 7: {
                    luInfo.setClientMoniker(value);
                    continue block12;
                }
                case 8: {
                    luInfo.setSequenceNumber(value);
                    continue block12;
                }
                case 9: {
                    luInfo.setShortName(value);
                    continue block12;
                }
            }
        }
        value = props.getProperty("SequenceTag");
        if (value != null && !value.equals("")) {
            luInfo.setOptSequenceTag(value);
        }
        if ((value = props.getProperty("DisplayName")) != null && !value.equals("")) {
            luInfo.setOptDisplayName(value);
        }
        spo.setPackageLuInfo(luInfo);
        return 0;
    }

    public Object cloneEntity() {
        if (null == this.softwarePackage) {
            return null;
        }
        SoftwarePackage copy = null;
        try {
            copy = (SoftwarePackage)SoftwarePackage.readXML((byte[])this.softwarePackage.getBytes());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        PackageInfo pi = this.clonePackageInfo();
        InstallationOption io = this.cloneInstallationOption();
        if (copy == null) {
            copy = new SoftwarePackage();
            copy.setId(new GUIDGenerator().getGUIDString());
            copy.setName(this.softwarePackage.getName());
            copy.setCreationTime(this.softwarePackage.getCreationTime());
            copy.setOptDescription(this.softwarePackage.getOptDescription());
        } else {
            copy.setId(new GUIDGenerator().getGUIDString());
        }
        if (pi != null) {
            copy.setPackageInfo(pi);
        }
        if (io != null) {
            copy.setOptInstallationOption(io);
        }
        copy.setOptCommunicationOption(null);
        return copy;
    }

    public String getFolderNameForExport() {
        String dir = "Type_" + this.getType();
        return dir;
    }

    public String getBuildNumber() {
        if (this.softwarePackage == null) {
            return null;
        }
        String version = this.getVersion(true);
        int index = version.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        String[] result = version.split("\\.", -1);
        return result[2];
    }

    public int getMajorVersion() {
        if (this.softwarePackage == null) {
            return 0;
        }
        return SoftwarePackageObject.getMajorVersion(this.softwarePackage.getPackageInfo().getVersion());
    }

    public static int getMajorVersion(String version) {
        if (version == null || version.length() < 1) {
            return 0;
        }
        int index = version.indexOf(".");
        if (index < 0) {
            return 0;
        }
        version = version.substring(0, index);
        int v = 0;
        try {
            v = Integer.parseInt(version);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return v;
    }

    public static String[] splitVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.length() < 1) {
            return null;
        }
        int index = version.indexOf(".");
        if (index < 0) {
            return null;
        }
        String[] result = version.split("\\.", -1);
        if (result.length < 4) {
            return null;
        }
        return result;
    }

    private static String getSequenceNum(String version) {
        String seqNumber = null;
        if (PackageUtil.is121OrAbove((String)version)) {
            seqNumber = PackageUtil.getSequenceNumber((String)version);
        } else {
            if (version.length() < 1) {
                return null;
            }
            int index = version.indexOf(".");
            if (index < 0) {
                return null;
            }
            String[] result = version.split("\\.", -1);
            if (result.length < 4) {
                return null;
            }
            seqNumber = result[2];
            try {
                if (Integer.parseInt(seqNumber) < 0) {
                    return null;
                }
            }
            catch (NumberFormatException ex) {
                LoggerUtilities.logException((Throwable)ex);
                return null;
            }
        }
        return seqNumber;
    }

    public boolean equals(SoftwarePackage sp) {
        if (sp == null || this.softwarePackage == null) {
            return false;
        }
        return sp.getId().equals(this.softwarePackage.getId());
    }

    public boolean equals(SoftwarePackageObject spo) {
        if (null == spo || null == this.softwarePackage) {
            return false;
        }
        return this.softwarePackage.getId().equals(spo.getId());
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setCheckSum(String checkSum) {
        if (this.softwarePackage == null) {
            return;
        }
        this.softwarePackage.getPackageInfo().setChecksum(checkSum);
    }

    public String getCheckSum() {
        return this.softwarePackage == null ? "" : this.softwarePackage.getPackageInfo().getChecksum();
    }

    public static CommunicationOption newCommunicationOption(String serverListId) {
        CommunicationOption option = new CommunicationOption();
        if (serverListId != null && serverListId.length() > 0) {
            ObjReference ref = new ObjReference();
            ref.setName("SemServerListLink");
            ref.setTargetType("SemServerList");
            ref.setTargetId(serverListId);
            option.setOptObjReference(ref);
        }
        return option;
    }

    public CommunicationOption getCommunicationOption() {
        if (this.softwarePackage == null || this.softwarePackage.getOptCommunicationOption() == null) {
            return null;
        }
        return this.softwarePackage.getOptCommunicationOption();
    }

    public String getServerListId() {
        CommunicationOption option = this.getCommunicationOption();
        if (option == null) {
            return null;
        }
        ObjReference ref = option.getOptObjReference();
        if (ref == null) {
            return null;
        }
        return ref.getTargetId();
    }

    public boolean isSecurityFixContent() {
        ConsoleLogger.log("SoftwarePackageObject>> isSecurityFixContent...");
        boolean result = Boolean.TRUE.equals(this.getPackageInfo().getOptSecurityFixPackage());
        ConsoleLogger.log("SoftwarePackageObject>> isSecurityFixContent, result: " + result);
        return result;
    }

    public SecurityFixContentInfoObject getLatestSecurityFixContentInfoObject() {
        SecurityFixContentInfoObject latestSecurityFixContentInfoObj = null;
        long latestModifyTime = 0L;
        for (SecurityFixContentInfoObject securityFixinfo : this.getSecurityFixContentBuildNumbers()) {
            if (securityFixinfo.getSecurityFixContentInfo().getT() <= latestModifyTime) continue;
            latestSecurityFixContentInfoObj = securityFixinfo;
            latestModifyTime = securityFixinfo.getSecurityFixContentInfo().getT();
        }
        return latestSecurityFixContentInfoObj;
    }

    public Vector<SecurityFixContentInfoObject> getSecurityFixContentBuildNumbers() {
        Vector<SecurityFixContentInfoObject> allSecurityFixContentInfo = new Vector<SecurityFixContentInfoObject>();
        if (!this.isSecurityFixContent()) {
            return allSecurityFixContentInfo;
        }
        PackageLuInfo packageLuInfo = this.getPackageLuInfo();
        String serverMinikor = packageLuInfo.getServerMoniker();
        String serverProduct = packageLuInfo.getServerProduct();
        String serverVersion = packageLuInfo.getServerVersion();
        String serverLanguage = packageLuInfo.getServerLanguage();
        ConsoleLogger.log("SoftwarePackageObject>> getSecurityFixContentBuildNumbers: serverProduct: " + serverProduct + ", serverVersion: " + serverVersion + ", serverLanguage: " + serverLanguage + ", serverMinikor: " + serverMinikor);
        LuDownloadedContentArray luDownloadedContentArray = LuUtility.getLuDownloadedContentArray(true);
        if (luDownloadedContentArray == null) {
            return allSecurityFixContentInfo;
        }
        LuPackageContent securityFixLuPackageContent = null;
        for (LuPackageContent luPackageContent : luDownloadedContentArray.getLuPackageContent()) {
            if (!serverProduct.equals(luPackageContent.getServerProduct()) || !serverVersion.equals(luPackageContent.getServerVersion()) || !serverLanguage.equals(luPackageContent.getServerLanguage())) continue;
            ConsoleLogger.log("SoftwarePackageObject>> getSecurityFixContentBuildNumbers: Found LuPackageContent: " + luPackageContent.toString());
            securityFixLuPackageContent = luPackageContent;
            break;
        }
        if (securityFixLuPackageContent != null) {
            Vector listSecurityFixContentInfo = securityFixLuPackageContent.getSecurityFixContentInfo();
            Collections.sort(listSecurityFixContentInfo, new SecurityFixContentInfoComparator());
            for (SecurityFixContentInfo securityFixContentInfo : listSecurityFixContentInfo) {
                ConsoleLogger.log("SoftwarePackageObject>> getSecurityFixContentBuildNumbers: Add ProductBuildNum: " + securityFixContentInfo.getProductBuildNum());
                allSecurityFixContentInfo.add(new SecurityFixContentInfoObject(securityFixContentInfo));
            }
        }
        return allSecurityFixContentInfo;
    }

    public SecurityFixContentInfoObject getSecurityFixContentInfoObject(String buildNum) {
        SecurityFixContentInfoObject result = null;
        for (SecurityFixContentInfoObject securityFixInfo : this.getSecurityFixContentBuildNumbers()) {
            if (!securityFixInfo.getSecurityFixContentInfo().getProductBuildNum().equalsIgnoreCase(buildNum)) continue;
            result = securityFixInfo;
            break;
        }
        ConsoleLogger.log("SoftwarePackageObject>> hasSecurityFixBuildNumbers: Package: " + this.getName() + ", BuildNum: " + buildNum + ", Result: " + (result == null ? "" : result.toString()));
        return result;
    }

    public static SoftwarePackage newSoftwarePackage(String name, String description) {
        SoftwarePackage softwarePackage = new SoftwarePackage();
        softwarePackage.setId(new GUIDGenerator().getGUIDString());
        softwarePackage.setName(name);
        softwarePackage.setOptDescription(description);
        softwarePackage.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        PackageInfo pi = new PackageInfo();
        pi.setType(Integer.valueOf(1));
        pi.setSize(Long.valueOf(0L));
        pi.setVersion("104");
        pi.setCreationTime(softwarePackage.getCreationTime());
        pi.setLastModifiedTime(softwarePackage.getCreationTime());
        softwarePackage.setPackageInfo(pi);
        InstallationOption option = SoftwarePackageObject.newInstallationOption(false, true, InstallationOption.NORMAL);
        softwarePackage.setOptInstallationOption(option);
        return softwarePackage;
    }

    private static boolean isLicensed(String appType) {
        LicenseObject licenseObject = LicenseObject.getInstance();
        if (!licenseObject.isALLProduct()) {
            boolean isSAVPackage = ClientInstallationFeatureObject.hasCustomizedFeatures(Integer.parseInt(appType));
            return isSAVPackage ? licenseObject.isSAVOnlyProduct() : licenseObject.isSNACOnlyProduct();
        }
        return true;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", key);
    }

    public String getPackageName() {
        PackageInfo packageInfo = this.getPackageInfo();
        if (packageInfo == null) {
            return "Symantec AntiVirus.msi";
        }
        String pName = packageInfo.getOptPackageName();
        if (pName == null) {
            pName = packageInfo.getDefPackageName();
        }
        return pName;
    }

    public long getUnZippedSize() {
        Long unZippedSize = this.softwarePackage.getPackageInfo().getOptUnZippedSize();
        if (unZippedSize != null) {
            return unZippedSize;
        }
        return this.getSize() * 2L;
    }

    public String getPackagePlatformString() {
        String packagePlatform = "WIN32BIT";
        try {
            packagePlatform = this.softwarePackage.getPackageInfo().getOptPlatformType();
            if (StringUtilities.isEmpty((String)packagePlatform)) {
                packagePlatform = this.softwarePackage.getPackageInfo().getDefPlatformType();
            }
        }
        catch (Exception ex) {
            packagePlatform = "WIN32BIT";
        }
        return packagePlatform;
    }

    public int getPackageType() {
        return this.softwarePackage.getPackageInfo().getType();
    }

    public boolean isMacNormalPackage() {
        return "Mac".equalsIgnoreCase(this.getPackagePlatformString()) && (105 == this.getPackageType() || 151 == this.getPackageType());
    }

    public boolean isLinuxNormalPackage() {
        String packagePlatformString = this.getPackagePlatformString();
        boolean isLinuxPlatform = "LINUXRPM".equalsIgnoreCase(packagePlatformString) || "LINUXDPKG".equalsIgnoreCase(packagePlatformString);
        int packageTypeNum = this.getPackageType();
        boolean isSavOrSnacPackage = 105 == packageTypeNum || 151 == packageTypeNum;
        return isLinuxPlatform && isSavOrSnacPackage;
    }

    private static class SecurityFixContentInfoComparator
    implements Comparator<SecurityFixContentInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SecurityFixContentInfoComparator() {
        }

        @Override
        public int compare(SecurityFixContentInfo securityFixContentInfo1, SecurityFixContentInfo securityFixContentInfo2) {
            return securityFixContentInfo2.getSequenceNum().compareTo(securityFixContentInfo1.getSequenceNum());
        }
    }
}

