/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.AutoUpgradeContentOption;
import com.sygate.scm.common.configobject.schema.DeploymentNotification;
import com.sygate.scm.common.configobject.schema.DeploymentNotificationBeforeUpdate;
import com.sygate.scm.common.configobject.schema.DeploymentSchedule;
import com.sygate.scm.common.configobject.schema.DeploymentSnooze;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PackageSource;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentEntity;
import com.sygate.scm.common.configobject.schema.SoftwareDeploymentPolicy;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;

public class SoftwareDeploymentEntityObject {
    public static final int MAX_LENGTH_NOTIFICATION = 128;
    public static final int MAX_LINES_NOTIFICATION = 2;
    protected SoftwareDeploymentEntity deploymentEntity = null;
    protected SoftwarePackageObject softwarePackageObj = null;
    private boolean isSoftwarePackageAvailable;

    public SoftwareDeploymentEntityObject(SoftwareDeploymentEntity deploymentEntity, SoftwarePackage softwarePackage) {
        this(deploymentEntity, softwarePackage, true);
    }

    public SoftwareDeploymentEntityObject(SoftwareDeploymentEntity deploymentEntity, SoftwarePackage softwarePackage, boolean isSoftwarePackageAvailable) {
        this.deploymentEntity = deploymentEntity;
        this.softwarePackageObj = new SoftwarePackageObject(softwarePackage);
        this.isSoftwarePackageAvailable = isSoftwarePackageAvailable;
    }

    public static void modifyDeploymentSchedule(DeploymentSchedule deploymentSchedule, boolean enabled, int startHour, int startMinute, int startSecond, int toHour, int toMinute, int toSecond, int randomizedDays) {
        deploymentSchedule.setOptEnable(Boolean.valueOf(enabled));
        deploymentSchedule.setOptRandomizeTime(Integer.valueOf(randomizedDays * 24 * 3600));
        Schedule schedule = deploymentSchedule.getSchedule();
        if (schedule == null) {
            schedule = new Schedule();
            deploymentSchedule.setSchedule(schedule);
        }
        schedule.setOptEnable(Boolean.TRUE);
        schedule.setOptStartHour(String.valueOf(startHour));
        schedule.setOptStartMinute(Integer.valueOf(startMinute));
        schedule.setOptStartSecond(Integer.valueOf(startSecond));
        boolean sameDay = true;
        if (startHour > toHour) {
            sameDay = false;
        } else if (startHour == toHour) {
            sameDay = startMinute < toMinute ? true : (startMinute > toMinute ? false : startSecond < toSecond);
        }
        int diffHours = sameDay ? toHour - startHour : 24 - startHour + toHour;
        int diffMinutes = toMinute - startMinute;
        int diffSeconds = toSecond - startSecond;
        int duration = diffHours * 3600 + diffMinutes * 60 + diffSeconds;
        System.out.println("setSchedule: " + startHour + "," + startMinute + "," + startSecond + "; " + toHour + "," + toMinute + "," + toSecond + "; " + diffHours + "," + diffMinutes + "," + diffSeconds + "; " + duration);
        deploymentSchedule.setOptDuration(Integer.valueOf(duration));
    }

    public static DeploymentSchedule newDeploymentSchedule(boolean enabled, int startHour, int startMinute, int startSecond, int toHour, int toMinute, int toSecond, int randomizedDays) {
        DeploymentSchedule deploymentSchedule = new DeploymentSchedule();
        Schedule schedule = new Schedule();
        deploymentSchedule.setSchedule(schedule);
        SoftwareDeploymentEntityObject.modifyDeploymentSchedule(deploymentSchedule, enabled, startHour, startMinute, startSecond, toHour, toMinute, toSecond, randomizedDays);
        return deploymentSchedule;
    }

    public static AutoUpgradeContentOption newAutoUpgradeContentOption(boolean includeContentInAutoUpgradePackage) {
        AutoUpgradeContentOption contentOption = new AutoUpgradeContentOption();
        contentOption.setOptIncludeContentInAutoUpgradePackage(Boolean.valueOf(includeContentInAutoUpgradePackage));
        return contentOption;
    }

    public Object cloneEntity() {
        if (this.deploymentEntity == null) {
            return null;
        }
        try {
            ClientInstallationSettingObject sOldInstallSettingsObject;
            ClientInstallationFeatureObject sOldObject;
            SoftwareDeploymentEntity entity = (SoftwareDeploymentEntity)SoftwareDeploymentEntity.readXML((byte[])this.deploymentEntity.getBytes());
            ObjReference objCIFRef = entity.getObjReferenceByType("ClientInstallationFeatures");
            DataobjectManager manager = DataobjectManager.getInstance();
            if (objCIFRef != null && (sOldObject = new ClientInstallationFeatureObject(manager.getClientInstallationFeatures(objCIFRef.getTargetId()))) != null && !sOldObject.isSystemObject()) {
                sOldObject.incRefCount();
                manager.updateClientInstallationFeatures("Merge", sOldObject.getClientInstallationFeatures());
            }
            ObjReference objCIIRef = entity.getObjReferenceByType("ClientInstallationSettings");
            if (objCIFRef != null && (sOldInstallSettingsObject = new ClientInstallationSettingObject(manager.getClientInstallationSettings(objCIIRef.getTargetId()))) != null && !sOldInstallSettingsObject.isSystemObject()) {
                sOldInstallSettingsObject.incRefCount();
                manager.updateClientInstallationSettings("Merge", sOldInstallSettingsObject.getClientInstallationSettings());
            }
            return entity;
        }
        catch (RuntimeException ex) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static SoftwareDeploymentEntityObject newInstanceObject(String packageId) {
        SoftwareDeploymentEntity entity = SoftwareDeploymentEntityObject.newInstance(packageId);
        return new SoftwareDeploymentEntityObject(entity, null);
    }

    public static SoftwareDeploymentEntity newInstance(String packageId) {
        SoftwareDeploymentEntity softwareDeploymentEntity = new SoftwareDeploymentEntity();
        softwareDeploymentEntity.setOptEnable(Boolean.TRUE);
        softwareDeploymentEntity.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        ObjReference or = new ObjReference();
        or.setTargetId(packageId);
        or.setTargetType("SoftwarePackage");
        or.setOptDescription("SoftwarePackage");
        or.setOptEnable(Boolean.TRUE);
        or.setName("TargetSoftwarePackageLink");
        softwareDeploymentEntity.addObjReference(or);
        PackageSource packageSource = new PackageSource();
        softwareDeploymentEntity.setPackageSource(packageSource);
        return softwareDeploymentEntity;
    }

    public boolean isSoftwarePackageAvailable() {
        return this.isSoftwarePackageAvailable;
    }

    public SoftwareDeploymentPolicy getSoftwareDeploymentPolicy() {
        if (this.deploymentEntity == null) {
            return null;
        }
        return (SoftwareDeploymentPolicy)this.deploymentEntity.getParent();
    }

    public SoftwareDeploymentEntity getSoftwareDeploymentEntity() {
        return this.deploymentEntity;
    }

    public SoftwarePackage getSoftwarePackage() {
        return this.softwarePackageObj.getSoftwarePackage();
    }

    public boolean isDownloadSourceInternal() {
        if (this.deploymentEntity == null) {
            return true;
        }
        PackageSource source = this.deploymentEntity.getPackageSource();
        return source.getSourceServer().equals(PackageSource.SEM_SERVER);
    }

    public boolean isDownloadSourceExternal() {
        if (this.deploymentEntity == null) {
            return true;
        }
        PackageSource source = this.deploymentEntity.getPackageSource();
        return source.getSourceServer().equals(PackageSource.EXTERNAL_URL);
    }

    public String getDownloadSourceUrl() {
        if (this.deploymentEntity == null) {
            return "";
        }
        PackageSource source = this.deploymentEntity.getPackageSource();
        String url = source.getOptPackageSourceExternalUrl();
        return url == null ? "" : url;
    }

    public void setDownloadSource(Integer server, String url) {
        if (this.deploymentEntity == null || server == null) {
            return;
        }
        PackageSource source = this.deploymentEntity.getPackageSource();
        source.setSourceServer(server);
        if (url != null) {
            source.setOptPackageSourceExternalUrl(url);
        }
    }

    public boolean isForeceDeployment() {
        if (this.deploymentEntity == null) {
            return false;
        }
        Boolean fd = this.deploymentEntity.getOptForceDeployment();
        return fd == null ? this.deploymentEntity.getDefForceDeployment() : fd;
    }

    public void setForceDeployment(boolean force) {
        if (this.deploymentEntity == null) {
            return;
        }
        this.deploymentEntity.setOptForceDeployment(Boolean.valueOf(force));
    }

    public boolean isAutoUpgradeToEnglish() {
        if (this.deploymentEntity == null) {
            return false;
        }
        Boolean autoUpgradeToEnglish = this.deploymentEntity.getOptAutoUpgradeToEnglish();
        return autoUpgradeToEnglish == null ? this.deploymentEntity.getDefAutoUpgradeToEnglish() : autoUpgradeToEnglish;
    }

    public void setAutoUpgradeToEnglish(boolean autoUpgradeToEnglish) {
        if (this.deploymentEntity == null) {
            return;
        }
        this.deploymentEntity.setOptAutoUpgradeToEnglish(Boolean.valueOf(autoUpgradeToEnglish));
    }

    public int getRandomizedTime() {
        DeploymentSchedule deploymentSchedule = this.getDeploymentSchedule();
        return SoftwareDeploymentEntityObject.getRandomizedTime(deploymentSchedule);
    }

    public static int getRandomizedTime(DeploymentSchedule deploymentSchedule) {
        if (deploymentSchedule == null) {
            return 0;
        }
        if (deploymentSchedule.getOptRandomizeTime() == null) {
            return deploymentSchedule.getDefRandomizeTime();
        }
        return deploymentSchedule.getOptRandomizeTime();
    }

    public boolean isDeploymentScheduleEnabled() {
        DeploymentSchedule deploymentSchedule = this.getDeploymentSchedule();
        if (deploymentSchedule == null) {
            return false;
        }
        if (deploymentSchedule.getOptEnable() == null) {
            return deploymentSchedule.getDefEnable();
        }
        return deploymentSchedule.getOptEnable();
    }

    public DeploymentSchedule getDeploymentSchedule() {
        if (this.deploymentEntity == null) {
            return null;
        }
        return this.deploymentEntity.getOptDeploymentSchedule();
    }

    public Schedule getSchedule() {
        DeploymentSchedule deploymentSchedule = this.getDeploymentSchedule();
        if (deploymentSchedule == null) {
            return null;
        }
        return deploymentSchedule.getSchedule();
    }

    public boolean isScheduleEnabled() {
        DeploymentSchedule schedule = this.getDeploymentSchedule();
        return SoftwareDeploymentEntityObject.isScheduleEnabled(schedule);
    }

    public static boolean isScheduleEnabled(DeploymentSchedule schedule) {
        if (schedule == null) {
            return false;
        }
        if (schedule.getOptEnable() == null) {
            return schedule.getDefEnable();
        }
        return schedule.getOptEnable();
    }

    public String getScheduleDisplayString() {
        String str = "";
        if (this.deploymentEntity == null) {
            return str;
        }
        str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "SoftwareDeploymentEntityObject.DeploymentCanStartOnFollowedByDate"), Utility.getLongDateTimeString((long)this.deploymentEntity.getCreationTime(), null));
        return str;
    }

    public void setSchedule(DeploymentSchedule deploymentSchedule) {
        if (this.deploymentEntity != null) {
            this.deploymentEntity.setOptDeploymentSchedule(deploymentSchedule);
        }
    }

    public void setSchedule(boolean enabled, int startHour, int startMinute, int startSecond, int toHour, int toMinute, int toSecond, int randomizedDays) {
        DeploymentSchedule deploymentSchedule = this.getDeploymentSchedule();
        if (deploymentSchedule == null) {
            deploymentSchedule = new DeploymentSchedule();
            Schedule schedule = new Schedule();
            deploymentSchedule.setSchedule(schedule);
            this.deploymentEntity.setOptDeploymentSchedule(deploymentSchedule);
        }
        SoftwareDeploymentEntityObject.modifyDeploymentSchedule(deploymentSchedule, enabled, startHour, startMinute, startSecond, toHour, toMinute, toSecond, randomizedDays);
    }

    public String getPckageId() {
        if (this.deploymentEntity == null) {
            return null;
        }
        ObjReference or = this.deploymentEntity.getObjReferenceByTypeAndName("SoftwarePackage", "TargetSoftwarePackageLink");
        return or == null ? null : or.getTargetId();
    }

    public DeploymentNotification getNotification() {
        if (this.deploymentEntity == null) {
            return null;
        }
        return this.deploymentEntity.getOptDeploymentNotification();
    }

    public boolean isNotificationEnabled() {
        DeploymentNotification notification = this.getNotification();
        return SoftwareDeploymentEntityObject.isNotificationEnabled(notification);
    }

    public static boolean isNotificationEnabled(DeploymentNotification notification) {
        if (notification == null) {
            return false;
        }
        return notification.getOptEnable() == null ? false : notification.getOptEnable();
    }

    public String getNotificationText() {
        DeploymentNotification notification = this.getNotification();
        return SoftwareDeploymentEntityObject.getNotificationText(notification);
    }

    public static String getNotificationText(DeploymentNotification notification) {
        if (notification == null) {
            return null;
        }
        DeploymentNotificationBeforeUpdate update = notification.getOptDeploymentNotificationBeforeUpdate();
        if (update == null) {
            return null;
        }
        return update.getOptAdditionalText();
    }

    public void setNotification(boolean enabled, String text) {
        if (this.deploymentEntity == null) {
            return;
        }
        if (!(enabled || text != null && text.length() >= 1)) {
            this.deploymentEntity.setOptDeploymentNotification(null);
            return;
        }
        DeploymentNotification notification = this.deploymentEntity.getOptDeploymentNotification();
        if (notification == null) {
            notification = new DeploymentNotification();
            this.deploymentEntity.setOptDeploymentNotification(notification);
        }
        notification.setOptEnable(Boolean.valueOf(enabled));
        DeploymentNotificationBeforeUpdate update = new DeploymentNotificationBeforeUpdate();
        update.setOptEnable(Boolean.valueOf(enabled));
        update.setOptAdditionalText(text);
        notification.setOptDeploymentNotificationBeforeUpdate(update);
    }

    public DeploymentSnooze getSnooze() {
        if (this.deploymentEntity == null) {
            return null;
        }
        return this.deploymentEntity.getOptDeploymentSnooze();
    }

    public boolean isSnoozeEnabled() {
        DeploymentSnooze snooze = this.getSnooze();
        return SoftwareDeploymentEntityObject.isSnoozeEnabled(snooze);
    }

    public static boolean isSnoozeEnabled(DeploymentSnooze snooze) {
        if (snooze == null) {
            return false;
        }
        return snooze.getOptEnable() == null ? false : snooze.getOptEnable();
    }

    public int getSnoozeMinTimeInSecs() {
        DeploymentSnooze snooze = this.getSnooze();
        return SoftwareDeploymentEntityObject.getSnoozeMinTimeInSecs(snooze);
    }

    public static int getSnoozeMinTimeInSecs(DeploymentSnooze snooze) {
        if (snooze == null) {
            return 1800;
        }
        return snooze.getMinimumTime() == null ? 1800 : snooze.getMinimumTime();
    }

    public int getSnoozeMaxTimeInSecs() {
        DeploymentSnooze snooze = this.getSnooze();
        return SoftwareDeploymentEntityObject.getSnoozeMaxTimeInSecs(snooze);
    }

    public static int getSnoozeMaxTimeInSecs(DeploymentSnooze snooze) {
        if (snooze == null) {
            return 86400;
        }
        return snooze.getOptMaximumTime() == null ? 86400 : snooze.getOptMaximumTime();
    }

    public void setSnooze(boolean enabled, int minTimeInSecs, int maxTimeInSecs) {
        if (this.deploymentEntity == null) {
            return;
        }
        DeploymentSnooze snooze = this.deploymentEntity.getOptDeploymentSnooze();
        if (snooze == null) {
            snooze = new DeploymentSnooze();
            this.deploymentEntity.setOptDeploymentSnooze(snooze);
        }
        snooze.setOptEnable(Boolean.valueOf(enabled));
        snooze.setMinimumTime(Integer.valueOf(minTimeInSecs));
        snooze.setOptMaximumTime(Integer.valueOf(maxTimeInSecs));
    }

    public AutoUpgradeContentOption getAutoUpgradeContentOption() {
        if (this.deploymentEntity == null) {
            return null;
        }
        return this.deploymentEntity.getOptAutoUpgradeContentOption();
    }

    public boolean isIncludeContentInAutoUpgradePackage() {
        AutoUpgradeContentOption contentOption = this.getAutoUpgradeContentOption();
        return SoftwareDeploymentEntityObject.isIncludeContentInAutoUpgradePackage(contentOption);
    }

    public static boolean isIncludeContentInAutoUpgradePackage(AutoUpgradeContentOption contentOption) {
        if (contentOption == null) {
            return true;
        }
        if (contentOption.getOptIncludeContentInAutoUpgradePackage() == null) {
            return contentOption.getDefIncludeContentInAutoUpgradePackage();
        }
        return contentOption.getOptIncludeContentInAutoUpgradePackage();
    }

    public void setAutoUpgradeContentOption(boolean includeContentInAutoUpgradePackage) {
        if (this.deploymentEntity == null) {
            return;
        }
        AutoUpgradeContentOption contentOption = this.deploymentEntity.getOptAutoUpgradeContentOption();
        if (contentOption == null) {
            contentOption = new AutoUpgradeContentOption();
            this.deploymentEntity.setOptAutoUpgradeContentOption(contentOption);
        }
        contentOption.setOptIncludeContentInAutoUpgradePackage(Boolean.valueOf(includeContentInAutoUpgradePackage));
    }
}

