/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.Database;
import com.sygate.scm.common.configobject.schema.DatabaseArray;
import com.sygate.scm.common.configobject.schema.ExternalLogging;
import com.sygate.scm.common.configobject.schema.PackageInfo;
import com.sygate.scm.common.configobject.schema.PackageLuInfo;
import com.sygate.scm.common.configobject.schema.Replication;
import com.sygate.scm.common.configobject.schema.ReplicationCache;
import com.sygate.scm.common.configobject.schema.ReplicationPartnerArray;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroupPool;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerState;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.configobject.schema.SiteObjectPool;
import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.common.configobject.schema.SoftwarePackageCache;
import com.sygate.scm.common.configobject.schema.SoftwarePackageCacheArray;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.DatabaseObject;
import com.sygate.scm.console.logicobject.ExternalLoggingObject;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.logicobject.PartnerGroup;
import com.sygate.scm.console.logicobject.RadiusServerGroupPoolObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import javax.swing.tree.DefaultMutableTreeNode;

public class SiteObject
extends AbstractUIObject
implements TreeItem {
    private String displayName;
    private SemSite semSite;

    public SiteObject(SemSite siteConfig) {
        this.semSite = siteConfig;
        this.displayName = siteConfig.getName();
    }

    @Override
    public int getItemType() {
        return 13;
    }

    @Override
    public String getId() {
        return this.semSite.getId();
    }

    @Override
    public String getName() {
        return this.semSite.getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDescription() {
        String value = this.semSite.getOptDescription();
        return value == null ? "" : value.trim();
    }

    public int getPartnerCount() {
        ReplicationPartnerArray partnerArray = this.semSite.getReplication().getReplicationPartnerArray();
        int totalCount = partnerArray.getReplicationPartnershipCount();
        int enabledCount = 0;
        for (int i = 0; i < totalCount; ++i) {
            ReplicationPartnership thisPartnership = partnerArray.getReplicationPartnership(i);
            Boolean enable = thisPartnership.getOptEnable();
            if (enable == null) {
                enable = thisPartnership.getDefEnable();
            }
            if (!enable.booleanValue()) continue;
            ++enabledCount;
        }
        return enabledCount;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public SemSite getSemSite() {
        return this.semSite;
    }

    public DefaultMutableTreeNode getSiteNode() {
        DefaultMutableTreeNode siteNode = new DefaultMutableTreeNode(this);
        ServerArray serverArray = this.semSite.getServerArray();
        for (int i = 0; i < serverArray.getSemServerCount(); ++i) {
            SemServer server = serverArray.getSemServer(i);
            String guidString = server.getId();
            SemServerState serverState = null;
            try {
                serverState = DataobjectManager.getInstance().getSemServerState(guidString);
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
            DefaultMutableTreeNode serverNode = new DefaultMutableTreeNode(new ServerObject(server, serverState));
            siteNode.add(serverNode);
        }
        DatabaseArray dbArray = this.semSite.getDatabaseArray();
        Database db = dbArray.getDatabase();
        DefaultMutableTreeNode dbNode = new DefaultMutableTreeNode(new DatabaseObject(db));
        siteNode.add(dbNode);
        Replication replication = this.semSite.getReplication();
        ReplicationPartnerArray partnerArray = replication.getReplicationPartnerArray();
        PartnerGroup partnerGroup = new PartnerGroup(partnerArray, this.semSite.getId());
        DefaultMutableTreeNode partnerGroupNode = new DefaultMutableTreeNode(partnerGroup);
        for (int i = 0; i < partnerArray.getReplicationPartnershipCount(); ++i) {
            ReplicationPartnership partner = partnerArray.getReplicationPartnership(i);
            if (partner.getOptEnable() != null && !partner.getOptEnable().booleanValue()) continue;
            DefaultMutableTreeNode partnerNode = new DefaultMutableTreeNode(new Partner(partner, this.semSite.getId()));
            partnerGroupNode.add(partnerNode);
        }
        if (partnerGroupNode.getChildCount() > 0) {
            siteNode.add(partnerGroupNode);
        }
        return siteNode;
    }

    public ExternalLogging getExternalLogging() {
        if (this.semSite == null) {
            return null;
        }
        return this.semSite.getOptExternalLogging();
    }

    public ExternalLogging getOrCreateExternalLogging() {
        if (this.semSite == null) {
            return null;
        }
        ExternalLogging externalLogging = this.semSite.getOptExternalLogging();
        if (externalLogging == null) {
            externalLogging = ExternalLoggingObject.newInstance();
            this.semSite.setOptExternalLogging(externalLogging);
        }
        return externalLogging;
    }

    public boolean isSuspended() {
        if (this.semSite == null) {
            return false;
        }
        return this.semSite.getOptSuspended() == null ? false : this.semSite.getOptSuspended();
    }

    public RadiusServerGroupPoolObject getRadiusServerGroupPoolObject(boolean alwaysGet) {
        SeRadiusServerGroupPool rsGroupPool;
        SiteObjectPool sitePool = this.semSite.getOptSiteObjectPool();
        if (sitePool == null) {
            if (alwaysGet) {
                sitePool = new SiteObjectPool();
                this.semSite.setOptSiteObjectPool(sitePool);
            } else {
                return null;
            }
        }
        if ((rsGroupPool = sitePool.getOptSeRadiusServerGroupPool()) == null && alwaysGet) {
            rsGroupPool = new SeRadiusServerGroupPool();
            sitePool.setOptSeRadiusServerGroupPool(rsGroupPool);
        }
        return rsGroupPool == null ? null : new RadiusServerGroupPoolObject(rsGroupPool);
    }

    public SoftwarePackage getsoftwarePackageFromCache(String spId) throws ConsoleException {
        ReplicationCache cache = this.semSite.getReplication().getOptReplicationCache();
        if (cache == null) {
            ConsoleLogger.log("SiteObject->getsoftwarePackageFromCache: Error: Replication cache of the current site is null.");
            throw new ConsoleException(-268435300);
        }
        SoftwarePackageCacheArray spArray = cache.getOptSoftwarePackageCacheArray();
        if (spArray == null || spArray.getSoftwarePackageCacheCount() == 0) {
            ConsoleLogger.log("SiteObject->getsoftwarePackageFromCache: Error: SoftwarePackage cache array of the current site is null or no caches.");
            throw new ConsoleException(-268435300);
        }
        for (int i = 0; i < spArray.getSoftwarePackageCacheCount(); ++i) {
            SoftwarePackageCache spCache = spArray.getSoftwarePackageCache(i);
            if (!spId.equals(spCache.getId())) continue;
            ConsoleLogger.log("SiteObject->getsoftwarePackageFromCache: Found in cache: " + spId);
            return this.buildupSoftwarePackageFromCache(spCache);
        }
        ConsoleLogger.log("SiteObject->getsoftwarePackageFromCache: Error: Didnot find software pckaage in cache.");
        throw new ConsoleException(-268435300);
    }

    private SoftwarePackage buildupSoftwarePackageFromCache(SoftwarePackageCache cache) {
        SoftwarePackage sp = new SoftwarePackage();
        sp.setId(cache.getId());
        sp.setName(cache.getName());
        sp.setOptDescription(cache.getOptDescription());
        sp.setOptRefId(cache.getOptRefId());
        sp.setCreationTime(cache.getOptCreationTime());
        sp.setOptSuspended(cache.getOptSuspended());
        PackageInfo cpInfo = cache.getOptPackageInfo();
        if (cpInfo != null) {
            PackageLuInfo cpLuInfo = cpInfo.getOptPackageLuInfo();
            PackageInfo info = new PackageInfo();
            info.setType(cpInfo.getType());
            info.setVersion(cpInfo.getVersion());
            info.setSize(cpInfo.getSize());
            info.setCreationTime(cpInfo.getCreationTime());
            info.setLastModifiedTime(cpInfo.getLastModifiedTime());
            info.setOptLanuage(cpInfo.getOptLanuage());
            info.setChecksum(cpInfo.getChecksum());
            info.setOptPlatformType(cpInfo.getOptPlatformType());
            info.setOptPackageName(cpInfo.getOptPackageName());
            info.setOptReleaseNotesUrl(cpInfo.getOptReleaseNotesUrl());
            sp.setPackageInfo(info);
            if (cpLuInfo != null) {
                PackageLuInfo luInfo = new PackageLuInfo();
                luInfo.setServerProduct(cpLuInfo.getServerProduct());
                luInfo.setServerVersion(cpLuInfo.getServerVersion());
                luInfo.setServerLanguage(cpLuInfo.getServerLanguage());
                luInfo.setClientProduct(cpLuInfo.getClientProduct());
                luInfo.setClientVersion(cpLuInfo.getClientVersion());
                luInfo.setClientLanguage(cpLuInfo.getClientLanguage());
                luInfo.setServerMoniker(cpLuInfo.getServerMoniker());
                luInfo.setClientMoniker(cpLuInfo.getClientMoniker());
                luInfo.setSequenceNumber(cpLuInfo.getSequenceNumber());
                luInfo.setOptSequenceTag(cpLuInfo.getOptSequenceTag());
                luInfo.setOptDisplayName(cpLuInfo.getOptDisplayName());
                luInfo.setShortName(cpLuInfo.getShortName());
                info.setOptPackageLuInfo(luInfo);
            }
        }
        return sp;
    }
}

