/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.FullContentsDistributionConfig;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemServerState;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerHealth;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ServerObject
extends AbstractUIObject
implements TreeItem {
    SemServer semServer;
    private SemServerState serverState;

    public ServerObject() {
    }

    public ServerObject(SemServer server, SemServerState state) {
        this.semServer = server;
        this.setServerState(state);
    }

    public String getServerOS() {
        String os = null;
        if (this.getServerState() != null) {
            os = this.getServerState().getOptOS();
        }
        if (os == null || os.trim().length() == 0) {
            os = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
        }
        return os;
    }

    public String getProductVersion() {
        String version = null;
        if (this.getServerState() != null) {
            version = this.getServerState().getOptSemServerProductVersion();
        }
        if (version == null || version.trim().length() == 0) {
            version = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
        }
        return version;
    }

    public String getProductName() {
        String productName = null;
        if (this.getServerState() != null) {
            productName = this.getServerState().getOptSemServerProductName();
        }
        if (productName == null || productName.trim().length() == 0) {
            productName = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
        }
        return productName;
    }

    public String getServerStartTime() {
        long startTime;
        if (this.getServerState() != null && this.getServerState().getOptServerStartTime() != null && (startTime = this.getServerState().getOptServerStartTime().longValue()) > 0L) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
            format.setTimeZone(Utility.getLocalTimeZone());
            return format.format(new Date(startTime));
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
    }

    public String getDisplayServerStartTime() {
        long startTime;
        if (this.getServerState() != null && this.getServerState().getOptServerStartTime() != null && (startTime = this.getServerState().getOptServerStartTime().longValue()) > 0L) {
            DateFormat format = DateFormat.getDateTimeInstance(0, 1, Locale.getDefault());
            format.setTimeZone(Utility.getLocalTimeZone());
            return format.format(new Date(startTime));
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
    }

    public String getServerAddressString() {
        if (this.getServerState() == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.getServerState().getIpAddressCount(); ++i) {
            IpAddress thisAddress = this.getServerState().getIpAddress(i);
            String content = thisAddress.getContent();
            if (content == null || content.trim().length() <= 0) continue;
            if (!first) {
                buffer.append("<BR>");
            }
            buffer.append(content);
            first = false;
        }
        if (buffer.toString().trim().length() == 0) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
        }
        return buffer.toString();
    }

    public String getServerHealth() {
        ServerHealth serverHealth;
        Integer health = null;
        if (this.getServerState() != null && (serverHealth = this.getServerState().getOptServerHealth()) != null) {
            health = serverHealth.getHealthStatus();
        }
        if (health != null) {
            return health.toString();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
    }

    public String getStatus() {
        Integer status = null;
        if (this.getServerState() != null) {
            status = this.getServerState().getOptStatus();
        }
        if (status != null) {
            if (status.intValue() == SemServerState.ONLINE.intValue()) {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.StatusOnline");
            }
            if (status.intValue() == SemServerState.OFFLINE.intValue()) {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.StatusOffline");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
    }

    public SemServer getSemServer() {
        return this.semServer;
    }

    public SemSite getParentSite() {
        SemSite semSite = (SemSite)this.semServer.getParent().getParent();
        return semSite;
    }

    @Override
    public int getItemType() {
        return 14;
    }

    @Override
    public String getId() {
        return this.semServer.getId();
    }

    @Override
    public String getName() {
        return this.semServer != null ? this.semServer.getName() : "";
    }

    public String getDescription() {
        String value = this.semServer.getOptDescription();
        return value == null ? "" : value.trim();
    }

    public String getCreationTime() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        format.setTimeZone(Utility.getLocalTimeZone());
        return format.format(new Date(this.semServer.getCreationTime()));
    }

    public String getDisplayCreationTime() {
        Long time = this.semServer.getCreationTime();
        if (time == null || time == 0L) {
            return "";
        }
        DateFormat format = DateFormat.getDateTimeInstance(0, 1, Locale.getDefault());
        format.setTimeZone(Utility.getLocalTimeZone());
        return format.format(new Date(time));
    }

    public String toString() {
        return this.getName();
    }

    public String getHttpPort() {
        Integer httpPort = null;
        if (this.getServerState() != null) {
            httpPort = this.getServerState().getOptHttpPort();
        }
        if (httpPort != null) {
            return httpPort.toString();
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerObject.NotAvailable");
    }

    public void setServerState(SemServerState serverState) {
        this.serverState = serverState;
    }

    public SemServerState getServerState() {
        return this.serverState;
    }

    public boolean getBlockFullContentsOption() {
        boolean blockFullContents = new FullContentsDistributionConfig().getDefBlockFullContents();
        if (this.semServer.getOptFullContentsDistributionConfig() != null) {
            FullContentsDistributionConfig fullContentsDistributionConfig = this.semServer.getOptFullContentsDistributionConfig();
            blockFullContents = fullContentsDistributionConfig.getOptBlockFullContents() == null ? fullContentsDistributionConfig.getDefBlockFullContents() : fullContentsDistributionConfig.getOptBlockFullContents();
        }
        return blockFullContents;
    }
}

