/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.configobject.schema.SemServerListPool;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import java.util.ArrayList;
import java.util.Vector;

public class ServerListPool
extends AppliablePolicyPool {
    public ServerListPool(SemDomain domain) throws ConsoleException {
        super(domain, 60);
    }

    public static ServerListPool getServerListPool() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        return new ServerListPool(domain);
    }

    @Override
    protected void initialize() throws ConsoleException {
        this.clearObjectList();
        ArrayList siteIds = (ArrayList)PolicyHandler.getAllAvaliableSiteId();
        for (String siteId : siteIds) {
            SemServerList defaultList = GUIManager.getDefaultServerList(siteId);
            ServerListObject listObj = new ServerListObject(defaultList, true);
            this.objInfoList.add(PolicyHelper.createObjInfoObject(listObj));
        }
        this.initialize(this.poolType);
        if (this.policyPool != null) {
            this.initObjInfo(this.poolType);
        }
    }

    @Override
    protected void addPolicyPoolReference(ConfigObject policyPool, ObjReference objRef) throws ConsoleException {
        if (!(policyPool instanceof SemServerListPool)) {
            throw new ConsoleException(302645248, 32);
        }
        ((SemServerListPool)policyPool).addObjReference(objRef);
    }

    @Override
    protected Vector<ObjReference> getPolicyPoolReferences() {
        return ((SemServerListPool)this.policyPool).getObjReference();
    }

    @Override
    protected void createSemPolicyPool() {
        this.policyPool = new SemServerListPool();
        this.domainObjPool.setOptSemServerListPool((SemServerListPool)this.policyPool);
        this.updateObjSet.put(this.domain.getId(), this.domain);
    }
}

