/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemServerBlock;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.IPAddressUtil;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.ServerBlockObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Iterator;
import java.util.Vector;

public class ServerListObject
extends PolicyObjectBase
implements TableRow {
    private boolean isDefaultList;

    public ServerListObject(SemServerList sl) {
        super((TopLevelObject)sl);
    }

    public ServerListObject(SemServerList sl, boolean isDefault) {
        super((TopLevelObject)sl);
        this.isDefaultList = isDefault;
    }

    public ServerListObject() {
        super((TopLevelObject)new SemServerList());
        ((SemServerList)this.policy).setId(new GUIDGenerator().getGUIDString());
        ((SemServerList)this.policy).setName("");
    }

    public void addServerBlock(ServerBlockObject bObj) {
        ((SemServerList)this.policy).addSemServerBlock(bObj.getSemServerBlock());
    }

    public void moveDownOnePosition(ServerBlockObject bObj) {
        SemServerBlock curBlock = bObj.getSemServerBlock();
        int index = -1;
        Vector allBlocks = ((SemServerList)this.policy).getSemServerBlock();
        for (int i = 0; i < allBlocks.size(); ++i) {
            if (allBlocks.get(i) != curBlock) continue;
            index = i;
            break;
        }
        if (index != -1 && index < allBlocks.size() - 1) {
            ((SemServerList)this.policy).removeSemServerBlock(curBlock);
            ((SemServerList)this.policy).addSemServerBlock(index + 1, curBlock);
            bObj.increaseIndex();
        }
    }

    public void moveUpOnePosition(ServerBlockObject bObj) {
        SemServerBlock curBlock = bObj.getSemServerBlock();
        int index = -1;
        Vector allBlocks = ((SemServerList)this.policy).getSemServerBlock();
        for (int i = 0; i < allBlocks.size(); ++i) {
            if (allBlocks.get(i) != curBlock) continue;
            index = i;
            break;
        }
        if (index != -1 && index > 0) {
            ((SemServerList)this.policy).removeSemServerBlock(curBlock);
            ((SemServerList)this.policy).addSemServerBlock(index - 1, curBlock);
            bObj.decreaseIndex();
        }
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof SemServerList)) {
            throw new ConsoleException(302645248, 32);
        }
        return new ServerListObject((SemServerList)policyObj);
    }

    public SemServerList getSemServerList() {
        return (SemServerList)this.policy;
    }

    @Override
    public String getCreator() {
        return null;
    }

    @Override
    public void setCreator(String creator) {
    }

    @Override
    public String getTargetType() {
        return "SemServerList";
    }

    @Override
    public String getTargetName() {
        return "";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedSemServerListLink";
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "ServerListObject.PolicyManagerListDescription");
    }

    public boolean setDescription(String newValue) {
        String oldValue = this.getDescription();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        ((SemServerList)this.policy).setOptDescription(newValue);
        return true;
    }

    public ServerBlockObject[] getAllServers() {
        Vector allServers = ((SemServerList)this.policy).getSemServerBlock();
        ServerBlockObject[] allObjs = new ServerBlockObject[allServers.size()];
        for (int i = 0; i < allObjs.length; ++i) {
            allObjs[i] = new ServerBlockObject((SemServerBlock)allServers.get(i), i);
        }
        return allObjs;
    }

    public ServerListObject getClone() throws ConsoleException {
        SemServerList newServerList = (SemServerList)PolicyHandler.getCopyOfObj((ConfigObject)this.policy);
        return new ServerListObject(newServerList, this.isDefaultList);
    }

    public void setSemServerList(ServerListObject newObj) {
        this.policy = newObj.getSemServerList();
    }

    public void setSemServerList(SemServerList list) {
        this.policy = list;
    }

    @Override
    public int getItemType() {
        return 60;
    }

    public boolean isDefaultList() {
        return this.isDefaultList;
    }

    public boolean isPreferredComSecuirtyUsesHttps() {
        boolean preferredCommSecuirtyPortocolUseHttps = false;
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            if (semConfigRoot.getOptPrefferedCommSecurity() == null) {
                System.out.println("This should not happen from 14.0 onwards, the preferred communication protocol in db should not be null");
                preferredCommSecuirtyPortocolUseHttps = false;
            } else {
                preferredCommSecuirtyPortocolUseHttps = semConfigRoot.getOptPrefferedCommSecurity().equals(SemConfigRoot.HTTPS_ONLY);
            }
        }
        catch (ConsoleException ex) {
            System.out.println(ex.getMessage());
            LoggerUtilities.logException((Throwable)ex);
        }
        return preferredCommSecuirtyPortocolUseHttps;
    }

    public boolean hasServer() {
        int count = ((SemServerList)this.policy).getSemServerBlockCount();
        if (count == 0) {
            return false;
        }
        Vector allBlock = ((SemServerList)this.policy).getSemServerBlock();
        for (SemServerBlock block : allBlock) {
            if (block.getHostAddressCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    public Class<String> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public boolean getOnlyHttps() {
        Integer commSecurity = ((SemServerList)this.policy).getOptCommSecurity();
        if (commSecurity != null) {
            return commSecurity.equals(SemServerList.HTTPS_ONLY);
        }
        return false;
    }

    public boolean setOnlyHttps(boolean newValue) {
        boolean oldValue = this.getOnlyHttps();
        if (oldValue == newValue) {
            return false;
        }
        if (newValue) {
            ((SemServerList)this.policy).setOptCommSecurity(SemServerList.HTTPS_ONLY);
        } else {
            ((SemServerList)this.policy).setOptCommSecurity(SemServerList.ANY);
        }
        return true;
    }

    public boolean getVerifyName() {
        Boolean verifyName = ((SemServerList)this.policy).getOptVerifyHttpsUrlName();
        if (verifyName == null) {
            verifyName = ((SemServerList)this.policy).getDefVerifyHttpsUrlName();
        }
        return verifyName;
    }

    public boolean setVerifyName(boolean newValue) {
        boolean oldValue = this.getVerifyName();
        if (oldValue == newValue) {
            return false;
        }
        ((SemServerList)this.policy).setOptVerifyHttpsUrlName(Boolean.valueOf(newValue));
        return true;
    }

    public int[] getFirstIpPos() {
        int[] ret = new int[]{-1, -1};
        int bCnt = 0;
        int sCnt = 0;
        Vector blocks = ((SemServerList)this.policy).getSemServerBlock();
        for (SemServerBlock sBlock : blocks) {
            Vector servers = sBlock.getHostAddress();
            Iterator itServer = servers.iterator();
            sCnt = 0;
            while (itServer.hasNext()) {
                HostAddress host = (HostAddress)itServer.next();
                String address = host.getContent();
                if (IPAddressUtil.isIPv4LiteralAddress((String)address) || IPAddressUtil.isIPv6LiteralAddress((String)address)) {
                    ret[0] = bCnt;
                    ret[1] = sCnt;
                }
                ++sCnt;
            }
            ++bCnt;
        }
        return ret;
    }
}

