/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class SEPMDateObject
implements Comparable<SEPMDateObject> {
    private final Date date;
    private final String strDate;

    public SEPMDateObject() {
        this.date = new Date();
        this.strDate = SEPMDateObject.formatDate(this.date, Utility.getLocalTimeZone());
    }

    public SEPMDateObject(long timeMillis) {
        this.date = new Date(timeMillis);
        this.strDate = SEPMDateObject.formatDate(this.date, Utility.getLocalTimeZone());
    }

    public SEPMDateObject(long timeMillis, String strTimeZone) {
        this.date = new Date(timeMillis);
        this.strDate = !StringUtilities.isEmpty((String)strTimeZone) ? SEPMDateObject.formatDate(this.date, TimeZone.getTimeZone(strTimeZone)) : SEPMDateObject.formatDate(this.date, Utility.getLocalTimeZone());
    }

    public String toString() {
        return this.strDate;
    }

    @Override
    public int compareTo(SEPMDateObject o) {
        return this.date.compareTo(o.date);
    }

    public boolean equals(Object obj) {
        return obj instanceof SEPMDateObject && this.date.equals(((SEPMDateObject)obj).date);
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    private static String formatDate(Date d, TimeZone zone) {
        DateFormat df = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        df.setTimeZone(zone);
        return df.format(d);
    }
}

