/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.GupRuleSet;
import com.sygate.scm.common.configobject.schema.IPAddressesHostNames;
import com.sygate.scm.common.configobject.schema.OperatingSystems;
import com.sygate.scm.common.configobject.schema.RegistryEntries;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.CountableInt;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.RuleSetObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import java.net.URL;
import java.util.HashMap;

public class RuleSetOrObject
extends AbstractUIObject
implements DeletableObjInt,
CopitableObject,
CountableInt {
    private ConfigObject _gupRuleSet;
    private boolean isFirst;
    private int cntNumber;

    public RuleSetOrObject() {
    }

    public RuleSetOrObject(ConfigObject gupRuleSe, boolean first) {
        this._gupRuleSet = gupRuleSe;
        this.isFirst = first;
    }

    public RuleSetOrObject(boolean first) {
        this._gupRuleSet = new GupRuleSet();
        this.isFirst = first;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("<table><tr><td>");
        URL url = ConsoleMain.class.getResource("ruleSet.png");
        AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> {
            buffer.append("<img src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\" />");
        }, () -> {
            buffer.append("<image src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\"></image>");
        });
        buffer.append("</td><td>");
        if (!this.isFirst) {
            buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "RuleSetOrObject.RuleSet.or"));
            buffer.append("&nbsp;");
        }
        buffer.append("<b>");
        buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "RuleSetOrObject.RuleSet"));
        buffer.append("&nbsp;");
        buffer.append(this.cntNumber + 1);
        buffer.append("&nbsp;");
        buffer.append("</b>");
        buffer.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "RuleSetOrObject.RuleSet.description"));
        buffer.append("</td></tr></table></html>");
        return buffer.toString();
    }

    public RuleSetObject getLocalHostAddress() {
        IPAddressesHostNames locAddr = ((GupRuleSet)this._gupRuleSet).getOptIPAddressesHostNames();
        RuleSetObject locAddrObj = null;
        if (locAddr != null) {
            locAddrObj = new RuleSetObject(0, (ConfigObject)locAddr);
        }
        return locAddrObj;
    }

    public RuleSetObject getAlRegistry() {
        RegistryEntries registryList = ((GupRuleSet)this._gupRuleSet).getOptRegistryEntries();
        RuleSetObject registryObjs = null;
        if (registryList != null) {
            registryObjs = new RuleSetObject(1, (ConfigObject)registryList);
        }
        return registryObjs;
    }

    public RuleSetObject getOperatingSystems() {
        OperatingSystems osList = ((GupRuleSet)this._gupRuleSet).getOptOperatingSystems();
        RuleSetObject osObjs = null;
        if (osList != null) {
            osObjs = new RuleSetObject(2, (ConfigObject)osList);
        }
        return osObjs;
    }

    public GupRuleSet getGupRuleSet() {
        return (GupRuleSet)this._gupRuleSet;
    }

    @Override
    public void delete() {
        this._gupRuleSet.getParent().removeChild((AbstractSchema)this._gupRuleSet);
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setToFirst() {
        this.isFirst = true;
    }

    public void addAnCondition(RuleSetObject newObj) {
        switch (newObj.getType()) {
            case 0: {
                ((GupRuleSet)this._gupRuleSet).setOptIPAddressesHostNames((IPAddressesHostNames)newObj.getObject());
                break;
            }
            case 1: {
                ((GupRuleSet)this._gupRuleSet).setOptRegistryEntries((RegistryEntries)newObj.getObject());
                break;
            }
            case 2: {
                ((GupRuleSet)this._gupRuleSet).setOptOperatingSystems((OperatingSystems)newObj.getObject());
                break;
            }
        }
    }

    public void removeAnCondition(RuleSetObject newObj) {
        switch (newObj.getType()) {
            case 0: {
                ((GupRuleSet)this._gupRuleSet).removeChild((AbstractSchema)newObj.getObject());
                break;
            }
            case 1: {
                ((GupRuleSet)this._gupRuleSet).removeChild((AbstractSchema)newObj.getObject());
                break;
            }
            case 2: {
                ((GupRuleSet)this._gupRuleSet).removeChild((AbstractSchema)newObj.getObject());
                break;
            }
        }
    }

    public void replace(RuleSetObject oldObj, RuleSetObject newObj) {
        if (oldObj != newObj) {
            if (oldObj.getType() != newObj.getType()) {
                oldObj.delete();
                this.addAnCondition(newObj);
            } else {
                switch (oldObj.getType()) {
                    case 0: {
                        ((GupRuleSet)this._gupRuleSet).setOptIPAddressesHostNames((IPAddressesHostNames)newObj.getObject());
                        break;
                    }
                    case 1: {
                        ((GupRuleSet)this._gupRuleSet).setOptRegistryEntries((RegistryEntries)newObj.getObject());
                        break;
                    }
                    case 2: {
                        ((GupRuleSet)this._gupRuleSet).setOptOperatingSystems((OperatingSystems)newObj.getObject());
                        break;
                    }
                }
            }
        }
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            GupRuleSet newAl = (GupRuleSet)washer.duplicateObject(this._gupRuleSet, createdObj);
            RuleSetOrObject newObj = new RuleSetOrObject((ConfigObject)newAl, false);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public void setCountNumber(int newCnt) {
        this.cntNumber = newCnt;
    }

    public String[] getTypeNotPresent() {
        int count = 0;
        if (this.getLocalHostAddress() == null) {
            ++count;
        }
        if (this.getAlRegistry() == null) {
            ++count;
        }
        if (this.getOperatingSystems() == null) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] types = new String[count];
        int i = 0;
        if (this.getLocalHostAddress() == null) {
            types[i++] = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.computerIPAddressHostName");
        }
        if (this.getAlRegistry() == null) {
            types[i++] = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.registryKeys");
        }
        if (this.getOperatingSystems() == null) {
            types[i++] = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.operationSystem");
        }
        return types;
    }

    public String[] getTypesAppearInEdit(RuleSetObject set) {
        int count = 0;
        if (this.getLocalHostAddress() == null) {
            ++count;
        }
        if (this.getAlRegistry() == null) {
            ++count;
        }
        if (this.getOperatingSystems() == null) {
            ++count;
        }
        if (count != 3) {
            ++count;
        }
        String[] types = new String[count];
        int i = 0;
        if (this.getLocalHostAddress() == null || set.getType() == 0) {
            types[i++] = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.computerIPAddressHostName");
        }
        if (this.getAlRegistry() == null || set.getType() == 1) {
            types[i++] = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.registryKeys");
        }
        if (this.getOperatingSystems() == null || set.getType() == 2) {
            types[i++] = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", "GUPConditionDlg.operationSystem");
        }
        return types;
    }
}

