/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ObsoleteItem;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HostName;
import com.sygate.scm.common.configobject.schema.IPAddressesHostNames;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.OperatingSystems;
import com.sygate.scm.common.configobject.schema.RegistryData;
import com.sygate.scm.common.configobject.schema.RegistryEntries;
import com.sygate.scm.common.configobject.schema.RegistryKey;
import com.sygate.scm.common.configobject.schema.RegistryValue;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AddressObject;
import com.sygate.scm.console.logicobject.CountableInt;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.logicobject.OperatingSystemNameObject;
import com.sygate.scm.console.logicobject.RegistryDataObject;
import com.sygate.scm.console.logicobject.RegistryKeyObject;
import com.sygate.scm.console.logicobject.RegistryObject;
import com.sygate.scm.console.logicobject.RegistryValueObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class RuleSetObject
extends AbstractUIObject
implements DeletableObjInt,
CountableInt,
CopitableObject {
    public static final int TYPE_LOCALHOST = 0;
    public static final int TYPE_REGISTRY = 1;
    public static final int TYPE_OPERATINGSYSTEM = 2;
    private static final String DLG = "com.sygate.scm.console.logicobject.logicobject";
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private int addressType;
    private ConfigObject _orCondition;
    private String operatingSystemNames = "";
    private static ArrayList<ObsoleteItem> removedItems = new ArrayList();

    public RuleSetObject(int type, ConfigObject object) {
        this.addressType = type;
        this._orCondition = object;
    }

    public RuleSetObject(int type) {
        this.addressType = type;
        this.recreateObject(type);
    }

    public void addAddress(AddressObject newAddr) {
        if (!(this._orCondition instanceof IPAddressesHostNames)) {
            this._orCondition = new IPAddressesHostNames();
        }
        IPAddressesHostNames local = (IPAddressesHostNames)this._orCondition;
        ObsoleteItem obsoleteItem = null;
        switch (newAddr.getType()) {
            case 0: {
                IpAddress newIpAddress = (IpAddress)newAddr.getObject();
                obsoleteItem = new ObsoleteItem(newIpAddress.getI());
                if (removedItems.contains(obsoleteItem)) {
                    local.removeObsoleteItem(obsoleteItem);
                }
                local.addIpAddress(newIpAddress);
                break;
            }
            case 7: {
                Ipv6Address newIpv6Address = (Ipv6Address)newAddr.getObject();
                obsoleteItem = new ObsoleteItem(newIpv6Address.getI());
                if (removedItems.contains(obsoleteItem)) {
                    local.removeObsoleteItem(obsoleteItem);
                }
                local.addIpv6Address(newIpv6Address);
                break;
            }
            case 4: {
                HostName newHostName = (HostName)newAddr.getObject();
                obsoleteItem = new ObsoleteItem(newHostName.getI());
                if (removedItems.contains(obsoleteItem)) {
                    local.removeObsoleteItem(obsoleteItem);
                }
                local.addHostName(newHostName);
                break;
            }
        }
    }

    public void addRegistryData(RegistryObject newReg) {
        if (!(this._orCondition instanceof RegistryEntries)) {
            this._orCondition = new RegistryEntries();
        }
        ObsoleteItem obsoleteItem = null;
        RegistryEntries alRegistry = (RegistryEntries)this._orCondition;
        if (newReg instanceof RegistryDataObject) {
            RegistryData registryData = (RegistryData)newReg.getDataObject();
            obsoleteItem = new ObsoleteItem(registryData.getI());
            if (removedItems.contains(obsoleteItem)) {
                alRegistry.removeObsoleteItem(obsoleteItem);
            }
            alRegistry.addRegistryData(registryData);
        } else if (newReg instanceof RegistryKeyObject) {
            RegistryKey registryKey = (RegistryKey)newReg.getDataObject();
            obsoleteItem = new ObsoleteItem(registryKey.getI());
            if (removedItems.contains(obsoleteItem)) {
                alRegistry.removeObsoleteItem(obsoleteItem);
            }
            alRegistry.addRegistryKey(registryKey);
        } else if (newReg instanceof RegistryValueObject) {
            RegistryValue registryValue = (RegistryValue)newReg.getDataObject();
            obsoleteItem = new ObsoleteItem(registryValue.getI());
            if (removedItems.contains(obsoleteItem)) {
                alRegistry.removeObsoleteItem(obsoleteItem);
            }
            alRegistry.addRegistryValue(registryValue);
        }
    }

    @Override
    public void delete() {
        this._orCondition.getParent().removeChild((AbstractSchema)this._orCondition);
    }

    public void clearAllAddress() {
        AddressObject[] allAddress = this.getAddress();
        for (int i = 0; i < allAddress.length; ++i) {
            allAddress[i].delete();
        }
    }

    private void recreateObject(int type) {
        this.addressType = type;
        switch (type) {
            case 0: {
                this._orCondition = new IPAddressesHostNames();
                break;
            }
            case 1: {
                this._orCondition = new RegistryEntries();
                break;
            }
            case 2: {
                this._orCondition = new OperatingSystems();
                break;
            }
        }
    }

    private String formatLocalHost() {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("<table><tr><td>");
        URL url = ConsoleMain.class.getResource("IPaddressAndHost.png");
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            buffer.append("<img src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\" />");
        } else {
            buffer.append("<image src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\"></image>");
        }
        buffer.append("</td><td><b>");
        buffer.append(MSGRES.getString(DLG, "RuleSetObject.ruleType.IPAddressAndHostName"));
        buffer.append("</b></td></tr></table>");
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatREGISTRY() {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("<table><tr><td>");
        URL url = ConsoleMain.class.getResource("registerKey.png");
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            buffer.append("<img src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\" />");
        } else {
            buffer.append("<image src =\"");
            url = ConsoleMain.class.getResource("registerKey.png");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\"></image>");
        }
        buffer.append("</td><td><b>");
        buffer.append(MSGRES.getString(DLG, "RuleSetObject.ruleType.registryKeys"));
        buffer.append("</b></td></tr></table>");
        buffer.append("</html>");
        return buffer.toString();
    }

    private String formatOperatingSystem() {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("<table><tr><td>");
        URL url = ConsoleMain.class.getResource("OperatingSystem.png");
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            buffer.append("<img src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\" />");
        } else {
            buffer.append("<image src =\"");
            if (url != null) {
                buffer.append(url.toString());
            }
            buffer.append("\"></image>");
        }
        buffer.append("</td><td><b>");
        buffer.append(MSGRES.getString(DLG, "RuleSetObject.ruleType.operatingSystems"));
        buffer.append("</b></td></tr></table>");
        buffer.append("</html>");
        return buffer.toString();
    }

    private static void removeAllChildren(ConfigObject parent) {
        removedItems.clear();
        for (ConfigObject cObj : parent.getChildren()) {
            parent.removeChild((AbstractSchema)cObj);
            removedItems.add(new ObsoleteItem(cObj.getI()));
        }
    }

    public String toString() {
        switch (this.addressType) {
            case 0: {
                return this.formatLocalHost();
            }
            case 1: {
                return this.formatREGISTRY();
            }
            case 2: {
                return this.formatOperatingSystem();
            }
        }
        return MSGRES.getString(DLG, "RuleSetObject.UnknownCondition");
    }

    public int getType() {
        return this.addressType;
    }

    public void setType(int newType) {
        if (this.addressType != newType) {
            this.recreateObject(newType);
        }
    }

    public ConfigObject getObject() {
        return this._orCondition;
    }

    public AddressObject[] getAddress() {
        ConsoleAssertion.runAssert(this.addressType != 0, MSGRES.getString(DLG, "RuleSetObject.itIsNotLocalAddressType") + this.addressType);
        ArrayList<AddressObject> allAddress = new ArrayList<AddressObject>();
        IPAddressesHostNames local = (IPAddressesHostNames)this._orCondition;
        for (IpAddress ipAddress : local.getIpAddress()) {
            allAddress.add(new AddressObject(0, (ConfigObject)ipAddress));
        }
        for (IpAddress ipAddress : local.getIpv6Address()) {
            allAddress.add(new AddressObject(7, (ConfigObject)ipAddress));
        }
        for (HostName hostName : local.getHostName()) {
            allAddress.add(new AddressObject(4, (ConfigObject)hostName));
        }
        return allAddress.toArray(new AddressObject[0]);
    }

    public List<OperatingSystemNameObject> getOperatingSystemNameObject() {
        ArrayList<OperatingSystemNameObject> osNameObjects = new ArrayList<OperatingSystemNameObject>();
        String allOS = this.getOperatingSystemNames();
        StringTokenizer tokens = new StringTokenizer(allOS, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            OperatingSystemNameObject obj = new OperatingSystemNameObject(token);
            osNameObjects.add(obj);
        }
        return osNameObjects;
    }

    public RuleSetObject getClone() throws ConsoleException {
        ConfigObject newObj = PolicyHandler.getCopyOfObj(this._orCondition);
        return new RuleSetObject(this.addressType, newObj);
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            ConfigObject newObj = washer.duplicateObject(this._orCondition, createdObj);
            RuleSetObject orObj = new RuleSetObject(this.addressType, newObj);
            return orObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public void setNewAddresses(List<AddressObject> addresslist) {
        ConsoleAssertion.runAssert(this.addressType != 0, MSGRES.getString(DLG, "RuleSetObject.itIsNotLocalAddressType") + this.addressType);
        IPAddressesHostNames local = (IPAddressesHostNames)this._orCondition;
        RuleSetObject.removeAllChildren((ConfigObject)local);
        for (AddressObject newAddr : addresslist) {
            this.addAddress(newAddr);
        }
        removedItems.clear();
    }

    @Override
    public void setCountNumber(int newCnt) {
    }

    public List<RegistryObject> getRegistryData() {
        ConsoleAssertion.runAssert(this.addressType != 1, MSGRES.getString(DLG, "RuleSetObject.itIsNotRegistriesType") + this.addressType);
        ArrayList<RegistryObject> allRegistry = new ArrayList<RegistryObject>();
        RegistryEntries registry = (RegistryEntries)this._orCondition;
        for (RegistryKey registryKey : registry.getRegistryKey()) {
            allRegistry.add(new RegistryKeyObject((ConfigObject)registryKey));
        }
        for (RegistryValue registryValue : registry.getRegistryValue()) {
            allRegistry.add(new RegistryValueObject((ConfigObject)registryValue));
        }
        for (RegistryData registryData : registry.getRegistryData()) {
            allRegistry.add(new RegistryDataObject((ConfigObject)registryData));
        }
        return allRegistry;
    }

    public void setRegistryData(List<RegistryObject> registryDataList) {
        ConsoleAssertion.runAssert(this.addressType != 1, MSGRES.getString(DLG, "RuleSetObject.itIsNotRegistriesType") + this.addressType);
        RegistryEntries registry = (RegistryEntries)this._orCondition;
        RuleSetObject.removeAllChildren((ConfigObject)registry);
        for (RegistryObject registryObject : registryDataList) {
            this.addRegistryData(registryObject);
        }
        removedItems.clear();
    }

    public String getOperatingSystemNames() {
        ConsoleAssertion.runAssert(this.addressType != 2, MSGRES.getString(DLG, "RuleSetObject.itIsNotOperatingSystemType") + this.addressType);
        return this.operatingSystemNames;
    }

    public void setOperatingSystemNames(String osNames) {
        ConsoleAssertion.runAssert(this.addressType != 2, MSGRES.getString(DLG, "RuleSetObject.itIsNotOperatingSystemType") + this.addressType);
        this.operatingSystemNames = osNames;
    }

    public String getOperatingSystemCode() {
        ConsoleAssertion.runAssert(this.addressType != 2, MSGRES.getString(DLG, "RuleSetObject.itIsNotOperatingSystemType") + this.addressType);
        OperatingSystems alOS = (OperatingSystems)this._orCondition;
        return alOS.getContent();
    }

    public void setOperatingSystemCode(String selectedOS) {
        ConsoleAssertion.runAssert(this.addressType != 2, MSGRES.getString(DLG, "RuleSetObject.itIsNotOperatingSystemType") + this.addressType);
        OperatingSystems alOS = (OperatingSystems)this._orCondition;
        alOS.setContent(selectedOS);
    }
}

