/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.RevisionFormatter;
import com.sygate.scm.util.StringUtilities;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RevisionObject
extends AbstractUIObject
implements Comparable<RevisionObject> {
    private static final int REVISION_FORMATTER = 0;
    private static final int ENGINE_FORMATTER = 1;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.logicobject.logicobject");
    static final String NOT_AVAILABLE = MSGRES.getString("RevisionObject.Not.Available");
    static final String NO_THIS_CONTENT = MSGRES.getString("RevisionObject.No.This.Content");
    private static final RevisionObject NULL_REVISION = new RevisionObject(1970, 1, 1, 0);
    private static final NumberFormat DB_YEAR_FORMATTER = new DecimalFormat("0000");
    private static final NumberFormat DB_MONTH_FORMATTER = new DecimalFormat("00");
    private static final NumberFormat DB_DAY_FORMATTER = new DecimalFormat("00");
    private static final NumberFormat DB_REV_FORMATTER = new DecimalFormat("000");
    private static final String DB_FORMAT = "{0}-{1}-{2} rev. {3}";
    private static final String DB_PATTERN = "(\\d{4})-(\\d{2})-(\\d{2})\\ rev\\.\\ (\\d{3})";
    private static final NumberFormat UI_YEAR_FORMATTER = new DecimalFormat("0000");
    private static final NumberFormat UI_MONTH_FORMATTER = new DecimalFormat("00");
    private static final NumberFormat UI_DAY_FORMATTER = new DecimalFormat("00");
    private static final String UI_FORMAT = "{0}/{1}/{2} r{3}";
    private static final String ENGINE_FORMAT = "{0}/{1}/{2}";
    private static final String UI_FORMAT_NEW = "{0} r{1}";
    private int year = 1970;
    private int month = 1;
    private int day = 1;
    private int rev = 0;
    private boolean useBuildNumberFormat = false;
    private String sequenceNumber = null;
    private int displayFormat;

    public static String convertDbFormatStringToUIFormat(String dbStr) {
        if (StringUtilities.isEmpty((String)dbStr)) {
            return NOT_AVAILABLE;
        }
        RevisionObject r = RevisionObject.fromDbFormatString(dbStr);
        if (r != null) {
            if (r.compareTo(NULL_REVISION) <= 0) {
                return NOT_AVAILABLE;
            }
            return r.toUIFormatString();
        }
        return dbStr;
    }

    public static int compareDbFormatRevision(String dbRev1, String dbRev2) {
        RevisionObject r1 = RevisionObject.fromDbFormatString(dbRev1);
        RevisionObject r2 = RevisionObject.fromDbFormatString(dbRev2);
        if (r1 == null) {
            if (r2 == null) {
                return 0;
            }
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        return r1.compareTo(r2);
    }

    public static String convertSequenceToRevUIFormat(String seq) {
        RevisionObject r = RevisionObject.fromSequenceNumber(seq);
        if (r != null) {
            return r.toUIFormatString();
        }
        return seq;
    }

    public static String convertEngineNumToUIFormat(String seq) {
        RevisionObject r = RevisionObject.fromEngineNumber(seq);
        if (r != null) {
            return r.toEngineFormatString();
        }
        return seq;
    }

    public static RevisionObject fromDbFormatString(String str) {
        Pattern p;
        Matcher matcher;
        if (!StringUtilities.isEmpty((String)str) && (matcher = (p = Pattern.compile(DB_PATTERN)).matcher(str)).matches()) {
            try {
                int year = Integer.parseInt(matcher.group(1));
                int month = Integer.parseInt(matcher.group(2));
                int day = Integer.parseInt(matcher.group(3));
                int rev = Integer.parseInt(matcher.group(4));
                return new RevisionObject(year, month, day, rev);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static RevisionObject fromSequenceNumber(String seq) {
        if (!StringUtilities.isEmpty((String)seq)) {
            int year = 1970;
            int month = 1;
            int day = 1;
            int rev = 0;
            StringBuffer sbSeq = new StringBuffer();
            sbSeq.append(seq);
            while (sbSeq.length() < 9) {
                sbSeq.insert(0, '0');
            }
            if (sbSeq.length() == 9) {
                sbSeq.insert(0, "20");
            }
            try {
                year = Integer.parseInt(sbSeq.substring(0, 4), 10);
                month = Integer.parseInt(sbSeq.substring(4, 6), 10);
                day = Integer.parseInt(sbSeq.substring(6, 8), 10);
                rev = Integer.parseInt(sbSeq.substring(8), 10);
                return new RevisionObject(year, month, day, rev);
            }
            catch (NumberFormatException nfe) {
                LoggerUtilities.logException((Throwable)nfe);
            }
        }
        return null;
    }

    public static RevisionObject fromEngineNumber(String seq) {
        if (!StringUtilities.isEmpty((String)seq)) {
            int year = 1970;
            int month = 1;
            int day = 1;
            StringBuffer sbSeq = new StringBuffer();
            sbSeq.append(seq);
            if (sbSeq.length() != 8) {
                return null;
            }
            try {
                year = Integer.parseInt(sbSeq.substring(0, 4), 10);
                month = Integer.parseInt(sbSeq.substring(4, 6), 10);
                day = Integer.parseInt(sbSeq.substring(6), 10);
                return new RevisionObject(year, month, day, 0, 1);
            }
            catch (NumberFormatException nfe) {
                LoggerUtilities.logException((Throwable)nfe);
            }
        }
        return null;
    }

    public RevisionObject(int year, int month, int day, int rev) {
        this(year, month, day, rev, 0);
    }

    public RevisionObject(int year, int month, int day, int rev, int displayFormat) {
        this.setValue(year, month, day, rev);
        this.displayFormat = displayFormat;
    }

    public RevisionObject(String sequenceNumber, boolean useBuildNumberFormat) {
        this.useBuildNumberFormat = useBuildNumberFormat;
        this.sequenceNumber = sequenceNumber;
        this.displayFormat = 0;
    }

    public void setValue(int year, int month, int day, int rev) {
        if (year < 1) {
            year = 1;
        }
        if (year > 9999) {
            year = 9999;
        }
        if (month < 1) {
            month = 1;
        }
        if (month > 12) {
            month = 12;
        }
        if (day < 1) {
            day = 1;
        }
        if (day > 31) {
            day = 31;
        }
        if (rev < 0) {
            rev = 0;
        }
        if (rev > 999) {
            rev = 999;
        }
        this.year = year;
        this.month = month;
        this.day = day;
        this.rev = rev;
    }

    public String toDbFormatString() {
        return MessageFormat.format(DB_FORMAT, DB_YEAR_FORMATTER.format(this.year), DB_MONTH_FORMATTER.format(this.month), DB_DAY_FORMATTER.format(this.day), DB_REV_FORMATTER.format(this.rev));
    }

    public String toUIFormatString() {
        if (this.useBuildNumberFormat) {
            return RevisionFormatter.toBuildNumberFormat((String)this.sequenceNumber);
        }
        boolean flag = ScmProperties.getRevisionDateFormatFlag();
        if (flag) {
            System.out.println("RevObj >> Revision date format according to locale is selected.");
            Calendar c = Calendar.getInstance();
            c.set(this.year, this.month - 1, this.day);
            DateFormat df = DateFormat.getDateInstance(2, Locale.getDefault());
            return MessageFormat.format(UI_FORMAT_NEW, df.format(c.getTime()), this.rev);
        }
        return MessageFormat.format(UI_FORMAT, UI_MONTH_FORMATTER.format(this.month), UI_DAY_FORMATTER.format(this.day), UI_YEAR_FORMATTER.format(this.year), this.rev);
    }

    public String toEngineFormatString() {
        return MessageFormat.format(ENGINE_FORMAT, UI_MONTH_FORMATTER.format(this.month), UI_DAY_FORMATTER.format(this.day), UI_YEAR_FORMATTER.format(this.year));
    }

    public String toString() {
        return this.displayFormat == 0 ? this.toUIFormatString() : this.toEngineFormatString();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getRev() {
        return this.rev;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RevisionObject) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    @Override
    public int compareTo(RevisionObject other) {
        if (other == null) {
            return 1;
        }
        if (this.year > other.year) {
            return 1;
        }
        if (this.year < other.year) {
            return -1;
        }
        if (this.month > other.month) {
            return 1;
        }
        if (this.month < other.month) {
            return -1;
        }
        if (this.day > other.day) {
            return 1;
        }
        if (this.day < other.day) {
            return -1;
        }
        if (this.rev > other.rev) {
            return 1;
        }
        if (this.rev < other.rev) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return ((this.year * 16 + this.month) * 32 + this.day) * 1024 + this.rev;
    }
}

