/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.RegistryValue;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.RegistryObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.HTMLUtilities;

public class RegistryValueObject
extends RegistryObject {
    private static final String REG_TYPE = "RegistryDataObject.registryKeyName";

    public RegistryValueObject() {
        super((ConfigObject)new RegistryValue(), REG_TYPE);
        this.getData().setOptOperator(Integer.valueOf(0));
    }

    public RegistryValueObject(ConfigObject obj) {
        super(obj, REG_TYPE);
    }

    public String getValueName() {
        return this.getData().getValueName();
    }

    public int getOptOperator() {
        return this.getData().getOptOperator();
    }

    public String getOptOperatorValue() throws ValidationException {
        return this.getData().getOptOperatorValue();
    }

    public RegistryValueObject getClone() throws ConsoleException {
        ConfigObject newData = PolicyHandler.getCopyOfObj((ConfigObject)this.getData());
        RegistryValueObject newObj = new RegistryValueObject(newData);
        return newObj;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getRegType();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("<html>");
        buffer.append("&nbsp;&nbsp;");
        buffer.append(this.getValueAt(0));
        buffer.append(" ");
        buffer.append(HTMLUtilities.filter((String)this.getValueAt(1).toString()));
        buffer.append("</html>");
        return buffer.toString();
    }

    private RegistryValue getData() {
        return (RegistryValue)this.getDataObject();
    }

    private String getDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append("[");
        desc.append(this.getValueName());
        desc.append("] ");
        if (this.getOptOperator() == 0) {
            desc.append(MSGRES.getString("com.sygate.scm.console.logicobject.logicobject", "RegistryDataObject.exists"));
        } else {
            desc.append(MSGRES.getString("com.sygate.scm.console.logicobject.logicobject", "RegistryDataObject.notExists"));
        }
        return desc.toString();
    }
}

