/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.RadiusServer;
import com.sygate.scm.console.logicobject.AbstractUIObject;

public class RadiusServerObject
extends AbstractUIObject {
    private RadiusServer server;

    public RadiusServerObject(RadiusServer server) {
        this.server = server;
    }

    public static RadiusServerObject newInstance() {
        RadiusServer newServer = new RadiusServer();
        return new RadiusServerObject(newServer);
    }

    protected RadiusServer getRadiusServer() {
        return this.server;
    }

    public String getName() {
        String name = this.server.getName();
        return name == null ? "" : name;
    }

    public String getRadiusServerAddress() {
        String address = this.server.getRadiusServerAddress();
        return address == null ? "" : address;
    }

    public String getAuthPort() {
        Integer port = this.server.getOptAuthPort();
        if (port == null) {
            port = this.server.getDefAuthPort();
        }
        return port.toString();
    }

    public String getSharedSecret() {
        return this.server.getSharedSecret();
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.server.setName(name);
        }
    }

    public void setRadiusServerAddress(String address) {
        if (!address.equals(this.getRadiusServerAddress())) {
            this.server.setRadiusServerAddress(address);
        }
    }

    public void setAuthPort(String port) {
        if (port.length() == 0) {
            port = this.server.getDefAuthPort().toString();
        }
        if (!port.equals(this.getAuthPort())) {
            this.server.setOptAuthPort(Integer.valueOf(Integer.parseInt(port)));
        }
    }

    public void setSharedSecret(String secret) {
        if (!secret.equals(this.getSharedSecret())) {
            this.server.setSharedSecret(secret);
        }
    }

    public String getTimeout() {
        Integer timeout = this.server.getOptTimeout();
        if (timeout == null) {
            timeout = this.server.getDefTimeout();
        }
        return timeout.toString();
    }

    public void setTimeout(String timeout) {
        if (timeout.length() == 0) {
            timeout = this.server.getDefTimeout().toString();
        }
        if (!timeout.equals(this.getTimeout())) {
            this.server.setOptTimeout(Integer.valueOf(Integer.parseInt(timeout)));
        }
    }

    public String getRetry() {
        Integer retry = this.server.getOptRetry();
        if (retry == null) {
            retry = this.server.getDefRetry();
        }
        return retry.toString();
    }

    public void setRetry(String retry) {
        if (retry.length() == 0) {
            retry = this.server.getDefRetry().toString();
        }
        if (!retry.equals(this.getRetry())) {
            this.server.setOptRetry(Integer.valueOf(Integer.parseInt(retry)));
        }
    }
}

