/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroupPool;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.RadiusServerGroupObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class RadiusServerGroupPoolObject
extends AbstractUIObject {
    private SeRadiusServerGroupPool groupPool;

    public RadiusServerGroupPoolObject(SeRadiusServerGroupPool groupPool) {
        this.groupPool = groupPool;
    }

    public Collection<RadiusServerGroupObject> getRadiusServerGroups(String enforcerGroup) {
        ArrayList<RadiusServerGroupObject> groups = new ArrayList<RadiusServerGroupObject>();
        for (int i = 0; i < this.groupPool.getObjReferenceCount(); ++i) {
            ObjReference objRef = this.groupPool.getObjReference(i);
            if (null == objRef) {
                System.err.println("RadiusServerGroupObject->getRadiusServerGroups: The ObjReference is null.");
                continue;
            }
            try {
                SeRadiusServerGroup group = DataobjectManager.getInstance().getSeRadiusServerGroup(objRef.getTargetId());
                if (!(group != null & enforcerGroup != null)) continue;
                String enforcerGrpName = group.getOptEnforcerGroupName();
                if (enforcerGrpName != null) {
                    if (!enforcerGroup.equals(group.getOptEnforcerGroupName())) continue;
                    groups.add(new RadiusServerGroupObject(group));
                    continue;
                }
                groups.add(new RadiusServerGroupObject(group));
                continue;
            }
            catch (ConsoleException e) {
                System.err.println("RadiusServerGroupObject->getRadiusServerGroups: Exception! Cannot get the RadiusServerGroup via id :" + objRef.getTargetId());
            }
        }
        return groups;
    }

    public void setRadiusServerGroups(Collection<RadiusServerGroupObject> groupObjs, boolean isDeleteRadiusGrp, String groupName) {
        Vector objRefs = this.groupPool.getObjReference();
        try {
            int i = objRefs.size();
            while (--i >= 0) {
                SeRadiusServerGroup group;
                String grpName;
                ObjReference objRef = (ObjReference)objRefs.get(i);
                RadiusServerGroupObject groupObj = this.findMatchingGroup(objRef.getTargetId(), groupObjs);
                if (groupObj != null) {
                    groupObj.updateRadiusServerGroup();
                    groupObjs.remove(groupObj);
                    continue;
                }
                if (!isDeleteRadiusGrp || (grpName = (group = DataobjectManager.getInstance().getSeRadiusServerGroup(objRef.getTargetId())).getOptEnforcerGroupName()) == null || groupName == null || !grpName.equalsIgnoreCase(groupName)) continue;
                DataobjectManager.getInstance().deleteObject((TopLevelObject)group);
                this.groupPool.removeObjReference(objRef);
            }
            for (RadiusServerGroupObject groupObj : groupObjs) {
                this.addRadiusServerGroupToPool(groupObj.getRadiusServerGroup());
            }
        }
        catch (ConsoleException ex) {
            System.err.println("RadiusServerGroupObject->setRadiusServerGroups: Exception!");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private RadiusServerGroupObject findMatchingGroup(String id, Collection<RadiusServerGroupObject> groupObjs) {
        for (RadiusServerGroupObject groupObj : groupObjs) {
            if (!id.equals(groupObj.getId())) continue;
            return groupObj;
        }
        return null;
    }

    public String getRadiusGroupIdInInPool(SeRadiusServerGroup rsGroup) {
        for (RadiusServerGroupObject curRSGroup : this.getRadiusServerGroups(rsGroup.getOptEnforcerGroupName())) {
            String id = curRSGroup.getExistingRadiusServerGroupId(rsGroup);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    private void addRadiusServerGroupToPool(SeRadiusServerGroup rsGroup) {
        ObjReference objRef = new ObjReference();
        objRef.setName("RadiusServerGroupLink");
        objRef.setTargetId(rsGroup.getId());
        objRef.setTargetType("SeRadiusServerGroup");
        this.groupPool.addObjReference(objRef);
        try {
            DataobjectManager.getInstance().addSeRadiusServerGroup(rsGroup);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void addRadiusServerGroup(List<SeRadiusServerGroup> groupList) {
        for (SeRadiusServerGroup rsGroup : groupList) {
            this.addRadiusServerGroupToPool(rsGroup);
        }
    }

    public void deleteRadiusServerGroup(List<SeRadiusServerGroup> groupList) {
        Vector objRefs = this.groupPool.getObjReference();
        for (SeRadiusServerGroup rsGroup : groupList) {
            int i = objRefs.size();
            while (--i >= 0) {
                ObjReference objRef1 = (ObjReference)objRefs.get(i);
                if (!rsGroup.getId().equals(objRef1.getTargetId())) continue;
                this.groupPool.removeObjReference(objRef1);
                try {
                    DataobjectManager.getInstance().deleteSeRadiusServerGroup(rsGroup);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        }
    }
}

