/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.RadiusServer;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.RadiusServerObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class RadiusServerGroupObject
extends AbstractUIObject {
    private SeRadiusServerGroup group;

    public RadiusServerGroupObject(SeRadiusServerGroup group) {
        this.group = group;
    }

    public static RadiusServerGroupObject newInstance(String enforcerGroup) {
        SeRadiusServerGroup newGroup = new SeRadiusServerGroup();
        newGroup.setId(new GUIDGenerator().getGUIDString());
        if (enforcerGroup != null) {
            newGroup.setOptEnforcerGroupName(enforcerGroup);
        }
        return new RadiusServerGroupObject(newGroup);
    }

    public void updateRadiusServerGroup() throws ConsoleException {
        DataobjectManager.getInstance().updateObject("Overwrite", (TopLevelObject)this.group);
    }

    public String getExistingRadiusServerGroupId(SeRadiusServerGroup newGroup) {
        if (this.group.getRadiusServerCount() != newGroup.getRadiusServerCount()) {
            return null;
        }
        for (int i = 0; i < this.group.getRadiusServerCount(); ++i) {
            RadiusServerObject curRSObj = new RadiusServerObject(this.group.getRadiusServer(i));
            RadiusServerObject newRSObj = new RadiusServerObject(newGroup.getRadiusServer(i));
            if (curRSObj.getRadiusServerAddress().equals(newRSObj.getRadiusServerAddress()) && curRSObj.getAuthPort().equals(newRSObj.getAuthPort()) && curRSObj.getSharedSecret().equals(newRSObj.getSharedSecret())) continue;
            return null;
        }
        return this.group.getId();
    }

    public String toString() {
        return this.getName();
    }

    public String getId() {
        return this.group.getId();
    }

    public String getName() {
        String name = this.group.getName();
        return name == null ? "" : name;
    }

    public Collection<RadiusServerObject> getRadiusServers() {
        ArrayList<RadiusServerObject> servers = new ArrayList<RadiusServerObject>();
        for (int i = 0; i < this.group.getRadiusServerCount(); ++i) {
            servers.add(new RadiusServerObject(this.group.getRadiusServer(i)));
        }
        return servers;
    }

    public String getRadiusServersString() {
        StringBuffer buf = new StringBuffer();
        Collection<RadiusServerObject> servers = this.getRadiusServers();
        for (RadiusServerObject serverObj : servers) {
            buf.append("; " + serverObj.getRadiusServerAddress());
        }
        return buf.length() > 0 ? buf.substring(2) : "";
    }

    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.group.setName(name);
        }
    }

    public void setRadiusServers(Collection<RadiusServerObject> servers) {
        Vector oldServers = this.group.getRadiusServer();
        int i = oldServers.size();
        while (--i >= 0) {
            this.group.removeRadiusServer((RadiusServer)oldServers.get(i));
        }
        Iterator<RadiusServerObject> itr = servers.iterator();
        while (itr.hasNext()) {
            this.group.addRadiusServer(itr.next().getRadiusServer());
        }
    }

    protected SeRadiusServerGroup getRadiusServerGroup() {
        return this.group;
    }
}

