/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;

public class PrivateInsightServerObject
extends AbstractUIObject
implements DeletableObjInt,
CopitableObject {
    private final PrivateInsightServer server;

    public PrivateInsightServerObject(PrivateInsightServer server) {
        this.server = server;
    }

    public PrivateInsightServerObject() {
        this.server = new PrivateInsightServer();
    }

    public PrivateInsightServer getPrivateInsightServer() {
        return this.server;
    }

    public String toString() {
        String protocol = "";
        if (this.server.getOptProtocol().intValue() == PrivateInsightServer.HTTP.intValue()) {
            protocol = "http://";
        } else if (this.server.getOptProtocol().intValue() == PrivateInsightServer.HTTPS.intValue()) {
            protocol = "https://";
        }
        String fullAddress = protocol + this.server.getAddress();
        if (this.server.getPort() != null) {
            fullAddress = fullAddress + ":" + this.server.getPort().toString();
        }
        if (this.server.getOptLegacyClientSupport() != null && this.server.getOptLegacyClientSupport().booleanValue()) {
            fullAddress = "<html><strong>" + fullAddress + "</strong></html>";
        }
        return fullAddress;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        return null;
    }

    @Override
    public void delete() {
    }

    public PrivateInsightServerObject getClone() {
        PrivateInsightServer newServer = new PrivateInsightServer();
        newServer.setName(this.server.getName());
        newServer.setAddress(this.server.getAddress());
        newServer.setOptProtocol(this.server.getOptProtocol());
        newServer.setPort(this.server.getPort());
        newServer.setOptEnable(this.server.getOptEnable());
        newServer.setOptLegacyClientSupport(this.server.getOptLegacyClientSupport());
        return new PrivateInsightServerObject(newServer);
    }
}

