/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.NamedObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PolicyObjectBase
extends AbstractUIObject
implements TreeItem,
CopitableObject,
AppliablePolicy {
    protected static final String SOURCE_ATP = "ATP";
    protected static final String SOURCE_SAEP = "SAEP";
    protected TopLevelObject policy;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> changedObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();

    protected PolicyObjectBase() {
    }

    protected PolicyObjectBase(PolicyObjectBase policyObject) {
        this.policy = policyObject.getSchemaObj();
        this.newObjSet = policyObject.getNewObjSet();
        this.changedObjSet = policyObject.getChangedObjSet();
        this.deletedObjSet = policyObject.getDeletedObjSet();
    }

    protected PolicyObjectBase(TopLevelObject policy) {
        this.policy = policy;
    }

    @Override
    public String getName() {
        return ((NamedObject)this.policy).getName();
    }

    public void setName(String newValue) {
        String oldValue = this.getName();
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        ((NamedObject)this.policy).setName(newValue);
    }

    @Override
    public String getDescription() {
        return ((NamedObject)this.policy).getOptDescription();
    }

    @Override
    public String getId() {
        return this.policy.getId();
    }

    public String handleSources() {
        return null;
    }

    public boolean isExclusiveEdit() {
        return false;
    }

    public TopLevelObject getSchemaObj() {
        return this.policy;
    }

    public void setSchemaObj(TopLevelObject policy) {
        this.policy = policy;
    }

    public long getLastModifiedTime() {
        return this.policy.getT();
    }

    public TopLevelObject getCopyOfPolicyObject() throws ConsoleException {
        return (TopLevelObject)PolicyHandler.getCopyOfObj((ConfigObject)this.policy);
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            TopLevelObject newAl = (TopLevelObject)washer.duplicateObject((ConfigObject)this.policy, createdObj);
            PolicyObjectBase newObj = this.createPolicyObject(newAl);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public List<TopLevelObject> getPrivateObjectList() {
        return null;
    }

    public void addNewObj(TopLevelObject policy) {
        this.newObjSet.put(policy.getId(), policy);
    }

    public void addNewObj(Map<String, TopLevelObject> newObjList) {
        this.newObjSet.putAll(newObjList);
    }

    public Map<String, TopLevelObject> getNewObjSet() {
        return this.newObjSet;
    }

    public Map<String, TopLevelObject> getChangedObjSet() {
        return this.changedObjSet;
    }

    public Map<String, TopLevelObject> getDeletedObjSet() {
        return this.deletedObjSet;
    }

    public void clearAllObjSets() {
        this.newObjSet.clear();
        this.changedObjSet.clear();
        this.deletedObjSet.clear();
    }

    public boolean isAnyObjectSetModified() {
        boolean result = false;
        if (this.newObjSet.size() > 0 || this.changedObjSet.size() > 0 || this.deletedObjSet.size() > 0) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public abstract String getTypeDesc();

    @Override
    public abstract int getItemType();

    @Override
    public abstract String getTargetType();

    public abstract String getTargetName();

    public abstract String getRefTargetName();

    public abstract String getCreator();

    public abstract void setCreator(String var1);

    protected void addChangedObj(TopLevelObject policy) {
        this.changedObjSet.put(policy.getId(), policy);
    }

    protected abstract PolicyObjectBase createPolicyObject(TopLevelObject var1) throws ConsoleException;
}

