/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import java.util.ArrayList;

public class PlatformObject {
    private PlatformObject serial;
    private LuSupportedClientPlatform platform;
    private ArrayList<PlatformObject> subs;

    public PlatformObject(LuSupportedClientPlatform platform) {
        this.platform = platform;
    }

    public String getContent() {
        return this.platform == null ? "" : this.platform.getContent();
    }

    public void setContent(String value) {
        this.platform.setContent(value);
    }

    public PlatformObject getSerial() {
        return this.serial;
    }

    public void setSerial(PlatformObject serial) {
        this.serial = serial;
        if (!serial.getSubs().contains(this)) {
            serial.addSub(this);
        }
    }

    public LuSupportedClientPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(LuSupportedClientPlatform platform) {
        this.platform = platform;
    }

    public ArrayList<PlatformObject> getSubs() {
        return this.subs;
    }

    public void setSubs(ArrayList<PlatformObject> subs) {
        for (PlatformObject sub : subs) {
            this.addSub(sub);
        }
    }

    public void addSub(PlatformObject sub) {
        if (this.subs == null) {
            this.subs = new ArrayList();
        }
        if (sub.getSerial() != null) {
            sub.getSerial().removeSub(sub);
        }
        if (!this.subs.contains(sub)) {
            this.subs.add(sub);
        }
        sub.setSerial(this);
    }

    public void removeSub(PlatformObject sub) {
        if (this.subs != null && this.subs.contains(sub)) {
            this.subs.remove(sub);
        }
    }

    public void removeAll() {
        if (this.subs != null) {
            this.subs.clear();
        }
    }

    public String getSubPlatformsInfo() {
        StringBuffer msg = new StringBuffer();
        if (this.subs != null && this.subs.size() > 0) {
            msg.append("The " + this.getContent() + " platform includes ");
            for (int index = 0; index < this.subs.size(); ++index) {
                if (index < this.subs.size() - 2) {
                    msg.append(this.subs.get(index).getContent() + " platform, ");
                    continue;
                }
                if (index == this.subs.size() - 2) {
                    msg.append(this.subs.get(index).getContent() + " platform and ");
                    continue;
                }
                msg.append(this.subs.get(index).getContent() + " platform. ");
            }
        }
        if (this.serial != null) {
            msg.append("It is included by " + this.serial.getContent() + " plaform.");
        }
        return msg.toString();
    }

    public String toString() {
        return this.getContent();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PlatformObject) {
            return this.toString().equals(obj.toString());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

