/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ReplicationPartnerArray;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.Partner;
import com.sygate.scm.console.logicobject.TreeItem;
import java.text.MessageFormat;

public class PartnerGroup
extends AbstractUIObject
implements TreeItem {
    private ReplicationPartnerArray partnerArray;
    private String siteId;

    public PartnerGroup(ReplicationPartnerArray partnerArray, String siteId) {
        this.partnerArray = partnerArray;
        this.siteId = siteId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public int getPartnerCount() {
        int totalCount = this.partnerArray.getReplicationPartnershipCount();
        int enabledCount = 0;
        for (int i = 0; i < totalCount; ++i) {
            ReplicationPartnership thisPartnership = this.partnerArray.getReplicationPartnership(i);
            if (thisPartnership.getOptEnable() != null && !thisPartnership.getOptEnable().booleanValue()) continue;
            ++enabledCount;
        }
        return enabledCount;
    }

    public Partner getPartner(int index) {
        int totalCount = this.partnerArray.getReplicationPartnershipCount();
        int enabledCount = 0;
        for (int i = 0; i < totalCount; ++i) {
            ReplicationPartnership thisPartnership = this.partnerArray.getReplicationPartnership(i);
            if (thisPartnership.getOptEnable() != null && !thisPartnership.getOptEnable().booleanValue()) continue;
            if (enabledCount == index) {
                return new Partner(thisPartnership, this.siteId);
            }
            ++enabledCount;
        }
        return null;
    }

    @Override
    public String getName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "PartnerGroup.ReplicationPartners");
    }

    @Override
    public int getItemType() {
        return 17;
    }

    @Override
    public String getId() {
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "PartnerGroup.SiteDashReplicationPartners"), this.siteId);
    }

    public String toString() {
        return this.getName();
    }
}

