/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.common.configobject.schema.PartnerState;
import com.sygate.scm.common.configobject.schema.Replication;
import com.sygate.scm.common.configobject.schema.ReplicationContent;
import com.sygate.scm.common.configobject.schema.ReplicationPartnerArray;
import com.sygate.scm.common.configobject.schema.ReplicationPartnership;
import com.sygate.scm.common.configobject.schema.ReplicationState;
import com.sygate.scm.common.configobject.schema.Schedule;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SiteContactArray;
import com.sygate.scm.common.configobject.schema.TimeFrame;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ReplicationScheduleUtility;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;

public class Partner
extends AbstractUIObject
implements TreeItem {
    private static final long MILLIS_IN_AN_HOUR = 3600000L;
    private ReplicationPartnership partnerShip;
    private String localSiteId;
    private static final long NON_REPLICATED_START_TIME = -1L;

    public Partner() {
    }

    public Partner(ReplicationPartnership partnerShip, String localSiteId) {
        this.partnerShip = partnerShip;
        this.localSiteId = localSiteId;
    }

    public String getLocalSiteId() {
        return this.localSiteId;
    }

    public String getPartnerSiteName() {
        return this.partnerShip.getPartnerSiteName();
    }

    public void setPartnerSiteName(String value) {
        this.partnerShip.setPartnerSiteName(value);
    }

    @Override
    public String getName() {
        return this.getPartnerSiteName();
    }

    @Override
    public int getItemType() {
        return 18;
    }

    @Override
    public String getId() {
        return this.localSiteId + "-" + this.getPartnerSiteName();
    }

    public String toString() {
        return this.getPartnerSiteName();
    }

    public String getDescription() {
        String value = this.partnerShip.getOptSourceSiteDescription();
        return value == null ? "" : value.trim();
    }

    public String getContactList() {
        SiteContactArray contactArray = this.partnerShip.getSiteContactArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < contactArray.getHostAddressCount(); ++i) {
            HostAddress hostAddress;
            if (i > 0) {
                buf.append("\n");
            }
            if ((hostAddress = contactArray.getHostAddress(i)).getOptPort() != null && hostAddress.getOptPort() != Env.getSEM_PORT()) {
                buf.append(hostAddress.getContent().trim());
                buf.append(":").append(hostAddress.getOptPort());
                continue;
            }
            buf.append(Utility.checkAndRemoveBrackets((String)hostAddress.getContent().trim()));
        }
        return buf.toString().trim();
    }

    public boolean isReplicateLogs() {
        ReplicationContent content = this.partnerShip.getOptReplicationContent();
        if (content == null || content.getOptReplicateLogs() == null) {
            return false;
        }
        return content.getOptReplicateLogs();
    }

    public void setReplicateLogs(boolean replicate) {
        ReplicationContent content = this.partnerShip.getOptReplicationContent();
        if (content == null) {
            content = new ReplicationContent();
            this.partnerShip.setOptReplicationContent(content);
        }
        content.setOptReplicateLogs(Boolean.valueOf(replicate));
    }

    public boolean isReplicateClientPackages() {
        ReplicationContent content = this.partnerShip.getOptReplicationContent();
        if (content == null || content.getOptReplicateClientPackages() == null) {
            return true;
        }
        return content.getOptReplicateClientPackages();
    }

    public void setReplicateClientPackages(boolean replicate) {
        ReplicationContent content = this.partnerShip.getOptReplicationContent();
        if (content == null) {
            content = new ReplicationContent();
            this.partnerShip.setOptReplicationContent(content);
        }
        content.setOptReplicateClientPackages(Boolean.valueOf(replicate));
    }

    public boolean isReplicateLuContents() {
        ReplicationContent content = this.partnerShip.getOptReplicationContent();
        if (content == null || content.getOptReplicateLuContents() == null) {
            return true;
        }
        return content.getOptReplicateLuContents();
    }

    public void setReplicateLuContents(boolean replicate) {
        ReplicationContent content = this.partnerShip.getOptReplicationContent();
        if (content == null) {
            content = new ReplicationContent();
            this.partnerShip.setOptReplicationContent(content);
        }
        content.setOptReplicateLuContents(Boolean.valueOf(replicate));
    }

    public boolean isAutoReplicate() {
        Schedule schedule = this.partnerShip.getOptSchedule();
        if (schedule == null || schedule.getOptEnable() == null) {
            return true;
        }
        return schedule.getOptEnable() == false;
    }

    public String getFrequency() {
        if (this.isAutoReplicate()) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NotApplicable");
        }
        Schedule configuredSchedule = this.partnerShip.getOptSchedule();
        String frequency = null;
        String dayOfWeek = configuredSchedule.getOptStartDayOfWeek();
        Integer hourlyFrequency = configuredSchedule.getOptHourlyFrequency();
        String startHour = configuredSchedule.getOptStartHour();
        frequency = dayOfWeek != null && dayOfWeek.trim().length() > 0 ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.Weekly") : (startHour != null && hourlyFrequency == null ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.Daily") : MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.Hourly"));
        return frequency;
    }

    public Integer getHourlyFrequency() {
        Schedule configuredSchedule = this.partnerShip.getOptSchedule();
        int hourlyFrequency = configuredSchedule.getOptHourlyFrequency() == null ? configuredSchedule.getDefHourlyFrequency() : configuredSchedule.getOptHourlyFrequency();
        return hourlyFrequency;
    }

    public String getStartTime() {
        Object minuteStr;
        int startSecond;
        int startMinute;
        String dayOfWeek;
        if (this.isAutoReplicate()) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NotApplicable");
        }
        Schedule configuredSchedule = this.partnerShip.getOptSchedule();
        String frequency = null;
        String startHour = configuredSchedule.getOptStartHour();
        if (configuredSchedule.getOptTimeFrame() != null) {
            String string = startHour = configuredSchedule.getOptTimeFrame().getOptStartHour() != null ? configuredSchedule.getOptTimeFrame().getOptStartHour().toString() : configuredSchedule.getOptTimeFrame().getDefStartHour().toString();
        }
        frequency = (dayOfWeek = configuredSchedule.getOptStartDayOfWeek()) != null && dayOfWeek.trim().length() > 0 ? "Weekly" : (startHour != null && startHour.trim().length() > 0 && configuredSchedule.getOptHourlyFrequency() == null ? "Daily" : "Hourly");
        int n = startMinute = configuredSchedule.getOptStartMinute() == null ? 0 : configuredSchedule.getOptStartMinute();
        if (startMinute < 0 || startMinute > 59) {
            startMinute = 0;
        }
        int n2 = startSecond = configuredSchedule.getOptStartSecond() == null ? 0 : configuredSchedule.getOptStartSecond();
        if (startSecond < 0 || startSecond > 59) {
            startSecond = 0;
        }
        int startHourAsInt = 0;
        try {
            startHourAsInt = startHour == null ? (startMinute > Calendar.getInstance(TimeZone.getTimeZone("GMT")).get(12) ? Calendar.getInstance(TimeZone.getTimeZone("GMT")).get(11) : (Calendar.getInstance(TimeZone.getTimeZone("GMT")).get(11) + 1) % 24) : Integer.parseInt(startHour);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (startHourAsInt < 0 || startHourAsInt > 23) {
            startHourAsInt = 0;
        }
        int dayOfWeekAsInt = 0;
        try {
            dayOfWeekAsInt = Integer.parseInt(dayOfWeek);
        }
        catch (Exception ex) {
            dayOfWeekAsInt = 0;
        }
        if (dayOfWeekAsInt < 0 || dayOfWeekAsInt > 6) {
            dayOfWeekAsInt = 0;
        }
        int minuteAsInt = startMinute;
        Calendar from = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Calendar local = Utility.changeTimeZoneFromGMTForScheduleHour((int)dayOfWeekAsInt, (int)startHourAsInt, (int)minuteAsInt, (Calendar)from, (Calendar)Utility.getCalendarInstance());
        dayOfWeekAsInt = local.get(7) - 1;
        startHourAsInt = local.get(11);
        minuteAsInt = local.get(12);
        String dayOfWeekString = Utility.getDayOfWeek()[dayOfWeekAsInt];
        Object hourStr = startHourAsInt > 9 ? String.valueOf(startHourAsInt) : "0" + startHourAsInt;
        Object object = minuteStr = minuteAsInt > 9 ? String.valueOf(minuteAsInt) : "0" + minuteAsInt;
        if ("Weekly".equals(frequency)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.ptnWeekly");
            Object[] obj = new Object[]{dayOfWeekString, hourStr, minuteStr};
            String fm = MessageFormat.format(msg, obj);
            return fm;
        }
        if ("Daily".equals(frequency)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.ptnDaily");
            Object[] obj = new Object[]{hourStr, minuteStr};
            String fm = MessageFormat.format(msg, obj);
            return fm;
        }
        if ("Hourly".equals(frequency)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.ptnHourly");
            Calendar nextTime = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            Calendar startTime = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            HashMap map = ReplicationScheduleUtility.getSiteMap();
            if (!map.containsKey(this.getId())) {
                ReplicationScheduleUtility.ReplicationPartnerScheduleState rpuic = new ReplicationScheduleUtility.ReplicationPartnerScheduleState();
                rpuic.setReplicationScheduleChanged(false);
                rpuic.setPreviousReplicationTime(0L);
                map.put(this.getId(), rpuic);
            }
            if (((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).getPreviousReplicationTime() == 0L) {
                ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).setPreviousReplicationTime(this.getLastReplicationTimeInMilli().longValue());
            }
            if (((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).isReplicationScheduleChanged() && this.getLastReplicationTimeInMilli().longValue() != ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).getPreviousReplicationTime()) {
                ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).setReplicationScheduleChanged(false);
            }
            if (this.getLastReplicationTimeInMilli() == null) {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NotAvailable");
            }
            if (!((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).isReplicationScheduleChanged() && this.getLastReplicationTimeInMilli() != -1L) {
                Long delay = this.getLastReplicationTimeInMilli();
                nextTime.setTimeInMillis(delay);
                if (!ReplicationScheduleUtility.isCurTimeWithInTimeFrames((Calendar)Calendar.getInstance(TimeZone.getTimeZone("GMT")), (TimeFrame)this.partnerShip.getOptSchedule().getOptTimeFrame(), (boolean)true)) {
                    nextTime = ReplicationScheduleUtility.getStartTimeFromTimeFrame((TimeFrame)this.partnerShip.getOptSchedule().getOptTimeFrame(), (boolean)true);
                }
                while (nextTime.before(Calendar.getInstance(TimeZone.getTimeZone("GMT")))) {
                    long addGranularityJump = (long)this.getHourlyFrequency().intValue() * 3600000L;
                    nextTime.setTimeInMillis(nextTime.getTimeInMillis() + addGranularityJump);
                }
                if (!ReplicationScheduleUtility.isCurTimeWithInTimeFrames((Calendar)nextTime, (TimeFrame)this.partnerShip.getOptSchedule().getOptTimeFrame(), (boolean)true)) {
                    nextTime = ReplicationScheduleUtility.getStartTimeFromTimeFrame((TimeFrame)this.partnerShip.getOptSchedule().getOptTimeFrame(), (boolean)true);
                }
            } else {
                startTime.set(11, Integer.parseInt(startHour));
                startTime.set(12, startMinute);
                while (startTime.before(nextTime)) {
                    startTime.add(11, 1);
                }
                if (!ReplicationScheduleUtility.isCurTimeWithInTimeFrames((Calendar)startTime, (TimeFrame)this.partnerShip.getOptSchedule().getOptTimeFrame(), (boolean)true)) {
                    startTime = ReplicationScheduleUtility.getStartTimeFromTimeFrame((TimeFrame)this.partnerShip.getOptSchedule().getOptTimeFrame(), (boolean)true);
                }
                nextTime = startTime;
            }
            local = Utility.changeTimeZoneFromGMTForScheduleHour((int)nextTime.get(7), (int)nextTime.get(11), (int)nextTime.get(12), (Calendar)from, (Calendar)Utility.getCalendarInstance());
            startHourAsInt = local.get(11);
            minuteAsInt = local.get(12);
            hourStr = startHourAsInt > 9 ? String.valueOf(startHourAsInt) : "0" + startHourAsInt;
            minuteStr = minuteAsInt > 9 ? String.valueOf(minuteAsInt) : "0" + minuteAsInt;
            Object[] obj = new Object[]{hourStr, minuteStr};
            String fm = MessageFormat.format(msg, obj);
            if (this.getLastReplicationTimeInMilli().longValue() != ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).getPreviousReplicationTime()) {
                ((ReplicationScheduleUtility.ReplicationPartnerScheduleState)map.get(this.getId())).setPreviousReplicationTime(this.getLastReplicationTimeInMilli().longValue());
            }
            return fm;
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NotAvailable");
    }

    public ReplicationPartnership getReplicationPartnership() {
        return this.partnerShip;
    }

    public void setReplicationPartnership(ReplicationPartnership partnership) {
        this.partnerShip = partnership;
    }

    public SemSite getSemSite() {
        ReplicationPartnerArray partnerArray = (ReplicationPartnerArray)this.partnerShip.getParent();
        Replication replication = (Replication)partnerArray.getParent();
        SemSite site = (SemSite)replication.getParent();
        return site;
    }

    private Long getLastReplicationTimeInMilli() {
        PartnerState state = this.partnerShip.getPartnerState();
        if (state != null) {
            long lastReplicationTime = -1L;
            Long timeSuccessful = state.getOptLastSuccessfulReplicationTime();
            Long timeFailed = state.getOptLastFailedReplicationTime();
            if (timeFailed != null) {
                lastReplicationTime = timeSuccessful == null ? state.getOptLastFailedReplicationTime().longValue() : (timeSuccessful > timeFailed ? timeSuccessful : timeFailed).longValue();
            } else if (timeSuccessful != null) {
                lastReplicationTime = timeSuccessful;
            }
            return lastReplicationTime;
        }
        return null;
    }

    private String getLastReplicationTime(boolean successful) {
        Long time;
        PartnerState state = this.partnerShip.getPartnerState();
        Long l = time = successful ? state.getOptLastSuccessfulReplicationTime() : state.getOptLastFailedReplicationTime();
        if (time == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NeverReplicated");
        }
        return Utility.getFullDateLongTimeString((long)time, null);
    }

    private String getLastReplicationServer(boolean successful) {
        Long time;
        PartnerState state = this.partnerShip.getPartnerState();
        Long l = time = successful ? state.getOptLastSuccessfulReplicationTime() : state.getOptLastFailedReplicationTime();
        if (time == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NeverReplicated");
        }
        return successful ? state.getOptLastSuccessfulReplicationWorkServer() : state.getOptLastFailedReplicationWorkServer();
    }

    public String getLastSuccessfulReplicationTime() {
        return this.getLastReplicationTime(true);
    }

    public String getLastSuccessfulReplicationServer() {
        return this.getLastReplicationServer(true);
    }

    public String getLastFailedReplicationTime() {
        return this.getLastReplicationTime(false);
    }

    public String getLastFailedReplicationServer() {
        return this.getLastReplicationServer(false);
    }

    private boolean isLastReplicationSuccessful() {
        PartnerState state = this.partnerShip.getPartnerState();
        Long timeSuccessful = state.getOptLastSuccessfulReplicationTime();
        Long timeFailed = state.getOptLastFailedReplicationTime();
        boolean successful = true;
        if (timeFailed != null) {
            successful = timeSuccessful == null ? false : timeSuccessful > timeFailed;
        }
        System.out.println("Partner>> isLastReplicationSuccessful: successful=" + successful + ", last successful time=" + this.getLastSuccessfulReplicationTime() + "; last failed time=" + this.getLastFailedReplicationTime());
        return successful;
    }

    public String getLastReplicationTime() {
        return this.getLastReplicationTime(this.isLastReplicationSuccessful());
    }

    public String getLastReplicationServer() {
        return this.getLastReplicationServer(this.isLastReplicationSuccessful());
    }

    public String getStatus() {
        ReplicationState replicationState = null;
        try {
            replicationState = ServerHandler.getLocalReplicationState(this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (replicationState == null) {
            return this.getStatusFromPartnerState();
        }
        String clientIp = replicationState.getReplicatorClientSourceSiteServerIp();
        if (clientIp == null || clientIp.length() < 1) {
            return this.getStatusFromPartnerState();
        }
        SiteContactArray siteContactArray = this.partnerShip.getSiteContactArray();
        if (siteContactArray == null || siteContactArray.getHostAddressCount() < 1) {
            return this.getStatusFromPartnerState();
        }
        return this.getStatusFromReplicationState(replicationState);
    }

    private String getStatusFromPartnerState() {
        long timeFailure;
        System.out.println("retrieving status from PartnerState...");
        PartnerState state = this.partnerShip.getPartnerState();
        if (state == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NeverReplicated");
        }
        long timeSuccess = state.getOptLastSuccessfulReplicationTime() == null ? 0L : state.getOptLastSuccessfulReplicationTime();
        long l = timeFailure = state.getOptLastFailedReplicationTime() == null ? 0L : state.getOptLastFailedReplicationTime();
        if (timeSuccess == 0L && timeFailure == 0L) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.NeverReplicated");
        }
        if (timeSuccess > timeFailure) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusSucceeded");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailed");
    }

    private String getStatusFromReplicationState(ReplicationState replicationState) {
        StringBuffer buf = new StringBuffer();
        Integer status = replicationState.getOptReplicatorClientStatus();
        if (status != null && !status.equals(ReplicationState.IDLE)) {
            if (status.equals(ReplicationState.REP_CONNECTING)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusConnecting"));
            } else if (status.equals(ReplicationState.REP_AUTHENTICATING)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusAuthenticating"));
            } else if (status.equals(ReplicationState.REP_SUBMITING)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusSubmitting"));
            } else if (status.equals(ReplicationState.REP_PROCESSING)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusProcessing"));
            } else if (status.equals(ReplicationState.REP_DOWNLOADING)) {
                if (replicationState.getOptReplicatorClientProgress() != null) {
                    buf.append(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusDownloadingPercent"), replicationState.getOptReplicatorClientProgress()));
                } else {
                    buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusDownloading"));
                }
            } else if (status.equals(ReplicationState.CANCELED)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusCanceled"));
            } else {
                buf.append(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusUnknownWithCode"), status));
            }
            System.out.println("retrieving status from ReplicationState... status=" + status + ", str=" + buf.toString());
        } else {
            status = replicationState.getOptLastReplicationResult();
            if (status == null || status.equals(ReplicationState.OK)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusSucceeded"));
            } else if (status.equals(ReplicationState.FAILED_TO_CONNECT)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailedConnect"));
            } else if (status.equals(ReplicationState.FAILED_TO_AUTHENTIC)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailedAuthenticate"));
            } else if (status.equals(ReplicationState.FAILED_TO_DOWNLOAD)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailedDownload"));
            } else if (status.equals(ReplicationState.FAILED_TO_PROCESS)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailedProcess"));
            } else if (status.equals(ReplicationState.FAILED_TO_SUBMIT)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailedSubmit"));
            } else if (status.equals(ReplicationState.DB_VERSION_NO_MATCH)) {
                buf.append(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusFailedDBVersionMispatch"));
            } else {
                buf.append(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "Partner.StatusUnknownWithResultCode"), status));
            }
            System.out.println("retrieving status from ReplicationState... result=" + status + ", str=" + buf.toString());
        }
        return buf.toString();
    }

    public Schedule cloneSchedule() {
        Schedule schedule = this.partnerShip.getOptSchedule();
        if (schedule == null) {
            return null;
        }
        Schedule copySchedule = null;
        try {
            copySchedule = (Schedule)Schedule.readXML((byte[])schedule.getBytes());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return copySchedule;
    }

    public String getPassword() {
        return this.partnerShip.getPassword();
    }

    protected boolean isSameSchedule(Schedule src, Schedule tgt) {
        if (src == null || tgt == null) {
            if (src != null || tgt != null) {
                return false;
            }
        } else {
            TimeFrame tgtTimeFrame;
            if (!Utility.isSameObject((Object)src.getOptEnable(), (Object)tgt.getOptEnable())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptStartYear(), (Object)tgt.getOptStartYear())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptStartMonth(), (Object)tgt.getOptStartMonth())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptStartDayOfMonth(), (Object)tgt.getOptStartDayOfMonth())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptStartDayOfWeek(), (Object)tgt.getOptStartDayOfWeek())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptStartHour(), (Object)tgt.getOptStartHour())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptStartMinute(), (Object)tgt.getOptStartMinute())) {
                return false;
            }
            if (!Utility.isSameObject((Object)src.getOptHourlyFrequency(), (Object)tgt.getOptHourlyFrequency())) {
                return false;
            }
            TimeFrame srcTimeFrame = src.getOptTimeFrame();
            if (srcTimeFrame == (tgtTimeFrame = tgt.getOptTimeFrame())) {
                return true;
            }
            if (srcTimeFrame != null && tgtTimeFrame != null) {
                if (!Utility.isSameObject((Object)srcTimeFrame.getOptStartHour(), (Object)tgtTimeFrame.getOptStartHour())) {
                    return false;
                }
                if (!Utility.isSameObject((Object)srcTimeFrame.getOptStartMin(), (Object)tgtTimeFrame.getOptStartMin())) {
                    return false;
                }
                if (!Utility.isSameObject((Object)srcTimeFrame.getOptEndHour(), (Object)tgtTimeFrame.getOptEndHour())) {
                    return false;
                }
                if (!Utility.isSameObject((Object)srcTimeFrame.getOptEndMin(), (Object)tgtTimeFrame.getOptEndMin())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void copySchedule(Partner source, boolean replicateLogs) {
        if (!this.isSameSchedule(source.getReplicationPartnership().getOptSchedule(), this.partnerShip.getOptSchedule())) {
            Schedule copySchedule = source.cloneSchedule();
            this.partnerShip.setOptSchedule(copySchedule);
        }
        if (this.isReplicationLogsOrPackagesChanged(source, replicateLogs)) {
            this.setReplicateLogs(replicateLogs);
            this.setReplicateClientPackages(source.isReplicateClientPackages());
            this.setReplicateLuContents(source.isReplicateLuContents());
        }
        if (!Utility.isSameObject((Object)source.getPassword(), (Object)this.partnerShip.getPassword())) {
            this.partnerShip.setPassword(source.getPassword());
        }
    }

    private boolean isReplicationLogsOrPackagesChanged(Partner source, boolean replicateLogs) {
        if (replicateLogs != this.isReplicateLogs()) {
            return true;
        }
        if (source.isReplicateClientPackages() != this.isReplicateClientPackages()) {
            return true;
        }
        return source.isReplicateLuContents() != this.isReplicateLuContents();
    }
}

