/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.configobject.schema.BufferOverrunAppComCode;
import com.sygate.scm.common.configobject.schema.BufferOverrunAppComPack;
import com.sygate.scm.common.configobject.schema.BufferOverrunAppComPackContent;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.OverflowObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OverrunComPackObject
extends AbstractUIObject
implements TableRow {
    private BufferOverrunAppComPack _comPack;
    private boolean isApplied = false;
    private OverflowObject overflowObj;

    public OverrunComPackObject(BufferOverrunAppComPack comPack) {
        this._comPack = comPack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFile(File file) throws ConsoleException {
        try {
            Document doc = XMLHelper.newDocument();
            Element root = doc.createElement("ApplicationCompatibility");
            String acpName = this._comPack.getName();
            root.setAttribute("ACPName", acpName);
            String version = this._comPack.getVersion();
            root.setAttribute("Version", version);
            Long lastModify = this._comPack.getLastModifiedTime();
            root.setAttribute("LastModifiedTime", Long.toHexString(lastModify));
            BufferOverrunAppComPackContent content = this._comPack.getBufferOverrunAppComPackContent();
            if (content != null) {
                Vector allCodes = content.getBufferOverrunAppComCode();
                for (BufferOverrunAppComCode code : allCodes) {
                    Element elemt = doc.createElement("CompatibilityCode");
                    elemt.setAttribute("Enable", "1");
                    String name = code.getName();
                    elemt.setAttribute("Name", name);
                    String revision = code.getVersion();
                    elemt.setAttribute("Revision", revision);
                    lastModify = code.getLastModifiedTime();
                    elemt.setAttribute("LastModifiedTime", Long.toHexString(lastModify));
                    String data = code.getContent();
                    Text cdata = doc.createTextNode(data);
                    elemt.appendChild(cdata);
                    root.appendChild(elemt);
                }
            }
            doc.appendChild(root);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            try {
                XMLHelper.serialize((Document)doc, (OutputStream)out);
                ((OutputStream)out).flush();
            }
            finally {
                IOUtilities.closeOutputStream((OutputStream)out);
            }
        }
        catch (FileNotFoundException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OverrunComPackObject importFile(File file) throws ConsoleException {
        OverrunComPackObject overrunComPackObject;
        FileInputStream in = null;
        BufferedInputStream bis = null;
        try {
            in = new FileInputStream(file);
            bis = new BufferedInputStream(in);
            Document doc = XMLHelper.parse((InputStream)bis);
            Element elemt = doc.getDocumentElement();
            String tag = elemt.getNodeName();
            if (!tag.equals("ApplicationCompatibility")) {
                throw new ValidationException("Element Name should be \"ApplicationCompatibility\" instead of \"" + tag + "\"");
            }
            String acpName = elemt.getAttribute("ACPName");
            String version = elemt.getAttribute("Version");
            String lastModify = elemt.getAttribute("LastModifiedTime");
            BufferOverrunAppComPack newPack = new BufferOverrunAppComPack();
            newPack.setId(new GUIDGenerator().getGUIDString());
            newPack.setName(acpName);
            newPack.setVersion(version);
            long time = Long.parseLong(lastModify, 16);
            newPack.setLastModifiedTime(Long.valueOf(time));
            newPack.setCreationTime(Long.valueOf(new Date().getTime()));
            BufferOverrunAppComPackContent content = new BufferOverrunAppComPackContent();
            newPack.setBufferOverrunAppComPackContent(content);
            NodeList list = elemt.getElementsByTagName("CompatibilityCode");
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Node item = list.item(i);
                if (item.getNodeType() != 1) continue;
                Element subElemt = (Element)item;
                String enable = subElemt.getAttribute("Enable");
                String name = subElemt.getAttribute("Name");
                String revision = subElemt.getAttribute("Revision");
                String lastModifyTime = subElemt.getAttribute("LastModifiedTime");
                BufferOverrunAppComCode code = new BufferOverrunAppComCode();
                if (enable.equals("0")) {
                    code.setOptEnable(Boolean.FALSE);
                } else {
                    code.setOptEnable(Boolean.TRUE);
                }
                code.setName(name);
                code.setVersion(revision);
                time = Long.parseLong(lastModifyTime, 16);
                code.setLastModifiedTime(Long.valueOf(time));
                Node childTextNode = XMLHelper.getTextNode((Element)subElemt);
                if (childTextNode == null) {
                    throw new ValidationException("CompatibilityCode: content is require!");
                }
                String data = childTextNode.getNodeValue();
                code.setContent(data);
                content.addBufferOverrunAppComCode(code);
            }
            overrunComPackObject = new OverrunComPackObject(newPack);
        }
        catch (FileNotFoundException e) {
            try {
                LoggerUtilities.logException((Throwable)e);
                throw new ConsoleException(-535756800, 134);
                catch (IOException e2) {
                    LoggerUtilities.logException((Throwable)e2);
                    throw new ConsoleException(-535691264, 135);
                }
                catch (SAXException e3) {
                    LoggerUtilities.logException((Throwable)e3);
                    throw new ConsoleException(-535625728, 136);
                }
                catch (ValidationException e4) {
                    LoggerUtilities.logException((Throwable)e4);
                    throw new ConsoleException(-535560192, 137);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.closeInputStream(in);
                IOUtilities.closeInputStream(bis);
                throw throwable;
            }
        }
        IOUtilities.closeInputStream((InputStream)in);
        IOUtilities.closeInputStream((InputStream)bis);
        return overrunComPackObject;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.isApplied;
            }
            case 1: {
                return this._comPack.getName();
            }
            case 2: {
                return this._comPack.getVersion();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (index == 0) {
            Boolean applied = (Boolean)value;
            this.isApplied = applied;
            if (this.isApplied) {
                this.overflowObj.addComPack(this);
            } else {
                this.overflowObj.deleteComPack(this);
            }
        }
    }

    public String getId() {
        return this._comPack.getId();
    }

    public void setAppliedStatus(boolean b, OverflowObject overflowObj) {
        this.overflowObj = overflowObj;
        this.isApplied = b;
    }

    public String getName() {
        return this._comPack.getName();
    }

    public BufferOverrunAppComPack getSchemaObj() {
        return this._comPack;
    }
}

