/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AppliedBufferOverrunAppComPackArray;
import com.sygate.scm.common.configobject.schema.BufferOverrunProtection;
import com.sygate.scm.common.configobject.schema.ExcludedAppArray;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAction;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.OverrunComPackObject;
import com.sygate.scm.console.util.ConsoleException;
import java.util.List;
import java.util.Vector;

public class OverflowObject
extends AbstractUIObject {
    private BufferOverrunProtection _overrunProtection;

    public OverflowObject(BufferOverrunProtection overrun) {
        this._overrunProtection = overrun;
    }

    public void addComPack(OverrunComPackObject newObj) {
        ObjReference ref = new ObjReference();
        ref.setName("AppliedBufferOverrunAppComPack");
        ref.setTargetType("BufferOverrunAppComPack");
        ref.setTargetId(newObj.getId());
        AppliedBufferOverrunAppComPackArray array = this.getOverrunProtection().getOptAppliedBufferOverrunAppComPackArray();
        if (array == null) {
            array = new AppliedBufferOverrunAppComPackArray();
            this.getOverrunProtection().setOptAppliedBufferOverrunAppComPackArray(array);
        }
        array.addObjReference(ref);
    }

    public void deleteComPack(OverrunComPackObject comObj) {
        String id = comObj.getId();
        AppliedBufferOverrunAppComPackArray array = this.getOverrunProtection().getOptAppliedBufferOverrunAppComPackArray();
        if (array != null) {
            Vector list = array.getObjReference();
            for (ObjReference ref : list) {
                if (!ref.getTargetId().equals(id)) continue;
                array.removeObjReference(ref);
            }
        }
    }

    public boolean getEnabled() {
        if (this._overrunProtection != null) {
            Boolean enable = this._overrunProtection.getOptEnable();
            if (enable == null) {
                enable = this._overrunProtection.getDefEnable();
            }
            return enable;
        }
        return false;
    }

    public BufferOverrunProtection getBufferOverrunProtection() {
        return this._overrunProtection;
    }

    public void setBufferOverrunProtection(OverflowObject newObj) {
        this._overrunProtection = newObj.getBufferOverrunProtection();
    }

    public Integer getProtectionType() {
        if (this._overrunProtection != null) {
            Integer protect = this._overrunProtection.getOptProcessToBeProtected();
            if (protect == null) {
                protect = this._overrunProtection.getDefProcessToBeProtected();
            }
            return protect;
        }
        return BufferOverrunProtection.ONLY_SERVICE;
    }

    private BufferOverrunProtection getOverrunProtection() {
        if (this._overrunProtection == null) {
            this._overrunProtection = new BufferOverrunProtection();
            OpAction action = new OpAction();
            action.setAction(OpAction.ALLOW);
            action.setOptLogEvent(Boolean.TRUE);
            action.setSeverity(Long.valueOf(0L));
            this._overrunProtection.setOpAction(action);
        }
        return this._overrunProtection;
    }

    public List<ApplicationObject> getApplications() {
        ExcludedAppArray array;
        Vector<ApplicationObject> all = new Vector<ApplicationObject>();
        if (this._overrunProtection != null && (array = this._overrunProtection.getOptExcludedAppArray()) != null) {
            Vector allExe = array.getExecutable();
            for (Executable exe1 : allExe) {
                ApplicationObject appObj = new ApplicationObject(exe1);
                all.add(appObj);
            }
        }
        return all;
    }

    public Integer getActionType() {
        OpAction action;
        if (this._overrunProtection != null && (action = this._overrunProtection.getOpAction()) != null) {
            return action.getAction();
        }
        return OpAction.ALLOW;
    }

    public OverflowObject getClone() throws ConsoleException {
        BufferOverrunProtection newExe = null;
        if (this._overrunProtection != null) {
            newExe = (BufferOverrunProtection)PolicyHandler.getCopyOfObj((ConfigObject)this._overrunProtection);
        }
        return new OverflowObject(newExe);
    }

    public boolean showBufferOverflow() {
        LicenseObject myLicenseObj = LicenseObject.getInstance();
        return myLicenseObj.isOSPretectionPolicy() || this.getEnabled();
    }
}

