/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ObjInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.util.Utility;

public class ObjInfoObject
implements TreeItem,
TableRow {
    private ObjInfo objInfo;
    private int itemType;
    private boolean isDefaultServerList;
    private String targetType;
    private int appliedCount = -1;
    private boolean isLocal;
    private String targetName;

    public ObjInfoObject(int itemType, ObjInfo objInfo) {
        this.itemType = itemType;
        this.objInfo = objInfo;
    }

    public ObjInfoObject(int itemType, ObjInfo objInfo, boolean isDefaultServerList) {
        this.itemType = itemType;
        this.objInfo = objInfo;
        this.isDefaultServerList = isDefaultServerList;
    }

    public ObjInfoObject(int itemType, ObjInfo objInfo, String targetType) {
        this.itemType = itemType;
        this.objInfo = objInfo;
        this.targetType = targetType;
    }

    public ObjInfoObject(boolean isLocal, ObjInfo objInfo, String targetName) {
        this.isLocal = isLocal;
        this.objInfo = objInfo;
        this.targetName = targetName;
    }

    @Override
    public String getId() {
        return this.objInfo.getId();
    }

    @Override
    public String getName() {
        String name = this.objInfo.getOptName();
        return name == null ? "" : name;
    }

    public void setName(String name) {
        this.objInfo.setOptName(name);
    }

    public String getDescription() {
        String desc = this.objInfo.getOptDescription();
        return desc == null ? "" : desc;
    }

    public void setDescription(String description) {
        this.objInfo.setOptDescription(description);
    }

    public int getAppliedCount() {
        return this.appliedCount;
    }

    public void setAppliedCount(int appliedCount) {
        this.appliedCount = appliedCount;
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    public boolean isEnabled() {
        return !Utility.getBooleanValue((Boolean)this.objInfo.getOptDisable(), (Boolean)this.objInfo.getDefDisable());
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public boolean isDefaultServerList() {
        return this.isDefaultServerList;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
        }
        String text = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.computingMsg");
        return this.appliedCount == -1 ? text : Integer.valueOf(this.appliedCount);
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return Integer.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }
}

