/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ClientInformation;
import com.sygate.scm.common.configobject.schema.HIStatus;
import com.sygate.scm.common.configobject.schema.NAPEnforcement;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ClientInformationObject;
import com.sygate.scm.console.logicobject.HIStatusObject;

public class NAPEnforcementObject
extends AbstractUIObject {
    private NAPEnforcement nap;

    public NAPEnforcementObject(NAPEnforcement nap) {
        this.nap = nap;
    }

    public static NAPEnforcementObject newInstance(SeEnforcerPolicy policy) {
        NAPEnforcement nap = policy.getOptNAPEnforcement();
        if (nap == null) {
            nap = new NAPEnforcement();
            ClientInformation ci = new ClientInformation();
            HIStatus hi = new HIStatus();
            nap.setOptClientInformation(ci);
            nap.setOptHIStatus(hi);
            policy.setOptNAPEnforcement(nap);
        }
        return new NAPEnforcementObject(nap);
    }

    public ClientInformationObject getClientInformationObject() {
        ClientInformation ci = this.nap.getOptClientInformation();
        if (ci == null) {
            return ClientInformationObject.newInstance(this.nap);
        }
        return new ClientInformationObject(ci);
    }

    public HIStatusObject getHIStatusObject() {
        HIStatus hi = this.nap.getOptHIStatus();
        if (hi == null) {
            return HIStatusObject.newInstance(this.nap);
        }
        return new HIStatusObject(hi);
    }

    public NAPEnforcement getNAPEnforcement() {
        return this.nap;
    }

    public void setClientInformation(ClientInformation ciInfo) {
        this.nap.setOptClientInformation(ciInfo);
    }

    public void setClientInformationObject(ClientInformationObject ciInfo) {
        this.nap.setOptClientInformation(ciInfo.getClientInformation());
    }

    public void setHIStatus(HIStatus hiInfo) {
        this.nap.setOptHIStatus(hiInfo);
    }

    public void setHIStatusObject(HIStatusObject hiObj) {
        this.nap.setOptHIStatus(hiObj.getHostIntegrityStatus());
    }

    public void updateClientInformation(ClientInformation ciInfo) {
        this.nap.setOptClientInformation(ciInfo);
    }

    public void updateClientInformationObject(ClientInformationObject ciInfo) {
        this.nap.setOptClientInformation(ciInfo.getClientInformation());
    }

    public void updateHIStatus(HIStatus hiInfo) {
        this.nap.setOptHIStatus(hiInfo);
    }

    public void updateHIStatusObject(HIStatusObject hiInfo) {
        this.nap.setOptHIStatus(hiInfo.getHostIntegrityStatus());
    }
}

