/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.SourceInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.Vector;

public class MemPolicyObject
extends PolicyIntObjectBase
implements TableRow {
    private static final MessageResourcesFile resourceAvOverview = new MessageResourcesFile("com.sygate.scm.console.ui.policy.av.overview.avoverview");
    private boolean isExclusiveEdit = false;

    public MemPolicyObject() {
    }

    public MemPolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public MemPolicyObject(TopLevelObject policy) {
        super(policy);
        Vector sources = this.getMemPolicy().getSourceInfo();
        for (SourceInfo sourceInfo : sources) {
            if (sourceInfo.getOptexclusiveEdit() == null || !sourceInfo.getOptexclusiveEdit().booleanValue()) continue;
            this.isExclusiveEdit = true;
        }
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof MemPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        MemPolicyObject newObj = new MemPolicyObject((TopLevelObject)((MemPolicy)policyObj));
        return newObj;
    }

    public MemPolicy getMemPolicy() {
        return (MemPolicy)this.policy;
    }

    @Override
    public String getTargetName() {
        return "MemPolicyApplied";
    }

    @Override
    public String getTargetType() {
        return "MemPolicy";
    }

    @Override
    public String getRefTargetName() {
        return ((MemPolicy)this.policy).getName();
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalMemPolicy";
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemPolicyObject.MEMPolicyDesc");
    }

    public void setDesc(String desc) {
        ((MemPolicy)this.policy).setOptDescription(desc);
    }

    @Override
    public Object getValueAt(int column) {
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int column) {
        return null;
    }

    @Override
    public int getItemType() {
        return 169;
    }

    public boolean isEnabled() {
        return Utility.getBooleanValue((Boolean)((MemPolicy)this.policy).getOptEnable(), (Boolean)((MemPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((MemPolicy)this.policy).getOptEnable(), (Boolean)((MemPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((MemPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String toString() {
        if (this.getEnabled()) {
            return this.getName();
        }
        Object[] args = new Object[]{this.getName(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemPolicyObject.DisabledMEM")};
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.mem.mem", "MemPolicyObject.MEMName"), args);
    }

    @Override
    public String getCreator() {
        return ((MemPolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((MemPolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public boolean isExclusiveEdit() {
        return this.isExclusiveEdit;
    }

    @Override
    public String handleSources() {
        StringBuilder sourcesB = new StringBuilder();
        Vector sources = this.getMemPolicy().getSourceInfo();
        for (SourceInfo source : sources) {
            if ("ATP".equalsIgnoreCase(source.getOptName())) {
                sourcesB.append(resourceAvOverview.getString("OverviewPane.label.policy.sourceATP"));
            } else if ("SAEP".equalsIgnoreCase(source.getOptName())) {
                sourcesB.append(resourceAvOverview.getString("OverviewPane.label.policy.sourceSAEP"));
            } else {
                sourcesB.append(source.getOptName());
            }
            sourcesB.append(", ");
        }
        String sourcesCsv = sources.size() > 0 ? sourcesB.substring(0, sourcesB.length() - 2) : "";
        return sourcesCsv;
    }
}

