/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.LuCategories;
import com.sygate.scm.common.configobject.schema.LuCategory;
import com.sygate.scm.common.configobject.schema.LuConfig;
import com.sygate.scm.common.configobject.schema.LuContentSizeSelections;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuDownloadSchedule;
import com.sygate.scm.common.configobject.schema.LuSupportLanguage;
import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatforms;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LuSupportLanguageObj;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class LuConfigObject
extends AbstractUIObject {
    private LuConfig luConfig;

    public LuConfigObject(SemSite site) {
        LuConfig config = site.getOptLuConfig();
        if (config == null) {
            config = new LuConfig();
            site.setOptLuConfig(config);
        }
        this.luConfig = config;
    }

    public LuConfig getSchemaObject() {
        return this.luConfig;
    }

    public Boolean getOptExtractFullPackage() {
        return this.luConfig.getOptExtractFullPackage();
    }

    public Integer getOptNumberOfRevisions() {
        return this.luConfig.getOptNumberOfRevisions();
    }

    public Integer getDefNumberOfRevisions() {
        return this.luConfig.getDefNumberOfRevisions();
    }

    public LuCategories getOptLuCategories() {
        return this.luConfig.getOptLuCategories();
    }

    public Vector<LuSupportLanguage> getLuSupportLanguage() {
        return this.luConfig.getLuSupportLanguage();
    }

    public LuDownloadSchedule getOptLuDownloadSchedule() {
        return this.luConfig.getOptLuDownloadSchedule();
    }

    public LuContentSourceInfo getOptLuContentSourceInfo() {
        return this.luConfig.getOptLuContentSourceInfo();
    }

    public LuSupportedClientPlatforms getOptLuSupportedClientPlatforms() {
        return this.luConfig.getOptLuSupportedClientPlatforms();
    }

    public LuContentSizeSelections getOptLuContentSizeSelections() {
        return this.luConfig.getOptLuContentSizeSelections();
    }

    public void setOptLuDownloadSchedule(LuDownloadSchedule schedule) {
        String oldScheduleStr;
        String newScheduleStr = this.getLuDownloadScheduleString(schedule);
        if (!StringUtilities.isEqual((String)newScheduleStr, (String)(oldScheduleStr = this.getLuDownloadScheduleString(this.luConfig.getOptLuDownloadSchedule())))) {
            this.luConfig.setOptLuDownloadSchedule(schedule);
        }
    }

    public void setOptExtractFullPackage(boolean extractFullPackage) {
        boolean isExtractFullPackage = Utility.getBooleanValue((Boolean)this.luConfig.getOptExtractFullPackage(), (Boolean)this.luConfig.getDefExtractFullPackage());
        if (isExtractFullPackage != extractFullPackage) {
            this.luConfig.setOptExtractFullPackage(Boolean.valueOf(extractFullPackage));
        }
    }

    public void setOptNumberOfRevisions(Integer revision) {
        Integer revisions = this.luConfig.getOptNumberOfRevisions();
        if (revisions == null) {
            revisions = this.luConfig.getDefNumberOfRevisions();
        }
        if (revisions.intValue() != revision.intValue()) {
            this.luConfig.setOptNumberOfRevisions(revision);
        }
    }

    public void setOptLuCategories(LuCategories categories) {
        this.luConfig.setOptLuCategories(categories);
    }

    public void setOptLuSupportedClientPlatforms(LuSupportedClientPlatforms platforms) {
        this.luConfig.setOptLuSupportedClientPlatforms(platforms);
    }

    public void setOptLuContentSizeSelections(LuContentSizeSelections contentSizeSelections) {
        this.luConfig.setOptLuContentSizeSelections(contentSizeSelections);
    }

    public void saveLanguages(DefaultListModel<LuSupportLanguageObj> model) {
        LuSupportLanguage language;
        int i;
        Vector oldLanguages = this.luConfig.getLuSupportLanguage();
        List<String> ids = this.getIlist(oldLanguages);
        for (i = 0; i < model.size(); ++i) {
            language = model.elementAt(i).getLanguage();
            if (ids.contains(language.getI())) {
                LuSupportLanguage oldLanguage = this.getLuSupportLanguage(language.getI(), oldLanguages);
                if (!oldLanguage.getContent().equals(language.getContent())) {
                    oldLanguage.setContent(language.getContent());
                }
                ids.remove(language.getI());
                continue;
            }
            this.luConfig.addLuSupportLanguage(language);
        }
        i = ids.size();
        while (--i >= 0) {
            language = this.getLuSupportLanguage(ids.get(i), oldLanguages);
            if (language == null) continue;
            this.luConfig.removeLuSupportLanguage(language);
        }
    }

    public void saveContentTypes(List<LuCategory> luTypes, List<LuCategory> unLicensedTypes) {
        LuCategories luCategories = this.luConfig.getOptLuCategories();
        if (luCategories == null) {
            luCategories = new LuCategories();
            this.luConfig.setOptLuCategories(luCategories);
        }
        Vector oldTypes = luCategories.getLuCategory();
        List<String> nameList = this.getCategoryNameList(oldTypes);
        this.saveContentType(nameList, luTypes);
        this.saveContentType(nameList, unLicensedTypes);
        int i = nameList.size();
        while (--i >= 0) {
            LuCategory category = this.getLuCategory(nameList.get(i), oldTypes);
            if (category == null) continue;
            this.luConfig.getOptLuCategories().removeLuCategory(category);
        }
    }

    private void saveContentType(List<String> nameList, List<LuCategory> newTypes) {
        if (newTypes != null) {
            for (int i = 0; i < newTypes.size(); ++i) {
                LuCategory category = newTypes.get(i);
                if (!nameList.contains(category.getCategoryName())) {
                    this.luConfig.getOptLuCategories().addLuCategory(category);
                    continue;
                }
                nameList.remove(category.getCategoryName());
            }
        }
    }

    private List<String> getIlist(Vector<LuSupportLanguage> configObjs) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < configObjs.size(); ++i) {
            ids.add(configObjs.get(i).getI());
        }
        return ids;
    }

    private LuSupportLanguage getLuSupportLanguage(String _i, Vector<LuSupportLanguage> luSupportLanguages) {
        for (LuSupportLanguage luSupportLanguage : luSupportLanguages) {
            if (!_i.equals(luSupportLanguage.getI())) continue;
            return luSupportLanguage;
        }
        return null;
    }

    private LuCategory getLuCategory(String name, Vector<LuCategory> categories) {
        for (LuCategory category : categories) {
            if (!name.equals(category.getCategoryName())) continue;
            return category;
        }
        return null;
    }

    private List<String> getCategoryNameList(Vector<LuCategory> luCategories) {
        ArrayList<String> ids = new ArrayList<String>();
        for (LuCategory luCategory : luCategories) {
            ids.add(luCategory.getCategoryName());
        }
        return ids;
    }

    private String getLuDownloadScheduleString(LuDownloadSchedule schedule) {
        if (schedule == null) {
            return null;
        }
        return String.valueOf(Utility.getBooleanValue((Boolean)schedule.getOptEnabled(), (Boolean)schedule.getDefEnabled())) + schedule.getOptFrequency() + schedule.getOptFrequencyInterval() + schedule.getOptSpecifyTimeRange() + schedule.getOptStartTime() + schedule.getOptEndTime() + schedule.getOptDayOfWeek() + schedule.getOptAllowRetry() + schedule.getOptRetryWindow() + schedule.getOptRetryInterval() + schedule.getOptIsChangedByConsole() + schedule.getOptIdleDetection();
    }
}

