/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.AdditionalAllowedFile;
import com.sygate.scm.common.configobject.schema.AppliedImage;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpFileNameMatchEntity;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.util.ConsoleLogger;
import javax.swing.JToggleButton;

public class LockdownFileListObject
extends AbstractUIObject
implements TableRow {
    public static final int INDEX_FINGERPRINT_NAME = 0;
    public static final int INDEX_FINGERPRINT_TEST = 1;
    public static final int INDEX_FILE_NAME = 0;
    public static final int INDEX_FILE_TEST = 1;
    protected ComputerImage image = null;
    protected OpFileNameMatchEntity entity = null;
    protected String name = "";
    protected boolean isTest = false;

    public LockdownFileListObject(ComputerImage image, boolean test) {
        this.image = image;
        this.name = image.getName();
        this.isTest = test;
    }

    public LockdownFileListObject(OpFileNameMatchEntity entity, boolean test) {
        this.entity = entity;
        this.name = entity.getKeyString();
        this.isTest = test;
        this.image = null;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public ComputerImage getImage() {
        return this.image;
    }

    public String getId() {
        return this.image != null ? this.image.getId() : "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LockdownFileListObject)) {
            return false;
        }
        LockdownFileListObject o = (LockdownFileListObject)obj;
        if (this.isWhiteList()) {
            if (!o.isWhiteList()) {
                return false;
            }
            return this.getId().equals(o.getId());
        }
        if (o.isWhiteList()) {
            return false;
        }
        return this.getName().equals(o.getName());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isWhiteList() {
        return this.image != null;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public AbstractSchema generateSchemaObject() {
        AppliedImage obj = null;
        obj = this.generateAppliedImage();
        if (obj == null) {
            obj = this.generateAdditionalAllowedFile();
        }
        return obj;
    }

    public AppliedImage generateAppliedImage() {
        if (this.image == null) {
            return null;
        }
        ObjReference ref = new ObjReference();
        ref.setName("ImportedComputerImage");
        ref.setTargetType("ComputerImage");
        ref.setTargetId(this.image.getId());
        AppliedImage a = new AppliedImage();
        a.setObjReference(ref);
        a.setOptMode(this.isTest() ? AppliedImage.TEST_FOR_REMOVE : AppliedImage.NORMAL);
        return a;
    }

    public AdditionalAllowedFile generateAdditionalAllowedFile() {
        if (this.image != null) {
            return null;
        }
        AdditionalAllowedFile file = new AdditionalAllowedFile();
        file.setOpFileNameMatchEntity(this.entity);
        file.setOptMode(this.isTest() ? AdditionalAllowedFile.TEST_FOR_REMOVE : AdditionalAllowedFile.NORMAL);
        return file;
    }

    private int getIndexName() {
        return this.isWhiteList() ? 0 : 0;
    }

    private int getIndexTest() {
        return this.isWhiteList() ? 1 : 1;
    }

    @Override
    public Object getValueAt(int index) {
        Object result = null;
        if (index == this.getIndexName()) {
            result = this.name;
        } else if (index == this.getIndexTest()) {
            result = this.isTest;
        }
        return result;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        if (index == this.getIndexName()) {
            return String.class;
        }
        if (index == this.getIndexTest()) {
            return Boolean.class;
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        if (index == this.getIndexName()) {
            this.name = value.toString();
        } else if (index == this.getIndexTest()) {
            this.isTest = this.getTestValue(value, index);
        }
    }

    private boolean getTestValue(Object value, int index) {
        boolean result = false;
        if (value instanceof Boolean) {
            result = (Boolean)value;
        } else if (value instanceof String) {
            result = Boolean.valueOf(value.toString());
        } else if (value instanceof JToggleButton) {
            result = ((JToggleButton)value).isSelected();
        } else {
            ConsoleLogger.log("LockdownFileObject>> getTestValue: Error-> invalid data type - index=" + index + ", value class=" + value.getClass().getName());
        }
        return result;
    }
}

