/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.TableRow;
import java.io.File;
import java.sql.Date;
import java.util.List;

public class LockdownExceptionObject
extends AbstractUIObject
implements TableRow {
    public static final int INDEX_TIME = 0;
    public static final int INDEX_HOSTNAME = 1;
    public static final int INDEX_USERNAME = 2;
    public static final int INDEX_FILENAME = 3;
    public static final int INDEX_PROCESSNAME = 4;
    public static final int INDEX_DESCRIPTION = 5;
    public static final int COL_TIME = 0;
    public static final int COL_HOSTNAME = 7;
    public static final int COL_USERNAME = 15;
    public static final int COL_FILENAME = 13;
    public static final int COL_PROCESSNAME = 12;
    public static final int COL_DESCRIPTION = 1;
    protected List<Object> logData = null;

    public LockdownExceptionObject(List<Object> logData) {
        this.logData = logData;
    }

    public boolean isValid() {
        return this.logData != null && this.logData.size() > 0;
    }

    public String getEventTimeDisplayString() {
        return this.logData.get(0).toString();
    }

    public String getHostName() {
        if (!this.isValid()) {
            return "";
        }
        return this.logData.get(7).toString();
    }

    public String getUserName() {
        if (!this.isValid()) {
            return "";
        }
        return this.logData.get(15).toString();
    }

    public String getFileName() {
        if (!this.isValid()) {
            return "";
        }
        String fileName = this.logData.get(13).toString();
        if (fileName != null && fileName.indexOf(":") != 0) {
            File f = new File(fileName);
            fileName = f.getAbsolutePath();
        }
        return fileName;
    }

    public String getProcessName() {
        if (!this.isValid()) {
            return "";
        }
        String callerProcessName = this.logData.get(12).toString();
        if (callerProcessName != null && callerProcessName.indexOf(":") != 0) {
            File f = new File(callerProcessName);
            callerProcessName = f.getAbsolutePath();
        }
        return callerProcessName;
    }

    public String getDescription() {
        if (!this.isValid()) {
            return "";
        }
        return this.logData.get(1).toString();
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getEventTimeDisplayString();
            }
            case 1: {
                return this.getHostName();
            }
            case 2: {
                return this.getUserName();
            }
            case 3: {
                return this.getFileName();
            }
            case 4: {
                return this.getProcessName();
            }
            case 5: {
                return this.getDescription();
            }
        }
        return "";
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Date.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }
}

