/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.AlSignature;
import com.sygate.scm.common.configobject.schema.AppliedPolicyArray;
import com.sygate.scm.common.configobject.schema.AutoLocation;
import com.sygate.scm.common.configobject.schema.Communication;
import com.sygate.scm.common.configobject.schema.DnsQuery;
import com.sygate.scm.common.configobject.schema.ExternalCommunication;
import com.sygate.scm.common.configobject.schema.ICMPQuery;
import com.sygate.scm.common.configobject.schema.Location;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.configobject.schema.UserInterface;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.AlSignatureObject;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.ExternalCommunicationObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.logicobject.PolicyLogEvent;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.logicobject.UserInterfaceObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleAssertion;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LocationObject
extends AbstractSelectableUIObject
implements TreeItem,
CopitableObject {
    protected Location _location = null;
    private SemLocationConfig _semLocationConfig = null;
    private UserInterface _userInterface = null;
    private boolean isDefault = false;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> changedObjSet = new HashMap<String, TopLevelObject>();
    private List<PolicyLogEvent> logList = new Vector<PolicyLogEvent>();
    private PhysicalFileObject physicalFileObject;
    private boolean locationChanged = false;

    public LocationObject() {
    }

    public LocationObject(Location _loc) throws ConsoleException {
        this._location = _loc;
        ObjReference refer = this._location.getObjReference();
        this._semLocationConfig = (SemLocationConfig)PolicyHandler.getNewObjectPool().get(refer.getTargetId());
        if (this._semLocationConfig == null) {
            this._semLocationConfig = (SemLocationConfig)PolicyHandler.getObject("SemLocationConfig", refer.getTargetId());
        }
    }

    public LocationObject(Location _loc, boolean isDefault, boolean getFromDB) throws ConsoleException {
        this._location = _loc;
        ObjReference refer = this._location.getObjReference();
        if (this._semLocationConfig == null) {
            this._semLocationConfig = getFromDB ? (SemLocationConfig)PolicyHandler.getObjectFromDB("SemLocationConfig", refer.getTargetId()) : (SemLocationConfig)PolicyHandler.getObject("SemLocationConfig", refer.getTargetId());
        }
        this.isDefault = isDefault;
    }

    public LocationObject(Location _loc, SemLocationConfig _semConfig) {
        this(_loc, _semConfig, false);
    }

    public LocationObject(Location _loc, SemLocationConfig _semConfig, boolean isDefault) {
        this._location = _loc;
        this._semLocationConfig = _semConfig;
        if (_semConfig == null || _loc == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        ObjReference refer = this._location.getObjReference();
        if (!refer.getTargetId().equals(_semConfig.getId())) {
            throw new IllegalArgumentException("Location objReference does not match SemLocationConfig");
        }
        this.isDefault = isDefault;
    }

    public LocationObject(String name, AutoLocation autoLoc) throws Exception {
        this._location = new Location();
        this._location.setName(name);
        this._location.setOptEnable(Boolean.TRUE);
        this._location.setId(new GUIDGenerator().getGUIDString());
        this._location.setOptExcludedFromAl(Boolean.FALSE);
        ObjReference obj = new ObjReference();
        obj.setName("LocationConfigLink");
        this._semLocationConfig = this.createSemLocationConfig();
        obj.setTargetId(this._semLocationConfig.getId());
        obj.setOptEnable(Boolean.TRUE);
        obj.setTargetType("SemLocationConfig");
        this._location.setObjReference(obj);
        MetadataAttributes mAttr = new MetadataAttributes();
        GUID owner = PolicyHandler.getOwnerOfObject((ConfigObject)autoLoc);
        mAttr.setOwner(owner);
        this._semLocationConfig.setMetadataAttributes(mAttr);
    }

    public LocationObject(String name, String desc) {
    }

    @Override
    public int getItemType() {
        return 22;
    }

    @Override
    public String getId() {
        return this._location.getId();
    }

    @Override
    public String getName() {
        String name = this._location.getName();
        ConsoleAssertion.runAssert(name == null, "No Name in Location. ID:" + this._location.getId());
        return name;
    }

    public void setName(String string) {
        this._location.setName(string);
    }

    public String getStatus() {
        return "";
    }

    public void setStatus(String value) {
    }

    public boolean hasChanged() {
        return false;
    }

    public void reset() {
    }

    public String toString() {
        return this.getName();
    }

    public boolean isEnabled() {
        if (this._location.getOptEnable() == null) {
            return true;
        }
        return this._location.getOptEnable();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setEnabled(boolean toEnable) {
        this._location.setOptEnable(Boolean.valueOf(toEnable));
    }

    protected void setDefaultLoc(boolean toDefault) {
        this.isDefault = toDefault;
    }

    public String getDescription() {
        String desc = this._location.getOptDescription();
        return desc == null ? "" : desc;
    }

    public void setDescription(String newString) {
        this._location.setOptDescription(newString);
    }

    public boolean getExcludedAutoLoc() {
        if (this._location.getOptExcludedFromAl() == null) {
            return false;
        }
        return this._location.getOptExcludedFromAl();
    }

    public void setExcludedAutoLoc(boolean isExcluded) {
        this._location.setOptExcludedFromAl(Boolean.valueOf(isExcluded));
    }

    public int getControlMode() {
        UserInterfaceObject uiObj = this.getUserInterfaceObject();
        return uiObj.getMode();
    }

    public Location getLocationObject() {
        return this._location;
    }

    public LocationObject getClone() throws ConsoleException {
        try {
            Location newLoc = (Location)PolicyHandler.getCopyOfObj((ConfigObject)this._location);
            LocationObject newObj = new LocationObject(newLoc, this.isDefault, false);
            return newObj;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public AlSignatureObject[] getSignatures() {
        AlSignatureObject[] allSigObjs = new AlSignatureObject[this._location.getAlSignatureCount()];
        for (int i = 0; i < this._location.getAlSignatureCount(); ++i) {
            allSigObjs[i] = new AlSignatureObject(this._location.getAlSignature(i), i == 0);
        }
        return allSigObjs;
    }

    public void addAlSignature(AlSignatureObject newAlSig) {
        int sigCount = this._location.getAlSignatureCount();
        if (sigCount == 0) {
            newAlSig.setToFirst();
        }
        this._location.addAlSignature(newAlSig.getAlSignature());
    }

    public SemLocationConfig createSemLocationConfig() throws Exception {
        SemLocationConfig defaultLocConfig = PolicyHandler.getDefaultSemLocationConfig(this.newObjSet);
        if (defaultLocConfig != null) {
            this.newObjSet.put(defaultLocConfig.getId(), (TopLevelObject)defaultLocConfig);
            return defaultLocConfig;
        }
        Communication com = new Communication();
        com.setMode(Communication.PUSH);
        ExternalCommunication extComm = new ExternalCommunication();
        SemLocationConfig sem = new SemLocationConfig();
        sem.setId(new GUIDGenerator().getGUIDString());
        sem.setOptCommunication(com);
        sem.setOptExternalCommunication(extComm);
        this.newObjSet.put(sem.getId(), (TopLevelObject)sem);
        return sem;
    }

    public Map<String, TopLevelObject> getNewObjSet() {
        return this.newObjSet;
    }

    public CommunicationObject getCommunicationObject() {
        Communication communication = this._semLocationConfig.getOptCommunication();
        return new CommunicationObject(communication);
    }

    public void setExternalCommunication(ExternalCommunicationObject extComObj) {
        if (extComObj != null) {
            ExternalCommunication newObj = extComObj.getExternalCommunication();
            ExternalCommunication communication = this._semLocationConfig.getOptExternalCommunication();
            if (PolicyHandler.compareConfigObject((ConfigObject)communication, (ConfigObject)newObj)) {
                return;
            }
            this._semLocationConfig.setOptExternalCommunication(newObj);
            PolicyHandler.updateObject((TopLevelObject)this._semLocationConfig, this.newObjSet, this.changedObjSet);
        } else {
            this._semLocationConfig.setOptExternalCommunication(null);
            PolicyHandler.updateObject((TopLevelObject)this._semLocationConfig, this.newObjSet, this.changedObjSet);
        }
    }

    public ExternalCommunicationObject getExternalCommunicationObject() {
        ExternalCommunication extCommunication = this._semLocationConfig.getOptExternalCommunication();
        return new ExternalCommunicationObject(extCommunication);
    }

    public void setCommunication(CommunicationObject comObj) {
        if (comObj != null) {
            Communication newObj = comObj.getCommunication();
            Communication communication = this._semLocationConfig.getOptCommunication();
            if (PolicyHandler.compareConfigObject((ConfigObject)communication, (ConfigObject)newObj)) {
                return;
            }
            this._semLocationConfig.setOptCommunication(newObj);
            PolicyHandler.updateObject((TopLevelObject)this._semLocationConfig, this.newObjSet, this.changedObjSet);
        } else {
            this._semLocationConfig.setOptCommunication(null);
            PolicyHandler.updateObject((TopLevelObject)this._semLocationConfig, this.newObjSet, this.changedObjSet);
        }
    }

    public boolean hasNoAppliedPolicy() {
        boolean retValue = true;
        AppliedPolicyArray apArray = this._semLocationConfig.getOptAppliedPolicyArray();
        if (apArray != null) {
            retValue = apArray.getObjReferenceCount() <= 0;
        }
        return retValue;
    }

    public SemLocationConfig getSemLocationConfigObj() {
        return this._semLocationConfig;
    }

    public void delete() {
        String id = this._semLocationConfig.getId();
        if (this.newObjSet.containsKey(id)) {
            this.newObjSet.remove(id);
        } else {
            this.deletedObjSet.put(id, (TopLevelObject)this._semLocationConfig);
        }
        if (this.changedObjSet.containsKey(id)) {
            this.changedObjSet.remove(id);
        }
        this._location.getParent().removeChild((AbstractSchema)this._location);
    }

    public Map<String, TopLevelObject> getDeletedObj() {
        return this.deletedObjSet;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        WashIDHandler washer = new WashIDHandler();
        HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
        try {
            Location newLoc = (Location)washer.duplicateObject((ConfigObject)this._location, createdObj);
            SemLocationConfig newConfig = (SemLocationConfig)createdObj.get(this._semLocationConfig.getId());
            try {
                System.out.println("Old Loc:");
                System.out.println(this._semLocationConfig.getString());
                System.out.println("new Loc:");
                System.out.println(newConfig.getString());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            LocationObject newLocObj = new LocationObject(newLoc, newConfig);
            newLocObj.addNewObject(new HashSet<TopLevelObject>(createdObj.values()));
            return newLocObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public void addNewObject(Set<TopLevelObject> moreNewObjs) {
        PolicyHandler.dumpObjects(moreNewObjs, this.newObjSet);
    }

    public boolean isConnectToServer() {
        CommunicationObject cObj = this.getCommunicationObject();
        return cObj.isConnectToServer();
    }

    public void resortData() {
        AlSignature[] allSigs = this._location.getAlSignature().toArray(new AlSignature[0]);
        for (int i = 0; i < allSigs.length; ++i) {
            int conditionCnt = 0;
            conditionCnt = allSigs[i].getLocalHostAddressCount();
            conditionCnt += allSigs[i].getWinsServerAddressCount();
            conditionCnt += allSigs[i].getDnsServerAddressCount();
            conditionCnt += allSigs[i].getDhcpServerAddressCount();
            conditionCnt += allSigs[i].getGatewayAddressCount();
            conditionCnt += allSigs[i].getOptAlHostIntegrity() != null ? 1 : 0;
            conditionCnt += allSigs[i].getOptCmsConnection() != null ? 1 : 0;
            conditionCnt += allSigs[i].getNetworkConnectionCount();
            conditionCnt += allSigs[i].getTpmDeviceCount();
            conditionCnt += allSigs[i].getDnsResolveCount();
            conditionCnt += allSigs[i].getAlRegistryCount();
            conditionCnt += allSigs[i].getWirelessSSIDCount();
            conditionCnt += allSigs[i].getNICDescriptionCount();
            conditionCnt += allSigs[i].getRemoteDeviceCommunicationCount();
            conditionCnt += allSigs[i].getDomainNameCount();
            conditionCnt += allSigs[i].getICMPRequestCount();
            conditionCnt += allSigs[i].getLocalHostNameCount();
            conditionCnt += allSigs[i].getUserNameCount();
            conditionCnt += allSigs[i].getFileExistsCount();
            if ((conditionCnt += allSigs[i].getOSVersionCount()) != 0) continue;
            allSigs[i].getParent().removeChild((AbstractSchema)allSigs[i]);
        }
    }

    public UserInterfaceObject getUserInterfaceObject() {
        if (this._userInterface == null && this._semLocationConfig != null) {
            this._userInterface = this._semLocationConfig.getOptUserInterface();
        }
        return new UserInterfaceObject(this._userInterface);
    }

    public void setUserInterface(UserInterfaceObject userObj) {
        UserInterface newObj = userObj.getUserInterface();
        if (PolicyHandler.compareConfigObject((ConfigObject)this._userInterface, (ConfigObject)newObj)) {
            return;
        }
        this._semLocationConfig.setOptUserInterface(newObj);
        this._userInterface = newObj;
    }

    public AppliedPolicyObject getAppliedPolicyObject() {
        AppliedPolicyArray apArray = this._semLocationConfig.getOptAppliedPolicyArray();
        if (apArray == null) {
            apArray = this.createAppliedPolicy();
            apArray.setParent((AbstractSchema)this._semLocationConfig);
        }
        return new AppliedPolicyObject(apArray, this.getName(), PolicyHandler.getOwnerOfObject((ConfigObject)this._semLocationConfig).toString());
    }

    public AppliedPolicyObject getAppliedPolicyObject(boolean fromDB) throws ConsoleException {
        AppliedPolicyArray apArray;
        if (fromDB) {
            this._semLocationConfig = (SemLocationConfig)PolicyHandler.getObjectFromDB("SemLocationConfig", this._location.getObjReference().getTargetId());
        }
        if ((apArray = this._semLocationConfig.getOptAppliedPolicyArray()) == null) {
            apArray = this.createAppliedPolicy();
            apArray.setParent((AbstractSchema)this._semLocationConfig);
        }
        return new AppliedPolicyObject(apArray, this.getName(), PolicyHandler.getOwnerOfObject((ConfigObject)this._semLocationConfig).toString());
    }

    private AppliedPolicyArray createAppliedPolicy() {
        AppliedPolicyArray apArray = new AppliedPolicyArray();
        return apArray;
    }

    public void setAppliedPolicyObject(AppliedPolicyObject newObj) {
        AppliedPolicyArray array = newObj.getAppliedPolicyArray();
        this._semLocationConfig.setOptAppliedPolicyArray(array);
        PolicyHandler.dumpObjects(newObj.getNewObjSet(), this.newObjSet);
        PolicyHandler.dumpObjects(newObj.getChangedObjSet(), this.changedObjSet);
        PolicyHandler.dumpObjects(newObj.getDeletedObjSet(), this.deletedObjSet);
        PolicyHandler.updateObject((TopLevelObject)this._semLocationConfig, this.newObjSet, this.changedObjSet);
        this.logList.addAll(newObj.getLogList());
        newObj.clearAllObjSets();
    }

    public Map<String, TopLevelObject> getChangedObjSet() {
        return this.changedObjSet;
    }

    public Map<String, TopLevelObject> getDeletedObjSet() {
        return this.deletedObjSet;
    }

    public void clearAllObjSets() {
        this.newObjSet.clear();
        this.changedObjSet.clear();
        this.deletedObjSet.clear();
        this.logList.clear();
    }

    public void addLog(int eventId, String desc) {
        GUID owner = PolicyHandler.getOwnerOfObject((ConfigObject)this._location);
        this.logList.add(new PolicyLogEvent(eventId, owner.toString(), desc));
    }

    public List<PolicyLogEvent> getLogList() {
        return this.logList;
    }

    public void setPhysicalFileObject(PhysicalFileObject obj) {
        this.physicalFileObject = obj;
    }

    public PhysicalFileObject getPhysicalFileObject() {
        return this.physicalFileObject;
    }

    public boolean isComGlobal() {
        return this._semLocationConfig.getOptCommunication() == null;
    }

    public boolean isExternalCommunicationGlobal() {
        return this._semLocationConfig.getOptExternalCommunication() == null;
    }

    public void setDirty() {
        this.locationChanged = true;
    }

    public boolean isDirty() {
        return this.locationChanged;
    }

    public void setICMPQuery(Boolean enable, Integer freq) {
        ICMPQuery query = this._location.getOptICMPQuery();
        if (query == null) {
            query = new ICMPQuery();
            this._location.setOptICMPQuery(query);
        }
        query.setOptEnable(enable);
        query.setOptFrequency(freq);
    }

    public void setDnsQuery(boolean enable, Integer freq) {
        DnsQuery query = this._location.getOptDnsQuery();
        if (query == null) {
            query = new DnsQuery();
            this._location.setOptDnsQuery(query);
        }
        query.setOptEnable(Boolean.valueOf(enable));
        query.setOptFrequency(freq);
    }

    private ICMPQuery getICMPQuery() {
        ICMPQuery query = this._location.getOptICMPQuery();
        if (query == null) {
            query = new ICMPQuery();
            this._location.setOptICMPQuery(query);
        }
        return query;
    }

    private DnsQuery getDnsQuery() {
        DnsQuery query = this._location.getOptDnsQuery();
        if (query == null) {
            query = new DnsQuery();
            this._location.setOptDnsQuery(query);
        }
        return query;
    }

    public boolean isICMPQueryEnabled() {
        ICMPQuery query = this.getICMPQuery();
        if (query.getOptEnable() == null) {
            return query.getDefEnable();
        }
        return query.getOptEnable();
    }

    public Integer getICMPQueryFreq() {
        ICMPQuery query = this.getICMPQuery();
        if (query.getOptFrequency() == null) {
            return query.getDefFrequency();
        }
        return query.getOptFrequency();
    }

    public boolean isDnsQueryEnabled() {
        DnsQuery query = this.getDnsQuery();
        if (query.getOptEnable() == null) {
            return query.getDefEnable();
        }
        return query.getOptEnable();
    }

    public Integer getDnsQueryFreq() {
        DnsQuery query = this.getDnsQuery();
        if (query.getOptFrequency() == null) {
            return query.getDefFrequency();
        }
        return query.getOptFrequency();
    }
}

