/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.rpc.SemLoginInfo;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.EnforcerGroupTree;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnforcerGroupObject;
import com.sygate.scm.console.logicobject.EnforcerPolicyObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ScmLicense;
import com.sygate.scm.util.ScmLicenseConstants;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LicenseObject
extends AbstractUIObject
implements TreeItem,
ScmLicenseConstants {
    private static final int GATEWAY_ENFORCEMENT = 0;
    private static final int LAN_ENFORCEMENT = 1;
    private static final int DHCP_ENFORCEMENT = 2;
    private static final int INTEGRATED_ENFORCEMENT = 3;
    private int itemType = 67;
    private ScmLicense license = new ScmLicense(this.getLicenseData());
    public static final int LICENSE_TEST_FLAG_NORMAL = 0;
    public static final int LICENSE_TEST_FLAG_ENABLE = 1;
    public static final int LICENSE_TEST_FLAG_SB = 2;
    public static final int LICENSE_TEST_FLAG_SEPSB = 4;
    public static final int LICENSE_TEST_FLAG_SAVSB = 8;
    private static int LICENSE_TEST_FLAGS = 0;
    private static boolean pepLicenseActivated = false;
    private static boolean licenseCompliance = true;
    private static int currentWorkstationsAgentsCount;
    private static int currentServersAgentsCount;
    private static int currentEnforcementAgentsCount;
    private int currentSiteCount;
    private int currentServerCount;
    private int currentGatewayEnforcerCount;
    private int currentLanEnforcerCount;
    private int currentDhcpEnforcerCount;
    private int licenseExpirationDateStatus;
    private int onlineSubscriptionExpirationDateStatus;
    private static String newLicenseType;
    private static LicenseObject gInstance;

    private LicenseObject() {
    }

    @Override
    public String getId() {
        return "licenseID";
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Override
    public String getName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "LicenseObject.NameLicenseManagement");
    }

    public String toString() {
        return this.getName();
    }

    public boolean isCountFeatureCompliance(int licenseCount, int currentCount) {
        if (licenseCount == -1) {
            return true;
        }
        return licenseCount >= currentCount;
    }

    public boolean isLicenseCompliance() {
        return licenseCompliance;
    }

    public String getLicenseExpirationDate() {
        return this.getExpirationDate(this.license.getLicenseExpirationDate(), true);
    }

    public String getOnlineSubscriptionExpirationDate() {
        return this.getExpirationDate(this.license.getOnlineSubscriptionExpirationDate(), false);
    }

    public int getWorkstationsAgentsCount() {
        return this.license.getWorkstationsAgentsCount();
    }

    public int getServersAgentsCount() {
        return this.license.getServersAgentsCount();
    }

    public int getEnforcementAgentCount() {
        return this.license.getEnforcementAgentCount();
    }

    public int getSiteCount() {
        return this.license.getSiteCount();
    }

    public int getServerCount() {
        return this.license.getServerCount();
    }

    public boolean isAdaptiveLocation() {
        return this.license.isAdaptiveLocation();
    }

    public boolean isExternalLogging() {
        return this.license.isExternalLogging();
    }

    public boolean isFirewallPolicy() {
        return this.license.isFirewallPolicy();
    }

    public boolean isIntrusionPreventionEnabled() {
        return this.license.isIntrusionPreventionPolicy();
    }

    public boolean hasIntrusionPreventionLicense() {
        return this.license.isIntrusionPreventionPolicy();
    }

    public boolean isHostIntegrityPolicy() {
        return this.license.isHostIntegrityPolicy();
    }

    public boolean isOSPretectionPolicy() {
        return this.license.isOSProtectionPolicy();
    }

    public boolean isLANSensor() {
        return this.license.isLANSensor();
    }

    public boolean isGatewayEnforcer() {
        return this.license.isGatewayEnforcer();
    }

    public boolean isLanEnforcer() {
        return this.license.isLanEnforcer();
    }

    public boolean isDhcpEnforcer() {
        return this.license.isDhcpEnforcer();
    }

    public boolean isPEPActivated() {
        return pepLicenseActivated;
    }

    public boolean isAvPolicy() {
        return this.license.isAvPolicy();
    }

    public boolean isPolicyOverride() {
        return this.license.isPolicyOverride();
    }

    public boolean isUpgradePolicy() {
        return this.license.isUpgradePolicy();
    }

    public boolean isTamperProtection() {
        return this.license.isTamperProtection();
    }

    public boolean isMemPolicy() {
        return this.license.isMemPolicy();
    }

    public boolean isNtrPolicy() {
        return this.license.isNtrPolicy();
    }

    public boolean isAdaptivePolicy() {
        return this.license.isAdaptivePolicy();
    }

    public boolean isQualifiedLuContentCategory(String categoryName) {
        return this.license.isQualifiedLuContentCategory(categoryName);
    }

    public boolean isSAVOnlyProduct() {
        return this.license.isSAVOnlyProduct();
    }

    public boolean isSNACOnlyProduct() {
        return this.license.isSNACOnlyProduct();
    }

    public boolean isALLProduct() {
        return this.license.isALLProduct();
    }

    public boolean isSBProduct() {
        if ((LICENSE_TEST_FLAGS & 1) == 1) {
            return (LICENSE_TEST_FLAGS & 2) == 2;
        }
        boolean isSBProduct = false;
        if ("SEPSB".equalsIgnoreCase(newLicenseType)) {
            isSBProduct = true;
        }
        return isSBProduct;
    }

    public boolean isSAVSBProduct() {
        if ((LICENSE_TEST_FLAGS & 1) == 1) {
            return (LICENSE_TEST_FLAGS & 8) == 8;
        }
        return false;
    }

    public boolean isQuarantinePolicy() {
        return this.license.isQuarantinePolicy();
    }

    public boolean isSEPSBProduct() {
        if ((LICENSE_TEST_FLAGS & 1) == 1) {
            return (LICENSE_TEST_FLAGS & 4) == 4;
        }
        return this.isSBProduct();
    }

    public String getProductName() {
        return this.license.getProductName();
    }

    public String getProductDisplayName() {
        if (this.isSBProduct()) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "LicenseObject.ProductNameSEPSB");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "LicenseObject.ProductNameSEP");
    }

    public int getLicenseExpirationDateStatus() {
        this.licenseExpirationDateStatus = this.getDateStatus(this.license.getLicenseExpirationDate(), true);
        return this.licenseExpirationDateStatus;
    }

    public int getOnlineSubscriptionExpirationDateStatus() {
        this.onlineSubscriptionExpirationDateStatus = this.getDateStatus(this.license.getOnlineSubscriptionExpirationDate(), false);
        return this.onlineSubscriptionExpirationDateStatus;
    }

    public int getCurrentWorkstationsAgentsCount() {
        return currentWorkstationsAgentsCount;
    }

    public int getCurrentServersAgentsCount() {
        return currentServersAgentsCount;
    }

    public int getCurrentEnforcementAgentsCount() {
        return currentEnforcementAgentsCount;
    }

    public int getCurrentSiteCount() {
        try {
            this.currentSiteCount = this.getSiteArray().size();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return this.currentSiteCount;
    }

    public int getCurrentServerCount() {
        this.currentServerCount = 0;
        try {
            List<SemSite> sites = this.getSiteArray();
            for (int i = 0; i < sites.size(); ++i) {
                ServerArray serverArray = sites.get(i).getServerArray();
                this.currentServerCount += serverArray.getSemServerCount();
            }
        }
        catch (ConsoleException ex) {
            this.currentServerCount = 0;
        }
        return this.currentServerCount;
    }

    public int getCurrentGatewayEnforcerCount() {
        this.currentGatewayEnforcerCount = 0;
        try {
            List<SemSite> sites = this.getSiteArray();
            for (int i = 0; i < sites.size(); ++i) {
                this.currentGatewayEnforcerCount += this.getEnforcementCount(sites.get(i), 0);
            }
        }
        catch (ConsoleException ex) {
            this.currentGatewayEnforcerCount = 0;
        }
        return this.currentGatewayEnforcerCount;
    }

    public int getCurrentLanEnforcerCount() {
        this.currentLanEnforcerCount = 0;
        try {
            List<SemSite> sites = this.getSiteArray();
            for (int i = 0; i < sites.size(); ++i) {
                this.currentLanEnforcerCount += this.getEnforcementCount(sites.get(i), 1);
            }
        }
        catch (ConsoleException ex) {
            this.currentLanEnforcerCount = 0;
        }
        return this.currentLanEnforcerCount;
    }

    public int getCurrentDhcpEnforcerCount() {
        this.currentDhcpEnforcerCount = 0;
        try {
            List<SemSite> sites = this.getSiteArray();
            for (int i = 0; i < sites.size(); ++i) {
                this.currentDhcpEnforcerCount += this.getEnforcementCount(sites.get(i), 2);
            }
        }
        catch (ConsoleException ex) {
            this.currentDhcpEnforcerCount = 0;
        }
        return this.currentDhcpEnforcerCount;
    }

    private String getExpirationDate(Date date, boolean isLicenseDate) {
        if (isLicenseDate) {
            if (date == null) {
                return "Perpetual License";
            }
            String dateString = Utility.getDateTimeString((Date)date, (String)"MM/dd/yyyy", null);
            if (dateString.equals("01/01/1970")) {
                return "License Unavailable";
            }
            return Utility.getDateTimeString((Date)date, (String)"MM/dd/yyyy", null);
        }
        if (date == null) {
            return "License Unavailable";
        }
        return Utility.getDateTimeString((Date)date, (String)"MM/dd/yyyy", null);
    }

    private int getDateStatus(Date licenseDate, boolean isLicenseDate) {
        if (licenseDate == null) {
            return isLicenseDate ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        if (Utility.getDateTimeString((Date)licenseDate, (String)"MM/dd/yyyy", null).equals("01/01/1970")) {
            return Integer.MIN_VALUE;
        }
        long licenseTime = licenseDate.getTime();
        long currentTime = System.currentTimeMillis();
        double remain = (double)(licenseTime - currentTime) / 8.64E7;
        return (int)Math.ceil(remain);
    }

    private String getLicenseData() {
        String licenseData = null;
        SemLoginInfo loginInfo = DataobjectManager.getInstance().getLoginInformation();
        if (loginInfo == null) {
            licenseData = "SAV";
            newLicenseType = Env.getNEW_PRODUCT_TYPE();
        } else {
            Boolean pepLicenseActivatedValue;
            String oldLicenseType = loginInfo.getOptProductType();
            String licenseState = loginInfo.getOptLicenseState();
            if (licenseState != null) {
                if ((licenseState = licenseState.toUpperCase()).startsWith("SEPE")) {
                    newLicenseType = "SEPE";
                    Env.setNEW_PRODUCT_TYPE(newLicenseType);
                } else if (licenseState.startsWith("SEPSB")) {
                    newLicenseType = "SEPSB";
                    Env.setNEW_PRODUCT_TYPE(newLicenseType);
                }
            }
            boolean bl = pepLicenseActivated = (pepLicenseActivatedValue = loginInfo.getOptPepLicenseActivated()) == null ? Boolean.FALSE.booleanValue() : pepLicenseActivatedValue.booleanValue();
            if (newLicenseType == null) {
                newLicenseType = "SEPE";
            }
            System.setProperty("Spc.Product.Type", newLicenseType);
            licenseData = oldLicenseType;
        }
        return licenseData;
    }

    private List<SemSite> getSiteArray() throws ConsoleException {
        ArrayList<SemSite> sites = new ArrayList<SemSite>();
        DataobjectManager data = DataobjectManager.getInstance();
        SemSiteArray siteArray = data.getSemConfigRoot().getSemSiteArray();
        for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
            SemSite site = data.getSemSite(siteArray.getObjReference(i).getTargetId());
            if (Utility.getBooleanValue((Boolean)site.getOptSuspended(), (Boolean)site.getDefSuspended())) continue;
            sites.add(site);
        }
        return sites;
    }

    private int getEnforcementCount(SemSite site, int enforcementType) {
        int count = 0;
        EnforcerGroupTree enforcerGroupTree = site.getOptEnforcerGroupTree();
        if (enforcerGroupTree != null) {
            EnforcerGroup rootGroup = enforcerGroupTree.getEnforcerGroup();
            for (int i = 0; i < rootGroup.getEnforcerGroupCount(); ++i) {
                EnforcerGroupObject groupObj = new EnforcerGroupObject(rootGroup.getEnforcerGroup(i));
                EnforcerPolicyObject policyObj = groupObj.getEnforcePolicyObject();
                if (enforcementType == 0 && policyObj.isGatewayPolicy()) {
                    count += groupObj.getEnforcerCount();
                    continue;
                }
                if (enforcementType == 1 && policyObj.isLanPolicy()) {
                    count += groupObj.getEnforcerCount();
                    continue;
                }
                if (enforcementType == 2 && policyObj.isDhcpPolicy()) {
                    count += groupObj.getEnforcerCount();
                    continue;
                }
                if (enforcementType != 3 || !policyObj.isIntegratedPolicy()) continue;
                count += groupObj.getEnforcerCount();
            }
        }
        return count;
    }

    public static void setTestMode(int testFlags) {
        LICENSE_TEST_FLAGS = testFlags;
    }

    public static synchronized LicenseObject getInstance() {
        if (gInstance == null) {
            gInstance = new LicenseObject();
        }
        return gInstance;
    }

    public void updateLicenseState() {
        this.license = new ScmLicense(this.getLicenseData());
    }

    public static synchronized void resetInstance() {
        gInstance = null;
    }

    static {
        newLicenseType = null;
    }
}

