/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.util.ConsoleLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;

public class LicenseChainObject
extends AbstractUIObject
implements TreeItem {
    public static final String PRODUCT_TYPE_SEP = "SEP";
    public static final String PRODUCT_TYPE_SNAC = "SNAC";
    private LicenseChain chain;

    public LicenseChainObject(LicenseChain licenseChain) {
        this.chain = licenseChain;
    }

    public LicenseChain getLicenseChain() {
        return this.chain;
    }

    public int getCount() {
        if (this.chain != null) {
            return this.chain.getOptMeterCount();
        }
        return 0;
    }

    public long getEndDate() {
        if (this.chain != null) {
            return this.chain.getOptEndDate();
        }
        return 0L;
    }

    public long getExpireDate() {
        if (this.chain != null) {
            return this.chain.getOptExpireDate();
        }
        return 0L;
    }

    public long getWarnDate() {
        if (this.chain != null) {
            return this.chain.getOptWarnDate();
        }
        return 0L;
    }

    public int getGraceCount() {
        if (this.chain != null) {
            return this.chain.getOptGraceCount();
        }
        return 0;
    }

    public String getChecksum() {
        if (this.chain != null) {
            return this.chain.getOptChecksum();
        }
        return null;
    }

    @Override
    public String getId() {
        if (this.chain != null) {
            return this.chain.getId();
        }
        return null;
    }

    @Override
    public int getItemType() {
        return 166;
    }

    public String getRenewalURL() {
        if (this.chain != null && this.chain.getOptRenewalURL() != null) {
            return this.chain.getOptRenewalURL();
        }
        return "http://www.symantec.com";
    }

    public Integer getOptClientProductType() {
        return this.chain.getOptClientProductType();
    }

    public String getOptClientProductTypeValue() throws ValidationException {
        return this.chain.getOptClientProductTypeValue();
    }

    public ArrayList<ElsLicenseObject> getLicenses() {
        ArrayList<ElsLicenseObject> licenses = new ArrayList<ElsLicenseObject>();
        if (this.chain != null) {
            Vector v = this.chain.getElsLicense();
            for (int i = 0; i < v.size(); ++i) {
                if (v.get(i) == null || ((ElsLicense)v.get(i)).isDeleted()) continue;
                licenses.add(new ElsLicenseObject((ElsLicense)v.get(i)));
            }
        }
        return licenses;
    }

    public int getLicenseCount() {
        if (this.chain != null) {
            return this.chain.getElsLicenseCount();
        }
        return 0;
    }

    public ElsLicenseObject getFirstLicense() {
        if (this.chain != null && this.chain.getElsLicenseCount() > 0) {
            return new ElsLicenseObject(this.chain.getElsLicense(0));
        }
        return null;
    }

    public ElsLicenseObject getLastLicense() {
        if (null == this.chain) {
            return null;
        }
        int count = this.chain.getElsLicenseCount();
        if (count > 0) {
            return new ElsLicenseObject(this.chain.getElsLicense(count - 1));
        }
        return null;
    }

    public long getStartDate() {
        ElsLicenseObject firstLicense = this.getFirstLicense();
        if (firstLicense != null) {
            return firstLicense.getStartDate();
        }
        return 0L;
    }

    @Override
    public String getName() {
        try {
            ElsLicenseObject license;
            String productType = null;
            productType = this.chain.getOptClientProductTypeValue();
            if (productType == null) {
                productType = "";
            }
            if ((license = this.getLastLicense()) != null) {
                Object[] obj = new Object[]{license.getSerialNumber(), productType, this.getCount(), ElsLicenseObject.getDateStr(this.getExpireDate())};
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "LicenseChainObject.name");
                return MessageFormat.format(msg, obj);
            }
            return "";
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            return "";
        }
    }

    public int getLicenseCategory() {
        ElsLicenseObject elsLicObj = this.getFirstLicense();
        if (elsLicObj != null) {
            Integer category = elsLicObj.getLicenseCategory();
            return category == null ? -1 : category;
        }
        return -1;
    }
}

