/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.LanEnforcement;
import com.sygate.scm.common.configobject.schema.LanTrustedHostArray;
import com.sygate.scm.common.configobject.schema.MABSection;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LanTrustedHostArrayObject;
import java.util.Collection;

public class LanEnforcerMABSectionObject
extends AbstractUIObject {
    private MABSection mabSection;

    public LanEnforcerMABSectionObject(MABSection mabSection) {
        this.mabSection = mabSection;
    }

    public static LanEnforcerMABSectionObject newInstance(LanEnforcement lan) {
        MABSection mabSection = lan.getOptMABSection();
        if (mabSection == null) {
            mabSection = new MABSection();
            mabSection.setOptLanTrustedHostArray(new LanTrustedHostArray());
            lan.setOptMABSection(mabSection);
        }
        return new LanEnforcerMABSectionObject(mabSection);
    }

    public LanTrustedHostArrayObject getTrustedHostArrayObject() {
        LanTrustedHostArray trustedHostArray = this.mabSection.getOptLanTrustedHostArray();
        if (trustedHostArray == null) {
            return null;
        }
        return new LanTrustedHostArrayObject(trustedHostArray);
    }

    public void setMacAddressBlockRef(ObjReference block, int totalMacCount) {
        LanTrustedHostArrayObject trustedHostArrayObj = this.getTrustedHostArrayObject();
        if (trustedHostArrayObj == null) {
            trustedHostArrayObj = LanTrustedHostArrayObject.newInstance(this.mabSection);
        }
        if (block == null) {
            trustedHostArrayObj.setOptMacAddressBlockReference(null, 0);
        } else {
            trustedHostArrayObj.setOptMacAddressBlockReference(block, totalMacCount);
        }
    }

    public void setTrustedHostArrayObject(Collection<MacAddress> macAddress) {
        LanTrustedHostArrayObject trustedHostArrayObj = this.getTrustedHostArrayObject();
        if (trustedHostArrayObj == null && macAddress != null) {
            trustedHostArrayObj = LanTrustedHostArrayObject.newInstance(this.mabSection);
        }
        if (macAddress != null && trustedHostArrayObj != null) {
            trustedHostArrayObj.setAllAddress(macAddress);
        }
        if (trustedHostArrayObj == null) {
            this.mabSection.setOptLanTrustedHostArray(null);
        }
    }

    public boolean isEnabled() {
        Boolean isEnabled = this.mabSection.getOptEnable();
        if (isEnabled == null) {
            isEnabled = false;
        }
        return isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        if (isEnabled != this.isEnabled()) {
            this.mabSection.setOptEnable(Boolean.valueOf(isEnabled));
        }
    }
}

