/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.EnableNetworkTimeProtocol;
import com.sygate.scm.common.configobject.schema.IgnoreCheck;
import com.sygate.scm.common.configobject.schema.LanAllowLegacyClient;
import com.sygate.scm.common.configobject.schema.LanEnableLocalAuth;
import com.sygate.scm.common.configobject.schema.LanEnforcement;
import com.sygate.scm.common.configobject.schema.LanEnforcerNetworkSetting;
import com.sygate.scm.common.configobject.schema.LanNetworkPolicyServer;
import com.sygate.scm.common.configobject.schema.MABSection;
import com.sygate.scm.common.configobject.schema.SEPMHealthCheck;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SeRadiusServerGroup;
import com.sygate.scm.common.configobject.schema.SeSwitchEnforcementPolicy;
import com.sygate.scm.common.configobject.schema.SwitchGroupTree;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.EnableNetworkTimeProtocolObject;
import com.sygate.scm.console.logicobject.EnforcerLanNetworkSettingObject;
import com.sygate.scm.console.logicobject.EnforcerSEPMHealthCheckObject;
import com.sygate.scm.console.logicobject.EnforcerSwitchGroupTreeObject;
import com.sygate.scm.console.logicobject.LanEnforcerAllowLegacyClientObject;
import com.sygate.scm.console.logicobject.LanEnforcerEnableLocalAuthenticationObject;
import com.sygate.scm.console.logicobject.LanEnforcerIgnoreCheckObject;
import com.sygate.scm.console.logicobject.LanEnforcerMABSectionObject;
import com.sygate.scm.console.logicobject.LanNetworkPolicyServerObject;
import com.sygate.scm.console.logicobject.RadiusServerGroupPoolObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.List;

public class LanEnforcementObject
extends AbstractUIObject {
    private LanEnforcement lan;

    public LanEnforcementObject(LanEnforcement lan) {
        this.lan = lan;
    }

    public static LanEnforcementObject newInstance(SeEnforcerPolicy policy) {
        LanEnforcement lan = policy.getOptLanEnforcement();
        if (lan == null) {
            lan = new LanEnforcement();
            lan.setLanEnforcerNetworkSetting(new LanEnforcerNetworkSetting());
            lan.setOptIgnoreCheck(new IgnoreCheck());
            lan.setOptMABSection(new MABSection());
            lan.setOptLanNetworkPolicyServer(new LanNetworkPolicyServer());
            policy.setOptLanEnforcement(lan);
        }
        return new LanEnforcementObject(lan);
    }

    public LanEnforcerIgnoreCheckObject getIgnoreCheckObject() {
        IgnoreCheck ignoreCheck = this.lan.getOptIgnoreCheck();
        if (ignoreCheck == null) {
            return null;
        }
        return new LanEnforcerIgnoreCheckObject(ignoreCheck);
    }

    public void setIgnoreCheckObject(IgnoreCheck ignoreCheck) {
        LanEnforcerIgnoreCheckObject ignoreCheckObj = this.getIgnoreCheckObject();
        if (ignoreCheckObj == null) {
            LanEnforcerIgnoreCheckObject.newInstance(this.lan);
        }
    }

    public LanEnforcerMABSectionObject getMABSectionObject() {
        MABSection mabSection = this.lan.getOptMABSection();
        if (mabSection == null) {
            return null;
        }
        return new LanEnforcerMABSectionObject(mabSection);
    }

    public void setMABSectionObject(MABSection mabSection) {
        LanEnforcerMABSectionObject mabSectionObj = this.getMABSectionObject();
        if (mabSectionObj == null) {
            LanEnforcerMABSectionObject.newInstance(this.lan);
        }
    }

    public EnforcerSwitchGroupTreeObject getSwitchGroupTreeObject(boolean alwaysGet) {
        SwitchGroupTree groupTree = this.lan.getOptSwitchGroupTree();
        if (groupTree == null) {
            if (alwaysGet) {
                return EnforcerSwitchGroupTreeObject.newInstance(this.lan);
            }
            return null;
        }
        return new EnforcerSwitchGroupTreeObject(groupTree);
    }

    public EnforcerLanNetworkSettingObject getLanNetworkSettingObject() {
        LanEnforcerNetworkSetting setting = this.lan.getLanEnforcerNetworkSetting();
        if (setting == null) {
            return null;
        }
        return new EnforcerLanNetworkSettingObject(setting);
    }

    public List<SeSwitchEnforcementPolicy> getSwitchEnforcementPolicies() {
        EnforcerSwitchGroupTreeObject groupTreeObj = this.getSwitchGroupTreeObject(false);
        if (groupTreeObj == null) {
            return new ArrayList<SeSwitchEnforcementPolicy>();
        }
        return groupTreeObj.getSwitchEnforcementPolicies();
    }

    public List<SeRadiusServerGroup> getRadiusServerGroups() {
        EnforcerSwitchGroupTreeObject groupTreeObj = this.getSwitchGroupTreeObject(false);
        if (groupTreeObj == null) {
            return new ArrayList<SeRadiusServerGroup>();
        }
        return groupTreeObj.getRadiusServerGroups();
    }

    public void setLanNetworkSettingObject(String port) {
        EnforcerLanNetworkSettingObject settingObj = this.getLanNetworkSettingObject();
        settingObj.setListenPort(port);
    }

    public LanEnforcerAllowLegacyClientObject getAllowLegacyClientObject() {
        LanAllowLegacyClient schema = this.lan.getOptLanAllowLegacyClient();
        if (schema == null) {
            return null;
        }
        return new LanEnforcerAllowLegacyClientObject(schema);
    }

    public void setAllowLegacyClientObject(boolean isEnabled) {
        LanEnforcerAllowLegacyClientObject obj = this.getAllowLegacyClientObject();
        if (obj == null) {
            obj = LanEnforcerAllowLegacyClientObject.newInstance(this.lan);
        }
        obj.setEnabled(isEnabled);
    }

    public LanEnforcerEnableLocalAuthenticationObject getEnableLocalAuthenticationObject() {
        LanEnableLocalAuth schema = this.lan.getOptLanEnableLocalAuth();
        if (schema == null) {
            return null;
        }
        return new LanEnforcerEnableLocalAuthenticationObject(schema);
    }

    public void setEnableLocalAuthenticationObject(boolean isEnabled) {
        LanEnforcerEnableLocalAuthenticationObject obj = this.getEnableLocalAuthenticationObject();
        if (obj == null) {
            obj = LanEnforcerEnableLocalAuthenticationObject.newInstance(this.lan);
        }
        obj.setEnabled(isEnabled);
    }

    public EnableNetworkTimeProtocolObject getEnableNetworkTimeProtocolObject() {
        EnableNetworkTimeProtocol schema = this.lan.getOptEnableNetworkTimeProtocol();
        if (schema == null) {
            return null;
        }
        return new EnableNetworkTimeProtocolObject(schema);
    }

    public void setEnableNetworkTimeProtocolObject(boolean isEnabled) {
        EnableNetworkTimeProtocolObject obj = this.getEnableNetworkTimeProtocolObject();
        if (obj == null) {
            obj = EnableNetworkTimeProtocolObject.newInstance(this.lan);
        }
        obj.setEnabled(isEnabled);
    }

    public void setEnableNetworkTimeProtocolNPTServerObject(String value) {
        EnableNetworkTimeProtocolObject obj = this.getEnableNetworkTimeProtocolObject();
        if (obj == null) {
            obj = EnableNetworkTimeProtocolObject.newInstance(this.lan);
        }
        obj.setNtpServer(value);
    }

    public EnforcerSEPMHealthCheckObject getEnforcerSEPMHealthCheckObject() {
        SEPMHealthCheck schema = this.lan.getOptSEPMHealthCheck();
        if (schema == null) {
            return null;
        }
        return new EnforcerSEPMHealthCheckObject(schema);
    }

    public void setEnforcerSEPMHealthCheckEnable(boolean isEnabled) {
        EnforcerSEPMHealthCheckObject obj = this.getEnforcerSEPMHealthCheckObject();
        if (obj == null) {
            obj = EnforcerSEPMHealthCheckObject.newInstance(this.lan);
        }
        obj.setEnabled(isEnabled);
    }

    public void setEnforcerSEPMHealthCheckTime(Integer value) {
        EnforcerSEPMHealthCheckObject obj = this.getEnforcerSEPMHealthCheckObject();
        if (obj == null) {
            obj = EnforcerSEPMHealthCheckObject.newInstance(this.lan);
        }
        obj.setHealthCheckTime(value);
    }

    public LanNetworkPolicyServerObject getLanEnforcerNetworkPolicyServerObject() {
        LanNetworkPolicyServer schema = this.lan.getOptLanNetworkPolicyServer();
        if (schema == null) {
            return null;
        }
        return new LanNetworkPolicyServerObject(schema);
    }

    public void setLanEnforcerNetworkPolicyServerObject(boolean isEnabled) {
        LanNetworkPolicyServerObject obj = this.getLanEnforcerNetworkPolicyServerObject();
        if (obj == null) {
            obj = LanNetworkPolicyServerObject.newInstance(this.lan);
        }
        obj.setEnabled(isEnabled);
    }

    public void deleteSwitchEnforcementPolicies() {
        DataobjectManager manager = DataobjectManager.getInstance();
        List<SeSwitchEnforcementPolicy> sePolicies = this.getSwitchEnforcementPolicies();
        try {
            for (int i = 0; i < sePolicies.size(); ++i) {
                manager.deleteSeSwitchEnforcementPolicy(sePolicies.get(i));
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void deleteRadiusServerGroups(SiteObject site) {
        RadiusServerGroupPoolObject groupPoolObject = site.getRadiusServerGroupPoolObject(true);
        groupPoolObject.deleteRadiusServerGroup(this.getRadiusServerGroups());
    }
}

