/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.table.LanDeviceExcluded;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.Utility;

public class LanDeviceExcludedObject
extends AbstractUIObject {
    public static final Integer MAC_ADDRESS_MODE = 0;
    public static final Integer IP_ADDRESS_MODE = 1;
    public static final Integer IP_RANGE_MODE = 2;
    public static final Integer IP_SUBNET_MODE = 3;
    private LanDeviceExcluded lanDevice;

    public LanDeviceExcludedObject(LanDeviceExcluded lanDevice) {
        this.lanDevice = lanDevice;
    }

    public LanDeviceExcludedObject(String hashId, Integer mode, String address) {
        this.lanDevice = new LanDeviceExcluded();
        this.lanDevice.setExcludedId(new GUIDGenerator().getGUIDString());
        this.lanDevice.setHash(hashId);
        this.lanDevice.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.lanDevice.setUSN(Long.valueOf(0L));
        this.lanDevice.setDeleted(Integer.valueOf(0));
        if (mode.equals(MAC_ADDRESS_MODE)) {
            this.lanDevice.setOptMacAddress(address);
        } else if (mode.equals(IP_ADDRESS_MODE)) {
            try {
                this.lanDevice.setOptIpAddress(Utility.getIpAddressAsBytes((String)address));
            }
            catch (Exception ex) {
                System.err.println("LanDeviceExcludedObject->Constructor1: Can't set IP address.");
            }
        }
        this.lanDevice.setExcludeMode(mode);
    }

    public LanDeviceExcludedObject(String hashId, Integer mode, String addr1, String addr2) {
        this.lanDevice = new LanDeviceExcluded();
        this.lanDevice.setExcludedId(new GUIDGenerator().getGUIDString());
        this.lanDevice.setHash(hashId);
        this.lanDevice.setTimeStamp(Long.valueOf(TimeUtil.getServerTime()));
        this.lanDevice.setUSN(Long.valueOf(0L));
        this.lanDevice.setDeleted(Integer.valueOf(0));
        try {
            if (mode.equals(IP_RANGE_MODE)) {
                this.lanDevice.setOptIpRangeStart(Utility.getIpAddressAsBytes((String)addr1));
                this.lanDevice.setOptIpRangeEnd(Utility.getIpAddressAsBytes((String)addr2));
            } else if (mode.equals(IP_SUBNET_MODE)) {
                this.lanDevice.setOptIpAddress(Utility.getIpAddressAsBytes((String)addr1));
                this.lanDevice.setOptSubnetMask(Long.valueOf(Utility.getIpLong((String)addr2)));
            }
        }
        catch (Exception ex) {
            System.err.println("LanDeviceExcludedObject->Constructor2: Can't set IP range/subnet address.");
        }
        this.lanDevice.setExcludeMode(mode);
    }

    public LanDeviceExcluded getLanDeviceExcluded() {
        return this.lanDevice;
    }

    public String getDisplayIpAddress() {
        Integer mode = this.lanDevice.getExcludeMode();
        if (mode.equals(IP_ADDRESS_MODE)) {
            return Utility.getIpAddressLiteral((byte[])this.lanDevice.getOptIpAddress());
        }
        if (mode.equals(IP_RANGE_MODE)) {
            byte[] start = this.lanDevice.getOptIpRangeStart();
            byte[] end = this.lanDevice.getOptIpRangeEnd();
            return Utility.getIpAddressLiteral((byte[])start) + "-" + Utility.getIpAddressLiteral((byte[])end);
        }
        if (mode.equals(IP_SUBNET_MODE)) {
            byte[] ip = this.lanDevice.getOptIpAddress();
            long mask = this.lanDevice.getOptSubnetMask();
            return Utility.getIpAddressLiteral((byte[])ip) + "/" + Utility.getIPString((long)mask);
        }
        return "";
    }

    public String getHash() {
        return this.lanDevice.getHash();
    }

    public String getMacAddress() {
        return this.lanDevice.getExcludeMode().equals(MAC_ADDRESS_MODE) ? this.lanDevice.getOptMacAddress() : "";
    }
}

