/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IpAddressRangeSubNetObject {
    public static final int IP_ADDRESS = 0;
    public static final int IP_RANGE = 1;
    public static final int IP_SUBNET = 2;
    private Object address;
    private boolean isEnabled;
    private int addressType;

    public IpAddressRangeSubNetObject(Object address) {
        this.address = address;
        this.addressType = address instanceof IpAddress ? 0 : (address instanceof IpRange ? 1 : 2);
        this.isEnabled = this.initializeEnabled(address);
    }

    public IpAddressRangeSubNetObject(int addressType, boolean isEnabled, String comment, String firstAddress, String secondAddress) {
        this.addressType = addressType;
        this.isEnabled = isEnabled;
        switch (addressType) {
            case 0: {
                this.address = new IpAddress();
                break;
            }
            case 1: {
                this.address = new IpRange();
                break;
            }
            default: {
                this.address = new SubNet();
            }
        }
        this.setComment(comment);
        this.setFirstAddress(firstAddress);
        this.setSecondAddress(secondAddress);
    }

    public static IpAddressRangeSubNetObject newInstance(Object address) {
        return new IpAddressRangeSubNetObject(address);
    }

    public static IpAddressRangeSubNetObject newInstance(int addressType, boolean isEnabled, String comment, String firstAddress, String secondAddress) {
        return new IpAddressRangeSubNetObject(addressType, isEnabled, comment, firstAddress, secondAddress);
    }

    public static String checkExcludedIpAddress(IpAddressRangeSubNetObject currentIp, HashMap<String, ArrayList<IpAddressRangeSubNetObject>> sgRanges) {
        if (sgRanges == null) {
            return null;
        }
        for (Map.Entry<String, ArrayList<IpAddressRangeSubNetObject>> entry : sgRanges.entrySet()) {
            String name = entry.getKey();
            ArrayList<IpAddressRangeSubNetObject> ipSet = entry.getValue();
            for (IpAddressRangeSubNetObject ip : ipSet) {
                if (currentIp.isExcluded(ip)) continue;
                return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "IpAddressRangeSubNetObject.ErrorConflict"), currentIp.getAddressString(), ip.getAddressString(), name);
            }
        }
        return null;
    }

    protected Object getAddress() {
        Boolean isEnable = this.isEnabled;
        switch (this.addressType) {
            case 0: {
                ((IpAddress)this.address).setOptEnable(isEnable);
                break;
            }
            case 1: {
                ((IpRange)this.address).setOptEnable(isEnable);
                break;
            }
            default: {
                ((SubNet)this.address).setOptEnable(isEnable);
            }
        }
        return this.address;
    }

    private boolean initializeEnabled(Object address) {
        Boolean enable;
        switch (this.addressType) {
            case 0: {
                enable = ((IpAddress)address).getOptEnable();
                if (enable != null) break;
                enable = ((IpAddress)address).getDefEnable();
                break;
            }
            case 1: {
                enable = ((IpRange)address).getOptEnable();
                if (enable != null) break;
                enable = ((IpRange)address).getDefEnable();
                break;
            }
            default: {
                enable = ((SubNet)address).getOptEnable();
                if (enable != null) break;
                enable = ((SubNet)address).getDefEnable();
            }
        }
        return enable;
    }

    public String getAddressString() {
        switch (this.addressType) {
            case 0: {
                return this.getFirstAddress();
            }
            case 1: {
                return this.getFirstAddress() + "-" + this.getSecondAddress();
            }
        }
        return this.getFirstAddress() + "/" + this.getSecondAddress();
    }

    public List<String> getAddressStringAsIpRange() {
        ArrayList<String> address = new ArrayList<String>();
        String firstAddress = this.getFirstAddress();
        String secondAddress = this.getSecondAddress();
        switch (this.addressType) {
            case 0: {
                address.add(firstAddress);
                address.add(firstAddress);
                break;
            }
            case 1: {
                address.add(firstAddress);
                address.add(secondAddress);
                break;
            }
            default: {
                long ip = Utility.getIpLong((String)firstAddress);
                long mask = Utility.getIpLong((String)secondAddress);
                long start = ip & mask;
                long remainMask = start ^ mask;
                long end = remainMask ^ Utility.getIpLong((String)"255.255.255.255");
                address.add(Utility.getIPString((long)start));
                address.add(Utility.getIPString((long)end));
            }
        }
        return address;
    }

    public boolean isExcluded(IpAddressRangeSubNetObject ip) {
        List<String> curRange = this.getAddressStringAsIpRange();
        long curStart = Utility.getIpLong((String)curRange.get(0));
        long curEnd = Utility.getIpLong((String)curRange.get(1));
        List<String> ipRange = ip.getAddressStringAsIpRange();
        long ipStart = Utility.getIpLong((String)ipRange.get(0));
        long ipEnd = Utility.getIpLong((String)ipRange.get(1));
        return curStart < ipStart && curEnd < ipStart || curStart > ipEnd && curEnd > ipEnd;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getComment() {
        String comment = null;
        switch (this.addressType) {
            case 0: {
                comment = ((IpAddress)this.address).getOptComment();
                break;
            }
            case 1: {
                comment = ((IpRange)this.address).getOptComment();
                break;
            }
            default: {
                comment = ((SubNet)this.address).getOptComment();
            }
        }
        return comment == null ? "" : comment;
    }

    public String getFirstAddress() {
        String firstAddress = null;
        switch (this.addressType) {
            case 0: {
                firstAddress = ((IpAddress)this.address).getContent();
                break;
            }
            case 1: {
                firstAddress = ((IpRange)this.address).getStart();
                break;
            }
            default: {
                firstAddress = ((SubNet)this.address).getNetAddr();
            }
        }
        return firstAddress == null ? "" : firstAddress;
    }

    public String getSecondAddress() {
        String secondAddress = null;
        switch (this.addressType) {
            case 0: {
                return "";
            }
            case 1: {
                secondAddress = ((IpRange)this.address).getEnd();
                break;
            }
            default: {
                secondAddress = ((SubNet)this.address).getNetMask();
            }
        }
        return secondAddress == null ? "" : secondAddress;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setFirstAddress(String addr) {
        if (!addr.equals(this.getFirstAddress())) {
            switch (this.addressType) {
                case 0: {
                    ((IpAddress)this.address).setContent(addr);
                    break;
                }
                case 1: {
                    ((IpRange)this.address).setStart(addr);
                    break;
                }
                default: {
                    ((SubNet)this.address).setNetAddr(addr);
                }
            }
        }
    }

    public void setComment(String comment) {
        if (!comment.equals(this.getComment())) {
            switch (this.addressType) {
                case 0: {
                    ((IpAddress)this.address).setOptComment(comment);
                    break;
                }
                case 1: {
                    ((IpRange)this.address).setOptComment(comment);
                    break;
                }
                default: {
                    ((SubNet)this.address).setOptComment(comment);
                }
            }
        }
    }

    public void setSecondAddress(String addr) {
        if (!addr.equals(this.getSecondAddress())) {
            switch (this.addressType) {
                case 0: {
                    break;
                }
                case 1: {
                    ((IpRange)this.address).setEnd(addr);
                    break;
                }
                default: {
                    ((SubNet)this.address).setNetMask(addr);
                }
            }
        }
    }
}

