/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.Util;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.IDS;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class IDSObject
extends AbstractUIObject {
    public static final long SYSTEM = 1L;
    private IDS _ids;
    private LicenseObject licenseObj = LicenseObject.getInstance();

    public IDSObject(IDS ids) {
        this._ids = ids;
    }

    public void addStreamPolicy(IdsPolicy ip) {
        if (this._ids == null) {
            this._ids = new IDS();
        }
        ObjReference objRef = new ObjReference();
        objRef.setTargetId(ip.getId());
        objRef.setTargetType(ip.getObjectTypeName());
        objRef.setName("IDSPolicyApplied");
        this._ids.addObjReference(objRef);
    }

    public void clearStreamPolicy() {
        if (this._ids != null) {
            Vector objReferences = this._ids.getObjReference();
            int count = objReferences.size();
            for (int i = 0; i < count; ++i) {
                ObjReference objRef = (ObjReference)objReferences.get(i);
                String targetType = objRef.getTargetType();
                if (!"IdsPolicy".equals(targetType)) continue;
                this._ids.removeObjReference(objRef);
            }
        }
    }

    private boolean isNewReference(String id) {
        if (this._ids != null) {
            Vector refs = this._ids.getObjReference();
            for (int i = 0; i < refs.size(); ++i) {
                if (!id.equals(((ObjReference)refs.get(i)).getTargetId())) continue;
                return false;
            }
        }
        return true;
    }

    public IDS getIDS() {
        return this._ids;
    }

    public String getStreamPolicyID() {
        if (this._ids != null) {
            Vector objReferences = this._ids.getObjReference();
            int count = objReferences.size();
            for (int i = 0; i < count; ++i) {
                ObjReference objRef = (ObjReference)objReferences.get(i);
                String targetType = objRef.getTargetType();
                if (!"IdsPolicy".equals(targetType)) continue;
                return objRef.getTargetId();
            }
        }
        return null;
    }

    public void setEnable(boolean enableLib, FwIdsLibrary idsLibrary) {
        this.setEnable((Boolean)enableLib, idsLibrary);
    }

    public void setEnable(Boolean enableLib, FwIdsLibrary idsLibrary) {
        if (this._ids == null) {
            this._ids = new IDS();
        }
        if (enableLib == null) {
            return;
        }
        boolean enable = enableLib;
        if (enable) {
            String id = idsLibrary.getId();
            if (this.isNewReference(id)) {
                ObjReference objRef = new ObjReference();
                objRef.setTargetId(id);
                objRef.setTargetType(idsLibrary.getObjectTypeName());
                objRef.setName("IDSLibApplied");
                this._ids.addObjReference(objRef);
            }
        } else {
            Vector objReferences = this._ids.getObjReference();
            String id = idsLibrary.getId();
            int count = objReferences.size();
            for (int i = 0; i < count; ++i) {
                ObjReference objRef = (ObjReference)objReferences.get(i);
                String targetId = objRef.getTargetId();
                if (!id.equals(targetId)) continue;
                this._ids.removeObjReference(objRef);
            }
        }
    }

    public List<String> getAllPacketIDs() {
        ArrayList<String> result = new ArrayList<String>();
        if (this._ids == null) {
            return result;
        }
        Vector objReferences = this._ids.getObjReference();
        int count = objReferences.size();
        for (int i = 0; i < count; ++i) {
            ObjReference objRef = (ObjReference)objReferences.get(i);
            result.add(objRef.getTargetId());
        }
        return result;
    }

    public Boolean isExisting(String ID) {
        if (this._ids == null) {
            return false;
        }
        Vector objReferences = this._ids.getObjReference();
        int count = objReferences.size();
        for (int i = 0; i < count; ++i) {
            ObjReference objRef = (ObjReference)objReferences.get(i);
            String targetId = objRef.getTargetId();
            if (!ID.equals(targetId)) continue;
            return true;
        }
        return false;
    }

    public String getSerialNumber() {
        if (this._ids != null) {
            try {
                String systemVersion = null;
                Vector<TopLevelObject> allIds = new Vector<TopLevelObject>();
                Vector allRef = this._ids.getObjReference();
                for (ObjReference objRef : allRef) {
                    TopLevelObject obj = PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
                    if (!(obj instanceof FwIdsLibrary)) continue;
                    allIds.add(obj);
                    FwIdsLibrary fil = (FwIdsLibrary)obj;
                    Long attribute = fil.getOptObjAttributes();
                    if (attribute == null || attribute != 1L) continue;
                    systemVersion = fil.getVersion();
                }
                if (allIds.size() == 0) {
                    return null;
                }
                String checksum = Util.getChecksum(allIds);
                Object serialNumber = "";
                if (systemVersion != null) {
                    serialNumber = systemVersion + "-";
                }
                if (checksum != null) {
                    serialNumber = (String)serialNumber + checksum.substring(0, 4);
                }
                return serialNumber;
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        return null;
    }

    public boolean getEnabled() {
        Vector refs;
        return this._ids != null && (refs = this._ids.getObjReference()).size() > 0;
    }

    public boolean isShowIds() {
        boolean enableIds = this.licenseObj.isIntrusionPreventionEnabled();
        if (enableIds) {
            return true;
        }
        return this.getEnabled();
    }
}

