/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.schema.ICMPRequest;

public final class ICMPReqUtils {
    public static final int ICMP_PING_ANY = 0;
    public static final int IMCP_PING_ALL = 1;
    public static final int IMCP_NOT_PING_ANY = 2;
    public static final int IMCP_NOT_PING_ALL = 3;

    private ICMPReqUtils() {
    }

    public static boolean isStrNullOrEmpry(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static Integer[] getModeAndOperator(int type) {
        Integer[] ret = new Integer[2];
        switch (type) {
            case 0: {
                ret[0] = ICMPRequest.MATCH_ANY_HOST_ADDR;
                ret[1] = ICMPRequest.EQUAL;
                break;
            }
            case 1: {
                ret[0] = ICMPRequest.MATCH_ALL_HOST_ADDR;
                ret[1] = ICMPRequest.EQUAL;
                break;
            }
            case 2: {
                ret[0] = ICMPRequest.MATCH_ALL_HOST_ADDR;
                ret[1] = ICMPRequest.NOT_EQUAL;
                break;
            }
            case 3: {
                ret[0] = ICMPRequest.MATCH_ANY_HOST_ADDR;
                ret[1] = ICMPRequest.NOT_EQUAL;
                break;
            }
        }
        return ret;
    }

    public static int getRdButtonStatus(Integer opera, Integer mode) {
        int ret = 0;
        if (opera == null || mode == null) {
            return ret;
        }
        if (opera.compareTo(ICMPRequest.EQUAL) == 0 && mode.compareTo(ICMPRequest.MATCH_ANY_HOST_ADDR) == 0) {
            ret = 0;
        } else if (opera.compareTo(ICMPRequest.EQUAL) == 0 && mode.compareTo(ICMPRequest.MATCH_ALL_HOST_ADDR) == 0) {
            ret = 1;
        } else if (opera.compareTo(ICMPRequest.NOT_EQUAL) == 0 && mode.compareTo(ICMPRequest.MATCH_ALL_HOST_ADDR) == 0) {
            ret = 2;
        } else if (opera.compareTo(ICMPRequest.NOT_EQUAL) == 0 && mode.compareTo(ICMPRequest.MATCH_ANY_HOST_ADDR) == 0) {
            ret = 3;
        }
        return ret;
    }
}

