/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.table.SemComputer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.HostIpObject;
import com.sygate.scm.console.logicobject.OperatingSystemObject;
import com.sygate.scm.util.Utility;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class HostObject {
    SemComputer computer = null;
    private OperatingSystemObject osObj = null;
    private List<HostIpObject> nicIpList = new ArrayList<HostIpObject>();
    private static final int WRITE_FILTER_STATUS_NOT_REPORTED = 127;

    public HostObject() {
    }

    public HostObject(SemComputer computer) {
        this.computer = computer;
        this.osObj = new OperatingSystemObject(computer.getOptI18nOsKey(), computer.getOptOperationSystem());
    }

    public SemComputer getSemComputer() {
        return this.computer;
    }

    public boolean isValid() {
        return this.computer != null && this.computer.getComputerId() != null && this.computer.getComputerId().length() > 0;
    }

    public String getComputerDescription() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptComputerDescription();
    }

    public String getProcessorDisplayString() {
        if (!this.isValid()) {
            return "";
        }
        String[] patterns = new String[]{"", MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.OnlyClock"), "{1}", MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.TypeAndClock"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.NumberOnly"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.NumberAndClock"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.NumberAndType"), MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.NumberTypeAndClock")};
        int choice = 0;
        Object processorNum = "";
        Object processorType = "";
        Object processorClock = "";
        if (this.computer.getOptProcessorNum() != null && this.computer.getOptProcessorNum() > 1) {
            processorNum = (String)processorNum + this.computer.getOptProcessorNum();
            choice += 4;
        }
        if (this.computer.getOptProcessorType() != null && this.computer.getOptProcessorType().length() > 0) {
            processorType = (String)processorType + this.computer.getOptProcessorType();
            choice += 2;
        }
        if (this.computer.getOptProcessorClock() != null && this.computer.getOptProcessorClock().intValue() > 0) {
            processorClock = (String)processorClock + this.computer.getOptProcessorClock();
            ++choice;
        }
        String str = MessageFormat.format(patterns[choice], processorNum, processorType, processorClock);
        return str;
    }

    public String getMemoryDisplayString() {
        if (!this.isValid() || this.computer.getOptMemory() == null) {
            return "";
        }
        long size = this.computer.getOptMemory();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.DecimalMBFollowedByBytes"), nf.format((double)size / 1048576.0), nf.format(size));
        return str;
    }

    public String getOperatingSystem() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptOperationSystem();
    }

    public String getL10nOperatingSystem() {
        return this.osObj.getDisplayName();
    }

    public String getKernel() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptKernel();
    }

    public String getServicePack() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptServicePack();
    }

    public String getBiosVersionDisplayString() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptBiosVersion();
    }

    public String getBiosSerialNumberDisplayString() {
        if (!this.isValid()) {
            return "";
        }
        String sn = this.computer.getOptBiosSerialNumber();
        if (sn != null && !sn.equalsIgnoreCase("NULL")) {
            return sn;
        }
        return "";
    }

    public int getEWFStatus() {
        if (!this.isValid()) {
            return 127;
        }
        Integer ewf = this.computer.getOptEWF();
        return ewf;
    }

    public int getFBWFStatus() {
        if (!this.isValid()) {
            return 127;
        }
        Integer fbwf = this.computer.getOptFBWF();
        return fbwf;
    }

    public int getUWFStatus() {
        if (!this.isValid()) {
            return 127;
        }
        Integer uwf = this.computer.getOptUWF();
        return uwf;
    }

    public String getVirtualizationHostDisplayString() {
        if (!this.isValid()) {
            return "";
        }
        int hypervisor_vendor_id = this.computer.getOptHypervisorVendorID();
        if (hypervisor_vendor_id == 1) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.VendorVMware");
        }
        if (hypervisor_vendor_id == 2) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.VendorMicrosoft");
        }
        if (hypervisor_vendor_id == 3) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.VendorCitrix");
        }
        if (hypervisor_vendor_id == 4) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.VendorBochs");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.VendorUnknown");
    }

    public int getTpmDevice() {
        if (!this.isValid()) {
            return 0;
        }
        return this.computer.getOptTpmDevice() != null ? this.computer.getOptTpmDevice() : 0;
    }

    public String getTpmDeviceDisplayString() {
        int tpm = this.getTpmDevice();
        switch (tpm) {
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.IBMDevice");
            }
            case 2: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.HPDevice");
            }
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.UnknownDevice");
            }
            case 4: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.WinbondDevice");
            }
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.NoTPMDevice");
    }

    public String getDhcpServer() {
        if (!this.isValid()) {
            return "";
        }
        return Utility.getIpAddressLiteral((byte[])this.computer.getOptDhcpServer());
    }

    public String getDnsServer1() {
        if (!this.isValid()) {
            return "";
        }
        return Utility.getIpAddressLiteral((byte[])this.computer.getOptDnsServer1());
    }

    public String getDnsServer2() {
        if (!this.isValid()) {
            return "";
        }
        return Utility.getIpAddressLiteral((byte[])this.computer.getOptDnsServer2());
    }

    public String getWinsServer1() {
        if (!this.isValid()) {
            return "";
        }
        return Utility.getIPStringEx((Long)this.computer.getOptWinsServer1());
    }

    public String getWinsServer2() {
        if (!this.isValid()) {
            return "";
        }
        return Utility.getIPStringEx((Long)this.computer.getOptWinsServer2());
    }

    public ArrayList<HostIpObject> getIpList() {
        ArrayList<HostIpObject> list = new ArrayList<HostIpObject>();
        HostIpObject ip = new HostIpObject(Utility.getIpAddressLiteral((byte[])this.computer.getOptIpAddr1()), this.computer.getOptMacAddr1(), Utility.getIpAddressLiteral((byte[])this.computer.getOptGateway1()), 4 == this.computer.getOptIpAddr1().length ? Utility.convertCidrToNetmask((int)this.computer.getOptSubnetMask1()) : this.computer.getOptSubnetMask1().toString());
        if (ip.isValid()) {
            list.add(ip);
        }
        if ((ip = new HostIpObject(Utility.getIpAddressLiteral((byte[])this.computer.getOptIpAddr2()), this.computer.getOptMacAddr2(), Utility.getIpAddressLiteral((byte[])this.computer.getOptGateway2()), 4 == this.computer.getOptIpAddr2().length ? Utility.convertCidrToNetmask((int)this.computer.getOptSubnetMask2()) : this.computer.getOptSubnetMask2().toString())).isValid()) {
            list.add(ip);
        }
        if ((ip = new HostIpObject(Utility.getIpAddressLiteral((byte[])this.computer.getOptIpAddr3()), this.computer.getOptMacAddr3(), Utility.getIpAddressLiteral((byte[])this.computer.getOptGateway3()), 4 == this.computer.getOptIpAddr3().length ? Utility.convertCidrToNetmask((int)this.computer.getOptSubnetMask3()) : this.computer.getOptSubnetMask2().toString())).isValid()) {
            list.add(ip);
        }
        if ((ip = new HostIpObject(Utility.getIpAddressLiteral((byte[])this.computer.getOptIpAddr4()), this.computer.getOptMacAddr4(), Utility.getIpAddressLiteral((byte[])this.computer.getOptGateway4()), 4 == this.computer.getOptIpAddr4().length ? Utility.convertCidrToNetmask((int)this.computer.getOptSubnetMask4()) : this.computer.getOptSubnetMask4().toString())).isValid()) {
            list.add(ip);
        }
        return list;
    }

    public String getCurrentLogonUser() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptCurrentLoginUser();
    }

    public String getCurrentLogonDomain() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptCurrentLoginDomain();
    }

    public String getDiskTotalDisplayString() {
        if (!this.isValid() || this.computer.getOptDiskTotal() == null) {
            return "";
        }
        long size = this.computer.getOptDiskTotal();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String str = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.DecimalMBFollowedByBytes"), nf.format((double)size / 1048576.0), nf.format(size));
        return str;
    }

    public String getOSLanguage() {
        if (!this.isValid()) {
            return "";
        }
        return this.computer.getOptOSLanguage() != null ? MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostObject.OSLang_" + this.computer.getOptOSLanguage()) : "";
    }

    public List<HostIpObject> getNicIpList() {
        return this.nicIpList;
    }

    public void setNicIpList(List<HostIpObject> nicIpList) {
        this.nicIpList = nicIpList;
    }
}

