/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.GlobalObjectPool;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibraryPool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.HostIntegrityTemplateLibraryObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.ArrayList;
import java.util.List;

public class HostIntegrityTemplateLibraryPool
extends AbstractUIObject {
    private SemConfigRoot configRoot;
    private HiReqTemplateLibraryPool hiPool;
    private List<HostIntegrityTemplateLibraryObject> hiTemplibObjList = new ArrayList<HostIntegrityTemplateLibraryObject>();

    public HostIntegrityTemplateLibraryPool(SemConfigRoot configRoot) throws ConsoleException {
        this.configRoot = configRoot;
        this.initialize();
    }

    public static HostIntegrityTemplateLibraryPool getHiReqTemplateLibraryPool() throws ConsoleException {
        return new HostIntegrityTemplateLibraryPool(DataobjectManager.getInstance().getSemConfigRoot(true));
    }

    public HostIntegrityTemplateLibraryObject getHiTemplateLibraryObj(String platform) {
        for (HostIntegrityTemplateLibraryObject tempObj : this.hiTemplibObjList) {
            if (!tempObj.getPlatform().equalsIgnoreCase(platform)) continue;
            return tempObj;
        }
        return null;
    }

    private void initialize() throws ConsoleException {
        GlobalObjectPool globalObjPool = this.configRoot.getOptGlobalObjectPool();
        if (globalObjPool == null) {
            globalObjPool = new GlobalObjectPool();
            this.configRoot.setOptGlobalObjectPool(globalObjPool);
        }
        this.hiPool = globalObjPool.getOptHiReqTemplateLibraryPool();
        if (this.hiPool == null) {
            this.hiPool = new HiReqTemplateLibraryPool();
            globalObjPool.setOptHiReqTemplateLibraryPool(this.hiPool);
        }
        for (ObjReference obj : this.hiPool.getObjReference()) {
            HiReqTemplateLibrary lib = DataobjectManager.getInstance().getHiReqTemplateLibrary(obj.getTargetId());
            this.hiTemplibObjList.add(new HostIntegrityTemplateLibraryObject((TopLevelObject)lib));
        }
    }
}

