/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HiPredefinedReqName;
import com.sygate.scm.common.configobject.schema.HiPredefinedReqNameArray;
import com.sygate.scm.common.configobject.schema.HiPredefinedReqUpdate;
import com.sygate.scm.common.configobject.schema.HiReqTemplateLibrary;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.hi.HIOnlineHandler;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostIntegrityTemplateLibraryObject
extends AbstractUIObject
implements PolicyInt {
    private HiReqTemplateLibrary _hiReqTemplateLibrary;
    private boolean isLocalPolicy;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> changedObjSet = new HashMap<String, TopLevelObject>();
    private Map<String, TopLevelObject> deletedObjSet = new HashMap<String, TopLevelObject>();
    private static final String REGEX_HI_LIBRARY_SSEP_VERION = "^5\\.\\d+\\.\\d+\\.\\d+$";

    public HostIntegrityTemplateLibraryObject() {
    }

    public HostIntegrityTemplateLibraryObject(TopLevelObject schema) {
        this._hiReqTemplateLibrary = (HiReqTemplateLibrary)schema;
    }

    @Override
    public void clearAllObjSets() {
        this.newObjSet.clear();
        this.changedObjSet.clear();
        this.deletedObjSet.clear();
    }

    @Override
    public void addNewObj(TopLevelObject lib) {
        this.newObjSet.put(lib.getId(), lib);
    }

    @Override
    public List<PolicyInt> getDefaultQuarantinePolicies() {
        return null;
    }

    @Override
    public List<PolicyInt> getQuarantinePolicyObjList() {
        return null;
    }

    @Override
    public void setOwnerId(String ownerId) {
        MetadataAttributes mAttr = this._hiReqTemplateLibrary.getMetadataAttributes();
        if (mAttr == null) {
            mAttr = new MetadataAttributes();
            this._hiReqTemplateLibrary.setMetadataAttributes(mAttr);
        }
        mAttr.setOwner(new GUID(ownerId));
    }

    @Override
    public boolean isLocalPolicy() {
        return this.isLocalPolicy;
    }

    @Override
    public TopLevelObject getSchemaObj() {
        return this._hiReqTemplateLibrary;
    }

    @Override
    public String getLocalReferenceName() {
        return "HiReqTemplateLibrary";
    }

    @Override
    public Map<String, TopLevelObject> getDeletedObjSet() {
        return this.deletedObjSet;
    }

    @Override
    public Map<String, TopLevelObject> getNewObjSet() {
        return this.newObjSet;
    }

    @Override
    public Map<String, TopLevelObject> getChangedObjSet() {
        return this.changedObjSet;
    }

    @Override
    public String getId() {
        return this._hiReqTemplateLibrary.getId();
    }

    @Override
    public String getName() {
        return this._hiReqTemplateLibrary.getName();
    }

    public String getOptDescription() {
        return this._hiReqTemplateLibrary.getOptDescription();
    }

    public Long getOptObjAttributes() {
        return this._hiReqTemplateLibrary.getOptObjAttributes();
    }

    public String getVersion() {
        return this._hiReqTemplateLibrary.getVersion();
    }

    public long getLastModifiedTime() {
        return this._hiReqTemplateLibrary.getLastModifiedTime();
    }

    public String getPlatform() {
        return this._hiReqTemplateLibrary.getOptPlatform() == null ? this._hiReqTemplateLibrary.getDefPlatform() : this._hiReqTemplateLibrary.getOptPlatform();
    }

    @Override
    public PhysicalFileObject getPhysicalFileObject() {
        return null;
    }

    @Override
    public String getTargetName() {
        return "HiReqTemplateLibraryApplied";
    }

    @Override
    public String getTargetType() {
        return "HiReqTemplateLibrary";
    }

    @Override
    public String getIconFileName() {
        return "group_3.gif";
    }

    @Override
    public String getTypeDesc() {
        return "Sygate HI Update";
    }

    @Override
    public void setSchemaObj(TopLevelObject schObj) {
        HiReqTemplateLibrary newObj = (HiReqTemplateLibrary)schObj;
        if (this._hiReqTemplateLibrary != null && this._hiReqTemplateLibrary.getId().equals(newObj.getId())) {
            this.changedObjSet.put(newObj.getId(), (TopLevelObject)newObj);
        } else {
            this.newObjSet.put(newObj.getId(), (TopLevelObject)newObj);
        }
        this._hiReqTemplateLibrary = (HiReqTemplateLibrary)schObj;
    }

    public void setName(String name) {
        this._hiReqTemplateLibrary.setName(name);
    }

    public void setOptDescription(String desc) {
        this._hiReqTemplateLibrary.setOptDescription(desc);
    }

    public void setOptObjAttributes(long objAttr) {
        this._hiReqTemplateLibrary.setOptObjAttributes(Long.valueOf(objAttr));
    }

    public void setVersion(String version) {
        this._hiReqTemplateLibrary.setVersion(version);
    }

    public void setLastModifiedTime(long time) {
        this._hiReqTemplateLibrary.setLastModifiedTime(Long.valueOf(time));
    }

    @Override
    public void setLocalPolicy(boolean isLocal) {
        this.isLocalPolicy = isLocal;
    }

    @Override
    public boolean isPolicyExist() {
        return this._hiReqTemplateLibrary != null;
    }

    public HiPredefinedType[] getPredefinedType(Integer hiType) {
        HIOnlineHandler.getInstance().setObject(this._hiReqTemplateLibrary);
        HiPredefinedReqUpdate update = this._hiReqTemplateLibrary.getOptHiPredefinedReqUpdate();
        if (update == null) {
            return null;
        }
        String libraryVersion = this._hiReqTemplateLibrary.getVersion();
        boolean isSSEPLibrary = false;
        if (!StringUtilities.isEmpty((String)libraryVersion) && libraryVersion.matches(REGEX_HI_LIBRARY_SSEP_VERION)) {
            isSSEPLibrary = true;
        }
        ArrayList<HiPredefinedType> type = new ArrayList<HiPredefinedType>();
        HiPredefinedReqNameArray array = update.getHiPredefinedReqNameArray();
        if (array != null) {
            for (int i = 0; i < array.getHiPredefinedReqNameCount(); ++i) {
                HiPredefinedReqName reqName = array.getHiPredefinedReqName(i);
                if (!reqName.getMacroType().equals(hiType)) continue;
                String macroName = reqName.getMacroName();
                String description = HIOnlineHandler.getInstance().getI18nContent(reqName.getMacroDisplayName());
                if (isSSEPLibrary && "AV_NORTON_CORP".equals(macroName)) {
                    macroName = "AV_NORTON_CORP_SEP";
                    description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSAV");
                } else if (isSSEPLibrary && "FW_SYMANTEC_CSF".equals(macroName)) {
                    macroName = "FW_SSA_FIREWALL";
                    description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.predefined.hipredefined", "PredefinedType.HITypeSCS");
                }
                type.add(new HiPredefinedType(description, macroName));
            }
        }
        if (type.size() > 0) {
            Object[] typeArray = type.toArray(new HiPredefinedType[0]);
            Arrays.sort(typeArray);
            return typeArray;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this._hiReqTemplateLibrary.getOptDescription();
    }
}

