/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.EnforcedHiRequirementArray;
import com.sygate.scm.common.configobject.schema.HiCALL;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicyPool;
import com.sygate.scm.common.configobject.schema.HiRETURN;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import com.sygate.scm.common.configobject.schema.HiRequirementSystem;
import com.sygate.scm.common.configobject.schema.HiScript;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.hi.library.EnforceAvInfected;
import com.sygate.scm.hi.library.HiParm_EnforceAv;
import java.util.Vector;

public class HostIntegrityPolicyPool
extends AppliablePolicyPool {
    public HostIntegrityPolicyPool(SemDomain domain) throws ConsoleException {
        super(domain, 56);
    }

    public static HostIntegrityPolicyPool getHostIntegrityPolicyPool() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemDomain domain = (SemDomain)data.getObjectByGUID("SemDomain", data.getLoginInformation().getOptDomainGUID());
        return new HostIntegrityPolicyPool(domain);
    }

    @Override
    protected void addPolicyPoolReference(ConfigObject policyPool, ObjReference objRef) throws ConsoleException {
        if (!(policyPool instanceof HiHostIntegrityPolicyPool)) {
            throw new ConsoleException(302645248, 32);
        }
        ((HiHostIntegrityPolicyPool)policyPool).addObjReference(objRef);
    }

    @Override
    protected Vector<ObjReference> getPolicyPoolReferences() {
        return ((HiHostIntegrityPolicyPool)this.policyPool).getObjReference();
    }

    @Override
    protected void createSemPolicyPool() {
        this.policyPool = new HiHostIntegrityPolicyPool();
        this.domainObjPool.setOptHiHostIntegrityPolicyPool((HiHostIntegrityPolicyPool)this.policyPool);
        this.updateObjSet.put(this.domain.getId(), this.domain);
    }

    private void updateHiPolicy(PolicyObjectBase policyObj) throws ConsoleException {
        EnforcedHiRequirementArray array;
        HiRequirementSystem system;
        HiHostIntegrityPolicy policy = null;
        if (null != policyObj.policy && policyObj.policy instanceof HiHostIntegrityPolicy && null != (system = (policy = (HiHostIntegrityPolicy)policyObj.policy).getOptHiRequirementSystem()) && null != (array = system.getOptEnforcedHiRequirementArray())) {
            Vector HiRequirements = array.getHiRequirement();
            for (HiRequirement req : HiRequirements) {
                Vector blocks;
                HiScript script = req.getHiScript();
                if (null == script || null == (blocks = script.getHiScriptBlock())) continue;
                for (HiScriptBlock block : blocks) {
                    HiCALL hiCall = null;
                    HiRETURN hiReturn = block.getOptHiRETURN();
                    if (null == hiReturn || null == (hiCall = hiReturn.getOptHiCALL())) continue;
                    hiCall = this.updateHiCall(hiCall);
                }
            }
        }
    }

    private HiCALL updateHiCall(HiCALL hiCall) throws ConsoleException {
        UnknownContent content;
        if (hiCall.getFuncName().equalsIgnoreCase("EnforceAv") && null != (content = hiCall.getUnknownContent())) {
            HiParm_EnforceAv _param = null;
            try {
                ConfigObject configObject = (ConfigObject)AbstractSchema.readXML((byte[])content.getContent());
                if (configObject instanceof HiParm_EnforceAv) {
                    _param = (HiParm_EnforceAv)configObject;
                    EnforceAvInfected avInfected = _param.getOptEnforceAvInfected();
                    if (_param.getOptAvTypeString().equalsIgnoreCase("AV_NORTON_CORP_SEP")) {
                        if (null == avInfected) {
                            avInfected = new EnforceAvInfected();
                            _param.setOptEnforceAvInfected(avInfected);
                            UnknownContent temp = new UnknownContent(true);
                            temp.setConent(_param.getBytes());
                            hiCall.setUnknownContent(temp);
                        }
                    } else if (avInfected != null) {
                        _param.setOptEnforceAvInfected(new EnforceAvInfected());
                        UnknownContent temp = new UnknownContent(true);
                        temp.setConent(_param.getBytes());
                        hiCall.setUnknownContent(temp);
                    }
                }
            }
            catch (Exception e) {
                throw new ConsoleException(e);
            }
        }
        return hiCall;
    }

    @Override
    protected boolean updatePolicyAndPhysicalFileAndLog(PolicyObjectBase policyObj) throws ConsoleException {
        this.updateHiPolicy(policyObj);
        return super.updatePolicyAndPhysicalFileAndLog(policyObj);
    }
}

