/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.EnforcedHiRequirementArray;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.HiNotification;
import com.sygate.scm.common.configobject.schema.HiNotificationOnFailure;
import com.sygate.scm.common.configobject.schema.HiNotificationOnPassAfterFailure;
import com.sygate.scm.common.configobject.schema.HiNotificationOnSnooze;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import com.sygate.scm.common.configobject.schema.HiRequirementSystem;
import com.sygate.scm.common.configobject.schema.HiSnooze;
import com.sygate.scm.common.configobject.schema.HostIntegritySetting;
import com.sygate.scm.common.configobject.schema.HostIntegrityTrigger;
import com.sygate.scm.common.configobject.schema.MacHiRequirementSystem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.HiRequirementObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.QuarantineFirewallObject;
import com.sygate.scm.console.logicobject.QuarantineOSPObject;
import com.sygate.scm.console.ui.policy.av.logicobject.QuarantineAvPolicyObject;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.ids.logicobject.QuarantineIdsPolicyObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.QuarantineLuPolicyObject;
import com.sygate.scm.console.ui.policy.mem.logicobject.QuarantineMemPolicyObject;
import com.sygate.scm.console.ui.policy.ntr.logicobject.QuarantineNtrPolicyObject;
import com.sygate.scm.console.ui.policy.override.logicobject.QuarantineOverridePolicyObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class HostIntegrityObject
extends PolicyIntObjectBase {
    private HostIntegrityTrigger _trigger;
    private HostIntegritySetting _setting;
    private PhysicalFileObject physicalFileObject;

    public HostIntegrityObject() {
    }

    public HostIntegrityObject(TopLevelObject policy) {
        super(policy);
        this.initialize((HiHostIntegrityPolicy)policy);
    }

    public void createNewHostIntegrityByDefault() throws ConsoleException {
        this.policy = this.createHostIntegrityByDefault();
        this.initialize((HiHostIntegrityPolicy)this.policy);
        this.addNewObj(this.policy);
    }

    public void createNewHostIntegrity() {
        this.policy = this.createHostIntegrity();
        this.initialize((HiHostIntegrityPolicy)this.policy);
        this.addNewObj(this.policy);
    }

    public void addRequirement(HiRequirementObject newReq) {
        HiRequirement require = newReq.getHiRequirement();
        EnforcedHiRequirementArray enforceArray = this.getEnforcedArrayFromHiReq(require);
        enforceArray.addHiRequirement(require);
        this.addChangedObj(this.policy);
    }

    public void replaceRequirement(HiRequirementObject reqObj, HiRequirementObject newObj) {
        HiRequirement old = reqObj.getHiRequirement();
        EnforcedHiRequirementArray enforceArray = this.getEnforcedArrayFromHiReq(old);
        int index = enforceArray.getHiRequirement().indexOf(old);
        if (index != -1) {
            enforceArray.setHiRequirement(index, newObj.getHiRequirement());
        } else {
            enforceArray.addHiRequirement(newObj.getHiRequirement());
        }
        this.addChangedObj(this.policy);
    }

    public void moveDownRequirement(HiRequirementObject reqObj) {
        HiRequirement old = reqObj.getHiRequirement();
        EnforcedHiRequirementArray enforceArray = this.getEnforcedArrayFromHiReq(old);
        int index = enforceArray.getHiRequirement().indexOf(old);
        if (index != -1 && index < enforceArray.getHiRequirementCount() - 1) {
            enforceArray.removeHiRequirement(old);
            enforceArray.addHiRequirement(index + 1, old);
            this.addChangedObj(this.policy);
        }
    }

    public void moveUpRequirement(HiRequirementObject reqObj) {
        HiRequirement old = reqObj.getHiRequirement();
        EnforcedHiRequirementArray enforceArray = this.getEnforcedArrayFromHiReq(old);
        int index = enforceArray.getHiRequirement().indexOf(old);
        if (index != -1 && index > 0) {
            enforceArray.removeHiRequirement(old);
            enforceArray.addHiRequirement(index - 1, old);
            this.addChangedObj(this.policy);
        }
    }

    public void deleteRequirement(HiRequirementObject curRequire) {
        this.deleteRequirement(curRequire.getHiRequirement());
    }

    public void deleteRequirement(HiRequirement require) {
        require.getParent().removeChild((AbstractSchema)require);
        this.addChangedObj(this.policy);
    }

    public boolean checkRequirementName(String newName, HiRequirementObject reqObj) {
        HiRequirement curReq = reqObj.getHiRequirement();
        String osType = curReq.getOptReqOsType();
        if (StringUtilities.isEmpty((String)osType)) {
            osType = curReq.getDefReqOsType();
        }
        List<HiRequirement> requirements = null;
        if ("Mac".equalsIgnoreCase(osType)) {
            requirements = this.getAllMacHiRequirements();
            for (HiRequirement req : requirements) {
                if (!this.isReqNameExisted(req, curReq, newName)) continue;
                return false;
            }
            return true;
        }
        requirements = this.getAllWindowsHiRequirements();
        for (HiRequirement req : requirements) {
            if (!this.isReqNameExisted(req, curReq, newName)) continue;
            return false;
        }
        return true;
    }

    public List<HiRequirementObject> getAllWindowsReqWithoutCancelableTable() {
        ArrayList<HiRequirementObject> ret = new ArrayList<HiRequirementObject>();
        List<HiRequirement> requirements = this.getAllWindowsHiRequirements();
        for (HiRequirement req : requirements) {
            ret.add(new HiRequirementObject(req));
        }
        return ret;
    }

    public List<HiRequirementObject> getAllMacReqWithoutCancelableTable() {
        ArrayList<HiRequirementObject> ret = new ArrayList<HiRequirementObject>();
        List<HiRequirement> requirements = this.getAllMacHiRequirements();
        for (HiRequirement req : requirements) {
            ret.add(new HiRequirementObject(req));
        }
        return ret;
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof HiHostIntegrityPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        return new HostIntegrityObject(policyObj);
    }

    private void initialize(HiHostIntegrityPolicy policy) {
        this._trigger = policy.getHostIntegrityTrigger();
        this._setting = policy.getHostIntegritySetting();
    }

    private HiHostIntegrityPolicy createHostIntegrity() {
        HiHostIntegrityPolicy policy = new HiHostIntegrityPolicy();
        String GUIDString = new GUIDGenerator().getGUIDString();
        policy.setId(GUIDString);
        policy.setName("");
        HostIntegrityTrigger trigger = new HostIntegrityTrigger();
        policy.setHostIntegrityTrigger(trigger);
        HostIntegritySetting setting = new HostIntegritySetting();
        policy.setHostIntegritySetting(setting);
        MetadataAttributes mattr = new MetadataAttributes();
        policy.setMetadataAttributes(mattr);
        return policy;
    }

    private HiHostIntegrityPolicy createHostIntegrityByDefault() throws ConsoleException {
        HiHostIntegrityPolicy policy;
        try {
            policy = PolicyHandler.getDefaultHostIntegrityPolicy(this.getNewObjSet());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            throw new ConsoleException(ex);
        }
        MetadataAttributes mattr = new MetadataAttributes();
        if (policy != null) {
            policy.setMetadataAttributes(mattr);
        }
        return policy;
    }

    private HiSnooze getHiSnooze() {
        HiSnooze snooze = this._setting.getOptHiSnooze();
        if (snooze == null) {
            snooze = new HiSnooze();
            snooze.setOptEnable(Boolean.valueOf(false));
            snooze.setMinimumTime(Long.valueOf(120L));
            this._setting.setOptHiSnooze(snooze);
        }
        return snooze;
    }

    private HiNotificationOnFailure getHiFailNotification() {
        HiNotificationOnFailure onFailure;
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification == null) {
            notification = new HiNotification();
            this._setting.setOptHiNotification(notification);
        }
        if ((onFailure = notification.getOptHiNotificationOnFailure()) == null) {
            onFailure = new HiNotificationOnFailure();
            notification.setOptHiNotificationOnFailure(onFailure);
        }
        return onFailure;
    }

    private HiNotificationOnPassAfterFailure getHiSuccessNotification() {
        HiNotificationOnPassAfterFailure onFailure;
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification == null) {
            notification = new HiNotification();
            this._setting.setOptHiNotification(notification);
        }
        if ((onFailure = notification.getOptHiNotificationOnPassAfterFailure()) == null) {
            onFailure = new HiNotificationOnPassAfterFailure();
            notification.setOptHiNotificationOnPassAfterFailure(onFailure);
        }
        return onFailure;
    }

    private EnforcedHiRequirementArray createEnforceArray() {
        EnforcedHiRequirementArray array = new EnforcedHiRequirementArray();
        return array;
    }

    private HiRequirementSystem createHiRequirementSystem() {
        HiRequirementSystem system = new HiRequirementSystem();
        return system;
    }

    private void addRequirementsToList(List<HiRequirement> all, EnforcedHiRequirementArray enforceArray) {
        if (enforceArray != null) {
            Vector allRequirement = enforceArray.getHiRequirement();
            for (HiRequirement require : allRequirement) {
                all.add(require);
            }
        }
    }

    private EnforcedHiRequirementArray getEnforcedArrayFromHiReq(HiRequirement req) {
        HiHostIntegrityPolicy hiPolicy = (HiHostIntegrityPolicy)this.policy;
        String osType = req.getOptReqOsType();
        EnforcedHiRequirementArray enforceArray = null;
        if ("Mac".equalsIgnoreCase(osType)) {
            MacHiRequirementSystem macSystem = hiPolicy.getOptMacHiRequirementSystem();
            if (macSystem == null) {
                macSystem = new MacHiRequirementSystem();
                hiPolicy.setOptMacHiRequirementSystem(macSystem);
            }
            if ((enforceArray = macSystem.getOptEnforcedHiRequirementArray()) == null) {
                enforceArray = this.createEnforceArray();
                macSystem.setOptEnforcedHiRequirementArray(enforceArray);
            }
        } else {
            HiRequirementSystem system = hiPolicy.getOptHiRequirementSystem();
            if (system == null) {
                system = this.createHiRequirementSystem();
                hiPolicy.setOptHiRequirementSystem(system);
            }
            if ((enforceArray = system.getOptEnforcedHiRequirementArray()) == null) {
                enforceArray = this.createEnforceArray();
                system.setOptEnforcedHiRequirementArray(enforceArray);
            }
        }
        return enforceArray;
    }

    private boolean isReqNameExisted(HiRequirement oldReq, HiRequirement curReq, String newName) {
        return !oldReq.getId().equals(curReq.getId()) && oldReq.getName().equals(newName);
    }

    private List<HiRequirement> getAllWindowsHiRequirements() {
        EnforcedHiRequirementArray enforceArray;
        HiRequirementSystem system;
        ArrayList<HiRequirement> requirements = new ArrayList<HiRequirement>();
        if (this.policy != null && (system = ((HiHostIntegrityPolicy)this.policy).getOptHiRequirementSystem()) != null && null != (enforceArray = system.getOptEnforcedHiRequirementArray())) {
            requirements.addAll(enforceArray.getHiRequirement());
        }
        return requirements;
    }

    private List<HiRequirement> getAllMacHiRequirements() {
        EnforcedHiRequirementArray enforceArray;
        MacHiRequirementSystem system;
        ArrayList<HiRequirement> requirements = new ArrayList<HiRequirement>();
        if (this.policy != null && (system = ((HiHostIntegrityPolicy)this.policy).getOptMacHiRequirementSystem()) != null && null != (enforceArray = system.getOptEnforcedHiRequirementArray())) {
            requirements.addAll(enforceArray.getHiRequirement());
        }
        return requirements;
    }

    public String getAdditionalText() {
        String str = null;
        if (this._setting.getOptHiNotification() != null && this._setting.getOptHiNotification().getOptHiNotificationOnSnooze() != null) {
            str = this._setting.getOptHiNotification().getOptHiNotificationOnSnooze().getOptAdditionalText();
        }
        return str;
    }

    public void setAdditionalText(String str) {
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification == null) {
            notification = new HiNotification();
            this._setting.setOptHiNotification(notification);
        }
        if (notification != null) {
            HiNotificationOnSnooze hiNotificationOnSnooze = notification.getOptHiNotificationOnSnooze();
            if (hiNotificationOnSnooze == null) {
                hiNotificationOnSnooze = new HiNotificationOnSnooze();
                notification.setOptHiNotificationOnSnooze(hiNotificationOnSnooze);
            }
            if (hiNotificationOnSnooze != null) {
                hiNotificationOnSnooze.setOptAdditionalText(str);
                this.setChangedObject();
            }
        }
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((HiHostIntegrityPolicy)this.policy).getOptEnable(), (Boolean)((HiHostIntegrityPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((HiHostIntegrityPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String getCreator() {
        return ((HiHostIntegrityPolicy)this.policy).getOptCreator();
    }

    @Override
    public void setCreator(String creator) {
        ((HiHostIntegrityPolicy)this.policy).setOptCreator(creator);
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HostIntegrityObject.HIPolicyDescription");
    }

    @Override
    public String getTargetType() {
        return "HiHostIntegrityPolicy";
    }

    @Override
    public String getTargetName() {
        return "HostIntegrityApplied";
    }

    @Override
    public String getRefTargetName() {
        return "SuspendedHiHostIntegrityPolicyLink";
    }

    @Override
    public void setSchemaObj(TopLevelObject policy) {
        super.setSchemaObj(policy);
        if (policy != null) {
            this.initialize((HiHostIntegrityPolicy)policy);
        }
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalHostIntegrityPolicy";
    }

    public Integer getHostIntegrityTriggerType() {
        Integer tType = this._trigger.getOptHostIntegrityTrigger();
        if (tType == null) {
            tType = this._trigger.getDefHostIntegrityTrigger();
        }
        return tType;
    }

    public boolean setHostIntegrityTriggerType(Integer newValue) {
        Integer oldValue = this.getHostIntegrityTriggerType();
        if (oldValue.equals(newValue)) {
            return false;
        }
        this._trigger.setOptHostIntegrityTrigger(newValue);
        this.setChangedObject();
        return true;
    }

    public void setDescription(String newValue) {
        String oldValue = this.getDescription();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) == 0) {
            return;
        }
        ((HiHostIntegrityPolicy)this.policy).setOptDescription(newValue);
    }

    public long getFrequency() {
        Long timer = this._trigger.getOptHostIntegrityTimer();
        if (timer != null) {
            return timer;
        }
        return 120L;
    }

    public boolean setFrequency(long newValue) {
        long oldValue = this.getFrequency();
        if (oldValue == newValue) {
            return false;
        }
        this._trigger.setOptHostIntegrityTimer(Long.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public boolean getEnableSnooze() {
        HiSnooze hiSnooze = this._setting.getOptHiSnooze();
        if (hiSnooze != null) {
            Boolean enable = hiSnooze.getOptEnable();
            if (enable != null) {
                return enable;
            }
            return true;
        }
        return false;
    }

    public boolean setEnableSnooze(boolean newValue) {
        boolean oldValue = this.getEnableSnooze();
        if (oldValue == newValue) {
            return false;
        }
        HiSnooze snooze = this.getHiSnooze();
        snooze.setOptEnable(Boolean.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public long getMinimumSnoozeTime() {
        HiSnooze hiSnooze = this._setting.getOptHiSnooze();
        if (hiSnooze != null) {
            return hiSnooze.getMinimumTime();
        }
        return 120L;
    }

    public boolean setMinimumSnoozeTime(long newValue) {
        long oldValue = this.getMinimumSnoozeTime();
        if (oldValue == newValue) {
            return false;
        }
        HiSnooze snooze = this.getHiSnooze();
        snooze.setMinimumTime(Long.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public long getMaximumSnoozeTime() {
        Long max;
        HiSnooze hiSnooze = this._setting.getOptHiSnooze();
        if (hiSnooze != null && (max = hiSnooze.getOptMaximumTime()) != null) {
            return max;
        }
        return Long.MAX_VALUE;
    }

    public boolean setMaximumSnoozeTime(long newValue) {
        long oldValue = this.getMaximumSnoozeTime();
        if (oldValue == newValue) {
            return false;
        }
        HiSnooze snooze = this.getHiSnooze();
        snooze.setOptMaximumTime(Long.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public long getCancelTime() {
        Long cancel;
        HiSnooze hiSnooze = this._setting.getOptHiSnooze();
        if (hiSnooze != null && (cancel = hiSnooze.getOptMaxCancellation()) != null) {
            return cancel;
        }
        return -1L;
    }

    public boolean setCancelTime(long newValue) {
        long oldValue = this.getCancelTime();
        if (oldValue == newValue) {
            return false;
        }
        HiSnooze snooze = this.getHiSnooze();
        if (newValue == -1L) {
            snooze.setOptMaxCancellation(null);
        } else {
            snooze.setOptMaxCancellation(Long.valueOf(newValue));
        }
        this.setChangedObject();
        return true;
    }

    public boolean getContinue() {
        Boolean isContinue = this._setting.getOptContinueExecWhenOneFailed();
        if (isContinue != null) {
            return isContinue;
        }
        return false;
    }

    public boolean setContinue(boolean newValue) {
        boolean oldValue = this.getContinue();
        if (oldValue == newValue) {
            return false;
        }
        this._setting.setOptContinueExecWhenOneFailed(Boolean.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public long getHistoryTime() {
        Long time = this._setting.getOptMaxHistoryTime();
        if (time != null) {
            return time;
        }
        return this._setting.getDefMaxHistoryTime();
    }

    public boolean setHistoryTime(long newValue) {
        long oldValue = this.getHistoryTime();
        if (oldValue == newValue) {
            return false;
        }
        this._setting.setOptMaxHistoryTime(Long.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public boolean getUserLogonRequired() {
        Boolean logonRequired = this._setting.getOptUserLogonRequired();
        if (logonRequired == null) {
            logonRequired = this._setting.getDefUserLogonRequired();
        }
        return logonRequired;
    }

    public boolean setUserLogonRequired(boolean newValue) {
        boolean oldValue = this.getUserLogonRequired();
        if (oldValue == newValue) {
            return false;
        }
        this._setting.setOptUserLogonRequired(Boolean.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public boolean getEnableFailPopup() {
        HiNotificationOnFailure onFailure;
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification != null && (onFailure = notification.getOptHiNotificationOnFailure()) != null) {
            Boolean enable = onFailure.getOptEnable();
            if (enable == null) {
                enable = onFailure.getDefEnable();
            }
            return enable;
        }
        return false;
    }

    public boolean setEnableFailPopup(boolean newValue) {
        boolean oldValue = this.getEnableFailPopup();
        if (oldValue == newValue) {
            return false;
        }
        HiNotificationOnFailure notification = this.getHiFailNotification();
        notification.setOptEnable(Boolean.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public String getFailExtraText() {
        HiNotificationOnFailure onFail;
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification != null && (onFail = notification.getOptHiNotificationOnFailure()) != null) {
            return onFail.getOptAdditionalText();
        }
        return null;
    }

    public boolean setFailExtraText(String newValue) {
        String oldValue = this.getFailExtraText();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) == 0) {
            return false;
        }
        HiNotificationOnFailure notification = this.getHiFailNotification();
        notification.setOptAdditionalText(newValue);
        this.setChangedObject();
        return true;
    }

    public boolean getEnableSuccessPopup() {
        HiNotificationOnPassAfterFailure onFailure;
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification != null && (onFailure = notification.getOptHiNotificationOnPassAfterFailure()) != null) {
            Boolean enable = onFailure.getOptEnable();
            if (enable == null) {
                enable = onFailure.getDefEnable();
            }
            return enable;
        }
        return false;
    }

    public boolean setEnableSuccessPopup(boolean newValue) {
        boolean oldValue = this.getEnableSuccessPopup();
        if (oldValue == newValue) {
            return false;
        }
        HiNotificationOnPassAfterFailure notification = this.getHiSuccessNotification();
        notification.setOptEnable(Boolean.valueOf(newValue));
        this.setChangedObject();
        return true;
    }

    public String getSuccessExtraText() {
        HiNotificationOnPassAfterFailure onSuccess;
        HiNotification notification = this._setting.getOptHiNotification();
        if (notification != null && (onSuccess = notification.getOptHiNotificationOnPassAfterFailure()) != null) {
            return onSuccess.getOptAdditionalText();
        }
        return null;
    }

    public boolean setSuccessExtraText(String newValue) {
        String oldValue = this.getSuccessExtraText();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) == 0) {
            return false;
        }
        HiNotificationOnPassAfterFailure notification = this.getHiSuccessNotification();
        notification.setOptAdditionalText(newValue);
        this.setChangedObject();
        return true;
    }

    public List<HiRequirement> getAllRequirmentWithoutCancelableTable() {
        ArrayList<HiRequirement> all = new ArrayList<HiRequirement>();
        if (this.policy != null) {
            MacHiRequirementSystem macSystem;
            HiRequirementSystem system = ((HiHostIntegrityPolicy)this.policy).getOptHiRequirementSystem();
            if (system != null) {
                EnforcedHiRequirementArray enforceArray = system.getOptEnforcedHiRequirementArray();
                this.addRequirementsToList(all, enforceArray);
            }
            if ((macSystem = ((HiHostIntegrityPolicy)this.policy).getOptMacHiRequirementSystem()) != null) {
                EnforcedHiRequirementArray enforceArray = macSystem.getOptEnforcedHiRequirementArray();
                this.addRequirementsToList(all, enforceArray);
            }
        }
        return all;
    }

    private void setChangedObject() {
        if (this.policy != null && this.getNewObjSet().get(this.policy.getId()) == null) {
            this.addChangedObj(this.policy);
        }
    }

    @Override
    public int getItemType() {
        return 56;
    }

    @Override
    public List<PolicyInt> getQuarantinePolicyObjList() {
        ArrayList<PolicyInt> list = new ArrayList<PolicyInt>();
        list.add(new QuarantineAvPolicyObject());
        list.add(new QuarantineFirewallObject());
        list.add(new QuarantineOSPObject());
        list.add(new QuarantineLuPolicyObject());
        list.add(new QuarantineOverridePolicyObject());
        list.add(new QuarantineIdsPolicyObject());
        list.add(new QuarantineMemPolicyObject());
        list.add(new QuarantineNtrPolicyObject());
        return list;
    }

    public void setPhysicalFileObject(PhysicalFileObject obj) {
        this.physicalFileObject = obj;
    }

    @Override
    public PhysicalFileObject getPhysicalFileObject() {
        return this.physicalFileObject;
    }

    public boolean getIsVerbose() {
        HostIntegritySetting setting = ((HiHostIntegrityPolicy)this.policy).getHostIntegritySetting();
        Boolean noverbose = setting.getOptDisableVerboseLogging();
        if (noverbose == null) {
            noverbose = setting.getDefDisableVerboseLogging();
        }
        return noverbose == false;
    }

    public boolean setVerbose(boolean newValue) {
        boolean oldValue = this.getIsVerbose();
        if (oldValue == newValue) {
            return false;
        }
        HostIntegritySetting setting = ((HiHostIntegrityPolicy)this.policy).getHostIntegritySetting();
        setting.setOptDisableVerboseLogging(Boolean.valueOf(!newValue));
        return true;
    }

    @Override
    public boolean isAnyObjectSetModified() {
        return false;
    }
}

