/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HostAddress;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.DeletableObjInt;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.util.ConsoleException;
import java.util.HashMap;

public class HostAddressObject
extends AbstractUIObject
implements DeletableObjInt,
CopitableObject {
    private boolean isHttps = false;
    HostAddress _address;

    public HostAddressObject(HostAddress address) {
        this._address = address;
    }

    public HostAddressObject() {
        this._address = new HostAddress();
    }

    public String toString() {
        Object server = this._address.getContent();
        if (server == null) {
            server = "";
        }
        if (((String)server).contains(":")) {
            server = "[" + (String)server + "]";
        }
        if (this.isHttps) {
            Integer port = this._address.getOptSecurePort();
            if (port != null) {
                server = (String)server + ":" + port.toString();
            }
        } else {
            Integer port = this._address.getOptPort();
            if (port != null) {
                server = (String)server + ":" + port.toString();
            }
        }
        return server;
    }

    public String getAddress() {
        return this._address.getContent();
    }

    public boolean setAddress(String newValue) {
        String oldValue = this.getAddress();
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue != null && oldValue.equals(newValue)) {
            return false;
        }
        this._address.setContent(newValue);
        return true;
    }

    public HostAddress getHostAddress() {
        return this._address;
    }

    public HostAddressObject getClone() throws ConsoleException {
        HostAddress newAddr = (HostAddress)PolicyHandler.getCopyOfObj((ConfigObject)this._address);
        return new HostAddressObject(newAddr);
    }

    public void setHostAddress(HostAddressObject newObj) {
        this._address = newObj.getHostAddress();
    }

    @Override
    public void delete() {
        this._address.getParent().removeChild((AbstractSchema)this._address);
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        try {
            WashIDHandler washer = new WashIDHandler();
            HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
            HostAddress newAl = (HostAddress)washer.duplicateObject((ConfigObject)this._address, createdObj);
            HostAddressObject newObj = new HostAddressObject(newAl);
            newObj.setHttps(this.isHttps);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public Integer getHttpPort() {
        return this._address.getOptPort();
    }

    public boolean setHttpPort(Integer newValue) {
        Integer oldPort = this.getHttpPort();
        if (oldPort == null && newValue == null) {
            return false;
        }
        if (oldPort != null && oldPort.equals(newValue)) {
            return false;
        }
        this._address.setOptPort(newValue);
        return true;
    }

    public Integer getHttpsPort() {
        return this._address.getOptSecurePort();
    }

    public boolean setHttpsPort(Integer newValue) {
        Integer oldPort = this.getHttpsPort();
        if (oldPort == null && newValue == null) {
            return false;
        }
        if (oldPort != null && oldPort.equals(newValue)) {
            return false;
        }
        this._address.setOptSecurePort(newValue);
        return true;
    }

    public void setHttps(boolean isHttps) {
        this.isHttps = isHttps;
    }
}

