/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HidPolicy;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.Utility;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class HidPolicyObject
extends PolicyIntObjectBase
implements TableRow {
    private Boolean enabled = false;
    private final DateFormat sdf = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

    public HidPolicyObject(HidPolicy hidPolicy) {
        super((TopLevelObject)hidPolicy);
    }

    public HidPolicyObject(PolicyIntObjectBase policyObject) {
        super(policyObject);
    }

    public HidPolicyObject(TopLevelObject policy) {
        super(policy);
    }

    public HidPolicyObject() {
        HashMap<String, TopLevelObject> newObj = new HashMap<String, TopLevelObject>();
        try {
            this.policy = PolicyHandler.getDefaultHidPolicy(newObj);
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex.getMessage());
        }
        if (this.policy == null) {
            this.policy = new HidPolicy();
            HidPolicy hidPolicy = (HidPolicy)this.policy;
            hidPolicy.setId(new GUIDGenerator().getGUIDString());
            hidPolicy.setName(Utilities.getLocalizedString("com.sygate.scm.console.ui.policy.ids.ids", "HidPolicyObject.DefaultPolicyName"));
        }
    }

    @Override
    protected PolicyObjectBase createPolicyObject(TopLevelObject policyObj) throws ConsoleException {
        if (!(policyObj instanceof HidPolicy)) {
            throw new ConsoleException(302645248, 32);
        }
        HidPolicyObject newObj = new HidPolicyObject((HidPolicy)policyObj);
        return newObj;
    }

    public HidPolicy getHidPolicy() {
        return (HidPolicy)this.policy;
    }

    @Override
    public String getTargetName() {
        return "HidPolicyApplied";
    }

    @Override
    public String getTargetType() {
        return "HidPolicy";
    }

    @Override
    public String getRefTargetName() {
        return ((HidPolicy)this.policy).getName();
    }

    @Override
    public String getLocalReferenceName() {
        return "LocalHidPolicy";
    }

    @Override
    public String getTypeDesc() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "HidLibraryObject.HidLibraryDesc");
    }

    public void setDesc(String desc) {
        ((HidPolicy)this.policy).setOptDescription(desc);
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.enabled;
            }
            case 1: {
                return ((HidPolicy)this.policy).getName();
            }
            case 2: {
                return ((HidPolicy)this.policy).getOptDescription();
            }
            case 3: {
                return "N/A";
            }
            case 4: {
                long latestT = PolicyHandler.getLatestT((ConfigObject)this.policy);
                Date updateTime = new Date(latestT);
                return this.sdf.format(updateTime);
            }
        }
        return "This should not happen";
    }

    @Override
    public Class<?> getValueTypeAt(int column) {
        switch (column) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    public boolean isDirty() {
        return true;
    }

    @Override
    public int getItemType() {
        return 306;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    @Override
    public boolean getEnabled() {
        return Utility.getBooleanValue((Boolean)((HidPolicy)this.policy).getOptEnable(), (Boolean)((HidPolicy)this.policy).getDefEnable());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ((HidPolicy)this.policy).setOptEnable(Boolean.valueOf(isEnabled));
    }

    @Override
    public String toString() {
        if (this.getEnabled()) {
            return this.getName();
        }
        Object[] args = new Object[]{this.getName(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.DisabledIPS")};
        return MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.ids.ids", "IdsLibraryObject.IPSName"), args);
    }

    @Override
    public String getCreator() {
        return null;
    }

    @Override
    public void setCreator(String creator) {
    }
}

