/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.HiCALL;
import com.sygate.scm.common.configobject.schema.HiCOMMENT;
import com.sygate.scm.common.configobject.schema.HiCONDITION;
import com.sygate.scm.common.configobject.schema.HiConditionBlock;
import com.sygate.scm.common.configobject.schema.HiIF;
import com.sygate.scm.common.configobject.schema.HiRETURN;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.configobject.schema.HiTHEN;
import com.sygate.scm.common.configobject.schema.UnknownContent;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.logicobject.HiCommentObject;
import com.sygate.scm.console.logicobject.HiIFObject;
import com.sygate.scm.console.logicobject.HiReturnObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class HiScriptBlockObject
extends AbstractUIObject {
    public static final int HICOMMENT = 0;
    public static final int HIRETURN = 3;
    public static final int HICALL = 1;
    public static final int HIIF = 2;
    private Set<JComponent> guiComponents = new HashSet<JComponent>();
    private HiScriptBlock _block;
    private ConfigObject _item;
    private int type;

    public HiScriptBlockObject() {
        this._block = this.generateBlock();
        this.init();
    }

    private HiScriptBlock generateBlock() {
        HiScriptBlock block = new HiScriptBlock();
        HiCOMMENT comment = this.createComment();
        block.setOptHiCOMMENT(comment);
        return block;
    }

    private HiCOMMENT createComment() {
        HiCOMMENT comment = new HiCOMMENT();
        comment.setOptContent("comment");
        return comment;
    }

    private HiIF createIf() {
        HiIF ifn = new HiIF();
        HiCONDITION condition = new HiCONDITION();
        HiCALL call = this.createHiCall();
        HiConditionBlock block = new HiConditionBlock();
        block.setOptHiCALL(call);
        condition.setHiConditionBlock(block);
        ifn.setHiCONDITION(condition);
        HiTHEN then = new HiTHEN();
        HiScriptBlock comment = this.generateBlock();
        then.addHiScriptBlock(comment);
        ifn.setHiTHEN(then);
        return ifn;
    }

    private HiCALL createHiCall() {
        HiCALL call = new HiCALL();
        call.setFuncName("     ");
        call.setOptComment("     ");
        UnknownContent unknow = new UnknownContent();
        call.setUnknownContent(unknow);
        unknow.setConent(new byte[]{0});
        return call;
    }

    private HiRETURN createHiReturn() {
        HiRETURN returnV = new HiRETURN();
        returnV.setOptReturnValue("PASS");
        return returnV;
    }

    public HiScriptBlockObject(HiScriptBlock block) {
        this._block = block;
        this.init();
    }

    private void init() {
        this._item = this._block.getOptHiCOMMENT();
        if (this._item != null) {
            this.type = 0;
            return;
        }
        this._item = this._block.getOptHiCALL();
        if (this._item != null) {
            this.type = 1;
            return;
        }
        this._item = this._block.getOptHiIF();
        if (this._item != null) {
            this.type = 2;
            return;
        }
        this._item = this._block.getOptHiRETURN();
        if (this._item != null) {
            this.type = 3;
            return;
        }
    }

    public DefaultMutableTreeNode[] getTreeNode() {
        ArrayList<DefaultMutableTreeNode> allNode = new ArrayList<DefaultMutableTreeNode>();
        switch (this.type) {
            case 2: {
                HiIF ifN = (HiIF)this._item;
                HiIFObject ifObj = new HiIFObject(ifN);
                DefaultMutableTreeNode[] allIfNode = ifObj.getTreeNode();
                allNode.addAll(Arrays.asList(allIfNode));
                break;
            }
            case 0: {
                HiCOMMENT _comment = (HiCOMMENT)this._item;
                HiCommentObject comObj = new HiCommentObject(_comment);
                allNode.add(new DefaultMutableTreeNode(comObj));
                break;
            }
            case 3: {
                HiRETURN _return = (HiRETURN)this._item;
                HiReturnObject retObj = new HiReturnObject(_return);
                allNode.add(new DefaultMutableTreeNode(retObj));
                break;
            }
            case 1: {
                HiCALL _call = (HiCALL)this._item;
                HiCALLObject callObj = new HiCALLObject(_call);
                allNode.add(new DefaultMutableTreeNode(callObj));
                break;
            }
        }
        return allNode.toArray(new DefaultMutableTreeNode[0]);
    }

    public String toString() {
        switch (this.type) {
            case 2: {
                return "IF";
            }
            case 3: {
                return ((HiRETURN)this._item).getOptReturnValue();
            }
            case 0: {
                HiCOMMENT comment = (HiCOMMENT)this._item;
                String content = comment.getOptContent();
                if (content == null) {
                    return "//";
                }
                return "//" + content;
            }
            case 1: {
                return ((HiCALL)this._item).getFuncName();
            }
        }
        return "UNKNOWN";
    }

    public HiScriptBlock getHiScriptBlock() {
        return this._block;
    }

    public int getType() {
        return this.type;
    }

    public void setTypeValue(int newType) {
        if (this.type != newType) {
            this.createNewType(newType);
        }
    }

    private void createNewType(int newType) {
        switch (this.type) {
            case 2: {
                this._block.setOptHiIF(null);
                break;
            }
            case 1: {
                this._block.setOptHiCALL(null);
                break;
            }
            case 3: {
                this._block.setOptHiRETURN(null);
                break;
            }
            case 0: {
                this._block.setOptHiCOMMENT(null);
                break;
            }
        }
        switch (newType) {
            case 2: {
                this._item = this.createIf();
                this.type = newType;
                this._block.setOptHiIF((HiIF)this._item);
                break;
            }
            case 1: {
                this._item = this.createHiCall();
                this.type = newType;
                this._block.setOptHiCALL((HiCALL)this._item);
                break;
            }
            case 3: {
                this._item = this.createHiReturn();
                this.type = newType;
                this._block.setOptHiRETURN((HiRETURN)this._item);
                break;
            }
            case 0: {
                this._item = this.createComment();
                this.type = newType;
                this._block.setOptHiCOMMENT((HiCOMMENT)this._item);
                break;
            }
        }
    }

    public String getComment() {
        if (this.type == 0) {
            HiCOMMENT comment = (HiCOMMENT)this._item;
            return comment.getOptContent() == null ? "" : comment.getOptContent();
        }
        return null;
    }

    public void setComment(String strCom) {
        if (this.type == 0) {
            HiCOMMENT comment = (HiCOMMENT)this._item;
            comment.setOptContent(strCom);
            this.refreshGui();
        }
    }

    private void refreshGui() {
        for (JComponent com : this.guiComponents) {
            com.updateUI();
        }
    }

    public void addRefreshGui(JComponent com) {
        this.guiComponents.add(com);
    }
}

