/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HiRETURN;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.hi.customized.ReturnPanel;
import com.sygate.scm.console.ui.policy.hi.logicobject.HiStatementNodeInt;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class HiReturnObject
extends AbstractUIObject
implements HiStatementNodeInt {
    public static final String RESULT_PASS = "PASS";
    public static final String RESULT_FAIL = "FAIL";
    public static final String I18N_RESULT_PASS = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "ReturnPanel.radio.Pass");
    public static final String I18N_RESULT_FAIL = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.hi.customized.hicustomized", "ReturnPanel.radio.Fail");
    private HiRETURN _return;
    private ReturnPanel _panel;

    public HiReturnObject() {
        this._return = this.createReturn();
    }

    private HiRETURN createReturn() {
        HiRETURN returnV = new HiRETURN();
        returnV.setOptReturnValue(RESULT_PASS);
        return returnV;
    }

    public HiReturnObject(HiRETURN retVal) {
        this._return = retVal;
    }

    @Override
    public DefaultMutableTreeNode[] getTreeNode() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
        return new DefaultMutableTreeNode[]{node};
    }

    public String toString() {
        if (RESULT_PASS.equals(this._return.getOptReturnValue())) {
            return I18N_RESULT_PASS;
        }
        return I18N_RESULT_FAIL;
    }

    @Override
    public JPanel getShowPanel() {
        if (this._panel == null) {
            this._panel = new ReturnPanel();
        }
        this._panel.setObject(this);
        return this._panel;
    }

    public String getResult() {
        return this._return.getOptReturnValue();
    }

    public boolean setResult(String string) {
        String oldValue = this.getResult();
        if (PolicyHandler.compareTwoObject(oldValue, string) == 0) {
            return false;
        }
        this._return.setOptReturnValue(string);
        return true;
    }

    @Override
    public boolean canAddCondition() {
        return false;
    }

    @Override
    public boolean canAddCommand() {
        return false;
    }

    public HiRETURN getHiReturn() {
        return this._return;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean delete() {
        HiScriptBlock sBlock = (HiScriptBlock)this._return.getParent();
        sBlock.getParent().removeChild((AbstractSchema)sBlock);
        return false;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        WashIDHandler washer = new WashIDHandler();
        HashMap<String, TopLevelObject> createdObjSet = new HashMap<String, TopLevelObject>();
        try {
            HiRETURN newCall = (HiRETURN)washer.duplicateObject((ConfigObject)this._return, createdObjSet);
            return new HiReturnObject(newCall);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            throw new ConsoleException(e);
        }
    }

    @Override
    public boolean isStatement() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public HiScriptBlock wrapWithABlock() {
        HiScriptBlock sBlock = new HiScriptBlock();
        sBlock.setOptHiRETURN(this._return);
        return sBlock;
    }
}

