/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HiCALL;
import com.sygate.scm.common.configobject.schema.HiCOMMENT;
import com.sygate.scm.common.configobject.schema.HiRETURN;
import com.sygate.scm.common.configobject.schema.HiReqSetting;
import com.sygate.scm.common.configobject.schema.HiRequirement;
import com.sygate.scm.common.configobject.schema.HiScript;
import com.sygate.scm.common.configobject.schema.HiScriptBlock;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.AbstractHIRequirementObject;
import com.sygate.scm.console.logicobject.HiCALLObject;
import com.sygate.scm.console.logicobject.HiScriptBlockObject;
import com.sygate.scm.console.logicobject.PhysicalFileObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.hi.predefined.HiPredefinedType;
import com.sygate.scm.console.ui.policy.hi.predefined.PredefinedType;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class HiRequirementObject
extends AbstractHIRequirementObject
implements CopitableObject {
    private HiRequirement _requirement;
    private PhysicalFileObject physicalFileObject;
    private Map<String, TopLevelObject> newObjSet = new HashMap<String, TopLevelObject>();

    public HiRequirementObject(ConfigObject parent) {
        this._requirement = this.generateCustomRequirement();
        this._requirement.setParent((AbstractSchema)parent);
    }

    public HiRequirementObject(ConfigObject parent, PredefinedType type) throws ConsoleException {
        int itype = type.getType();
        this._requirement = itype == 0 ? this.generateCustomRequirement() : this.generatePredefinedRequirement(type);
        this._requirement.setParent((AbstractSchema)parent);
    }

    public HiRequirementObject(HiRequirement requirement) {
        this._requirement = requirement;
    }

    public void addNewObject(Set<TopLevelObject> moreNewObjs) {
        PolicyHandler.dumpObjects(moreNewObjs, this.newObjSet);
    }

    public void addBlock(HiScriptBlockObject newBlockObj, int index) {
        HiScript script = this._requirement.getHiScript();
        Vector scriptBlock = script.getHiScriptBlock();
        int realIndex = PolicyHandler.getRealIndexOfScriptBlock(scriptBlock, index);
        script.addHiScriptBlock(realIndex, newBlockObj.getHiScriptBlock());
    }

    public void delete() {
        this._requirement.getParent().removeChild((AbstractSchema)this._requirement);
    }

    @Override
    public boolean isGroupObject() {
        return false;
    }

    private HiRequirement generateCustomRequirement() {
        HiRequirement require = new HiRequirement();
        String id = new GUIDGenerator().getGUIDString();
        require.setId(id);
        HiReqSetting setting = new HiReqSetting();
        require.setHiReqSetting(setting);
        HiScript script = new HiScript();
        require.setHiScript(script);
        HiCOMMENT comment = new HiCOMMENT();
        comment.setOptContent(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HiRequirementObject.cmtInsertStatementsBelow"));
        HiScriptBlock block = new HiScriptBlock();
        block.setOptHiCOMMENT(comment);
        script.addHiScriptBlock(block);
        HiRETURN ret = new HiRETURN();
        ret.setOptReturnValue("PASS");
        block = new HiScriptBlock();
        block.setOptHiRETURN(ret);
        script.addHiScriptBlock(block);
        return require;
    }

    private HiRequirement generatePredefinedRequirement(PredefinedType type) throws ConsoleException {
        HiRequirement requirement = new HiRequirement();
        String id = new GUIDGenerator().getGUIDString();
        requirement.setId(id);
        HiReqSetting setting = new HiReqSetting();
        requirement.setHiReqSetting(setting);
        HiScript script = new HiScript();
        requirement.setHiScript(script);
        HiCALLObject callObj = new HiCALLObject(this.getClientTypeString());
        callObj.setFunctionType(type);
        HiScriptBlock newBlock = new HiScriptBlock();
        HiRETURN hiReturn = new HiRETURN();
        hiReturn.setOptHiCALL(callObj.getHiCall());
        newBlock.setOptHiRETURN(hiReturn);
        script.addHiScriptBlock(newBlock);
        return requirement;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        WashIDHandler washer = new WashIDHandler();
        HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
        try {
            HiRequirement newRequirement = (HiRequirement)washer.duplicateObject((ConfigObject)this._requirement, createdObj);
            try {
                System.out.println("Old HIRequirement:");
                System.out.println(this._requirement.getString());
                System.out.println("new HIRequirement:");
                System.out.println(newRequirement.getString());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            HiRequirementObject newReqObj = new HiRequirementObject(newRequirement);
            newReqObj.addNewObject(new HashSet<TopLevelObject>(createdObj.values()));
            return newReqObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public boolean getEnabled() {
        Boolean enable = this._requirement.getOptEnable();
        if (enable == null) {
            enable = this._requirement.getDefEnable();
        }
        return enable;
    }

    public boolean setEnabled(boolean newValue) {
        boolean oldValue = this.getEnabled();
        if (oldValue == newValue && this._requirement.getOptEnable() != null) {
            return false;
        }
        this._requirement.setOptEnable(Boolean.valueOf(newValue));
        return true;
    }

    public String getName() {
        return this._requirement.getName();
    }

    public boolean setName(String newValue) {
        String oldValue = this.getName();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) == 0) {
            return false;
        }
        this._requirement.setName(newValue);
        return true;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return null;
            }
            case 1: {
                AbstractHIRequirementObject.RequirementNameItem item = new AbstractHIRequirementObject.RequirementNameItem(this.getName(), false);
                return item;
            }
            case 2: {
                return this.getEnabled();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 2: {
                if (value == null) break;
                Boolean b = (Boolean)value;
                this.setEnabled(b);
                break;
            }
        }
    }

    public DefaultMutableTreeNode[] getTreeNode() {
        HiScript script = this._requirement.getHiScript();
        Vector blocks = script.getHiScriptBlock();
        ArrayList<DefaultMutableTreeNode> allNodes = new ArrayList<DefaultMutableTreeNode>();
        for (HiScriptBlock block : blocks) {
            HiScriptBlockObject bObj = new HiScriptBlockObject(block);
            DefaultMutableTreeNode[] subNodes = bObj.getTreeNode();
            allNodes.addAll(Arrays.asList(subNodes));
        }
        return allNodes.toArray(new DefaultMutableTreeNode[0]);
    }

    public HiRequirement getHiRequirement() {
        return this._requirement;
    }

    public HiRequirementObject getClone() throws ConsoleException {
        HiRequirement newReq = (HiRequirement)PolicyHandler.getCopyOfObj((ConfigObject)this._requirement);
        return new HiRequirementObject(newReq);
    }

    public boolean setCancelable(boolean b) {
        boolean oldValue = this.getCancelable();
        if (oldValue == b) {
            return false;
        }
        HiReqSetting setting = this._requirement.getHiReqSetting();
        setting.setOptCancelable(Boolean.valueOf(b));
        return true;
    }

    public boolean getCancelable() {
        HiReqSetting setting = this._requirement.getHiReqSetting();
        Boolean cancel = setting.getOptCancelable();
        if (cancel == null) {
            cancel = setting.getDefCancelable();
        }
        return cancel;
    }

    public String getOptModeValue() {
        HiReqSetting setting = this._requirement.getHiReqSetting();
        String mode = null;
        try {
            mode = setting.getOptModeValue();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (mode == null) {
            int i = setting.getDefMode();
            mode = i == 0 ? "NORMAL" : "TEST";
        }
        return mode;
    }

    public boolean setOptModeValue(String modeValue) {
        HiReqSetting setting = this._requirement.getHiReqSetting();
        try {
            String prevMode = setting.getOptModeValue();
            if (prevMode != null && prevMode.equals(modeValue)) {
                return false;
            }
            setting.setOptModeValue(modeValue);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return true;
    }

    public HiCALLObject getPredefinedCallObj() throws ConsoleException {
        String funcName;
        HiScriptBlock block;
        HiRETURN hiReturn;
        HiScript script = this._requirement.getHiScript();
        HiCALL hiCall = null;
        if (script.getHiScriptBlockCount() > 0 && (hiReturn = (block = script.getHiScriptBlock(0)).getOptHiRETURN()) != null && (hiCall = hiReturn.getOptHiCALL()) != null && ((funcName = hiCall.getFuncName()).equals("EnforceAv") || funcName.equals("EnforceFw") || funcName.equals("EnforceAsw") || funcName.equals("EnforceServicePack") || funcName.equals("EnforcePatch"))) {
            return new HiCALLObject(hiCall);
        }
        HiCALLObject callObj = new HiCALLObject(this.getClientTypeString());
        callObj.setFunctionType(PredefinedType.getTYPESByIndex(0));
        HiScriptBlock newBlock = new HiScriptBlock();
        HiRETURN hiReturn2 = new HiRETURN();
        hiReturn2.setOptHiCALL(callObj.getHiCall());
        newBlock.setOptHiRETURN(hiReturn2);
        Vector allBlock = script.getHiScriptBlock();
        for (HiScriptBlock sBlock : allBlock) {
            script.removeHiScriptBlock(sBlock);
        }
        script.addHiScriptBlock(newBlock);
        return callObj;
    }

    public void setPredefinedCallObj(PredefinedType type) throws ConsoleException {
        HiScriptBlock block;
        HiRETURN hiReturn;
        HiScript script = this._requirement.getHiScript();
        HiCALL hiCall = null;
        if (script.getHiScriptBlockCount() > 0 && (hiReturn = (block = script.getHiScriptBlock(0)).getOptHiRETURN()) != null) {
            hiCall = hiReturn.getOptHiCALL();
            if (hiCall != null) {
                String funcName = hiCall.getFuncName();
                if (funcName.equals(type.getFuncName())) {
                    return;
                }
            } else {
                HiCALLObject callObj = new HiCALLObject(this.getClientTypeString());
                callObj.setFunctionType(type);
                hiReturn.setOptHiCALL(callObj.getHiCall());
                return;
            }
        }
        HiCALLObject callObj = new HiCALLObject(this.getClientTypeString());
        callObj.setFunctionType(type);
        HiScriptBlock newBlock = new HiScriptBlock();
        HiRETURN hiReturn2 = new HiRETURN();
        hiReturn2.setOptHiCALL(callObj.getHiCall());
        newBlock.setOptHiRETURN(hiReturn2);
        Vector allBlock = script.getHiScriptBlock();
        for (HiScriptBlock sBlock : allBlock) {
            script.removeHiScriptBlock(sBlock);
        }
        script.addHiScriptBlock(newBlock);
    }

    public boolean isCustomRequirement() {
        String funcName;
        HiScriptBlock block;
        HiRETURN hiReturn;
        HiScript script = this._requirement.getHiScript();
        HiCALL hiCall = null;
        return script.getHiScriptBlockCount() <= 0 || (hiReturn = (block = script.getHiScriptBlock(0)).getOptHiRETURN()) == null || (hiCall = hiReturn.getOptHiCALL()) == null || !(funcName = hiCall.getFuncName()).equals("EnforceAv") && !funcName.equals("EnforceAsw") && !funcName.equals("EnforceFw") && !funcName.equals("EnforceServicePack") && !funcName.equals("EnforcePatch");
    }

    public void setPhysicalFileObject(PhysicalFileObject obj) {
        this.physicalFileObject = obj;
    }

    public PhysicalFileObject getPhysicalFileObject() {
        return this.physicalFileObject;
    }

    public void setCustomRequirement() {
        String funcName;
        HiScriptBlock block;
        HiRETURN hiReturn;
        HiScript script = this._requirement.getHiScript();
        HiCALL hiCall = null;
        if (script.getHiScriptBlockCount() > 0 && (hiReturn = (block = script.getHiScriptBlock(0)).getOptHiRETURN()) != null && (hiCall = hiReturn.getOptHiCALL()) != null && ((funcName = hiCall.getFuncName()).equals("EnforceAv") || funcName.equals("EnforceAsw") || funcName.equals("EnforceFw") || funcName.equals("EnforceServicePack") || funcName.equals("EnforcePatch"))) {
            Vector allBlock = script.getHiScriptBlock();
            for (HiScriptBlock sBlock : allBlock) {
                script.removeHiScriptBlock(sBlock);
            }
            HiCOMMENT comment = new HiCOMMENT();
            comment.setOptContent(MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "HiRequirementObject.cmtInsertStatementsBelow"));
            block = new HiScriptBlock();
            block.setOptHiCOMMENT(comment);
            script.addHiScriptBlock(block);
            HiRETURN ret = new HiRETURN();
            ret.setOptReturnValue("PASS");
            block = new HiScriptBlock();
            block.setOptHiRETURN(ret);
            script.addHiScriptBlock(block);
        }
    }

    public String getClientTypeString() {
        if (this._requirement == null) {
            return "Windows";
        }
        String osType = this._requirement.getOptReqOsType();
        if (StringUtilities.isEmpty((String)osType)) {
            return this._requirement.getDefReqOsType();
        }
        return this._requirement.getOptReqOsType();
    }

    public String getClientTypeDisplayValue() {
        String clientType = this.getClientTypeString();
        HiPredefinedType[] clientTypes = PredefinedType.getHiOsTypes();
        for (int i = 0; i < clientTypes.length; ++i) {
            HiPredefinedType type = clientTypes[i];
            if (!clientType.equalsIgnoreCase(type.getValue())) continue;
            return type.getDescription();
        }
        return "";
    }

    public void setOsTypeString(String osType) {
        if (StringUtilities.isEmpty((String)osType)) {
            this._requirement.setOptReqOsType(this._requirement.getDefReqOsType());
        } else {
            this._requirement.setOptReqOsType(osType);
        }
    }
}

