/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.console.logicobject.AbstractHIRequirementObject;
import com.sygate.scm.console.logicobject.HiRequirementObject;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class HiRequirementGroupObject
extends AbstractHIRequirementObject {
    private String groupName;
    private boolean isFolded;
    private GROUP_TYPES groupType;
    private List<HiRequirementObject> groupObjs;
    private HostIntegrityObject hiObj;

    public HiRequirementGroupObject(String groupName, GROUP_TYPES type, HostIntegrityObject hiObj) {
        this.groupName = groupName;
        this.groupType = type;
        this.hiObj = hiObj;
        this.groupObjs = new Vector<HiRequirementObject>();
        this.setFolded(true);
    }

    public boolean isFolded() {
        return this.isFolded;
    }

    public void setHostIntegrityObject(HostIntegrityObject hiObj) {
        this.hiObj = hiObj;
    }

    public void setFolded(boolean isFolded) {
        this.isFolded = isFolded;
        this.updateObjects();
    }

    public GROUP_TYPES getGroupType() {
        return this.groupType;
    }

    public List<HiRequirementObject> getHiRequirementObjectsInGroup() {
        return Collections.unmodifiableList(this.groupObjs);
    }

    public void addHIRequirementObject(HiRequirementObject obj) {
        this.groupObjs.add(obj);
    }

    public void removeRequirementObject(HiRequirementObject obj) {
        this.groupObjs.remove(obj);
    }

    public int getActualHIRequirementCount() {
        switch (this.getGroupType()) {
            case GROUP_TYPE_MAC: {
                return this.hiObj.getAllMacReqWithoutCancelableTable().size();
            }
            case GROUP_TYPE_WINDOWS: {
                return this.hiObj.getAllWindowsReqWithoutCancelableTable().size();
            }
        }
        return 0;
    }

    public void updateObjects() {
        if (this.isFolded) {
            this.groupObjs.clear();
        } else {
            this.getHIRequirement();
        }
    }

    private void getHIRequirement() {
        this.groupObjs.clear();
        if (this.hiObj == null) {
            return;
        }
        switch (this.getGroupType()) {
            case GROUP_TYPE_MAC: {
                this.groupObjs.addAll(this.hiObj.getAllMacReqWithoutCancelableTable());
                break;
            }
            case GROUP_TYPE_WINDOWS: {
                this.groupObjs.addAll(this.hiObj.getAllWindowsReqWithoutCancelableTable());
                break;
            }
        }
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.isFolded;
            }
            case 1: {
                AbstractHIRequirementObject.RequirementNameItem item = new AbstractHIRequirementObject.RequirementNameItem(this.groupName, true);
                return item;
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                if (value == null || !(value instanceof Boolean)) break;
                Boolean isFolded = (Boolean)value;
                this.setFolded(isFolded);
                break;
            }
        }
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return AbstractHIRequirementObject.RequirementNameItem.class;
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isGroupObject() {
        return true;
    }

    public static enum GROUP_TYPES {
        GROUP_TYPE_WINDOWS,
        GROUP_TYPE_MAC;

    }
}

